/*
 * Decompiled with CFR 0.152.
 */
package moj;

import com.topcoder.client.contestApplet.common.LocalPreferences;
import java.io.IOException;

public class Preferences {
    private static LocalPreferences pref = LocalPreferences.getInstance();
    public static final String KEY_TARGETCOMPILER = "moj.config.targetcompiler";
    public static final String KEY_NUMPLACEHOLDERS = "moj.config.numplaceholders";
    public static final String KEY_LANGUAGESWITCHWORKAROUND = "moj.config.languageswitchworkaround";
    public static final String KEY_ENABLEJAVASUPPORT = "moj.config.enablejavasupport";
    public static final String TARGETCOMPILER_GCC11 = "GCC -std=c++11";
    public static final String TARGETCOMPILER_GCC98 = "GCC (deprecated)";
    public static final String TARGETCOMPILER_VC = "Visual C++";
    public static final String TARGETCOMPILER_DEFAULT = "GCC -std=c++11";

    public String getTargetCompiler() {
        String compiler = this.getStringProperty(KEY_TARGETCOMPILER, "GCC -std=c++11");
        if (!(compiler.equals("GCC -std=c++11") || compiler.equals(TARGETCOMPILER_GCC98) || compiler.equals(TARGETCOMPILER_VC))) {
            compiler = "GCC -std=c++11";
        }
        return compiler;
    }

    public void setTargetCompiler(String compiler) {
        pref.setProperty(KEY_TARGETCOMPILER, compiler);
    }

    public int getNumPlaceholders() {
        return this.getIntegerProperty(KEY_NUMPLACEHOLDERS, 3);
    }

    public void setNumPlaceholders(int numPlaceholders) {
        pref.setProperty(KEY_NUMPLACEHOLDERS, "" + numPlaceholders);
    }

    public boolean getEnableJavaSupport() {
        return this.getBooleanProperty(KEY_ENABLEJAVASUPPORT, true);
    }

    public void setEnableJavaSupport(boolean enabled) {
        pref.setProperty(KEY_ENABLEJAVASUPPORT, enabled ? "true" : "false");
    }

    public boolean getLanguageSwitchWorkaround() {
        return this.getBooleanProperty(KEY_LANGUAGESWITCHWORKAROUND, true);
    }

    public void setLanguageSwitchWorkaround(boolean enabled) {
        pref.setProperty(KEY_LANGUAGESWITCHWORKAROUND, enabled ? "true" : "false");
    }

    protected String getStringProperty(String key, String defaultValue) {
        String value = pref.getProperty(key);
        return value == null || value.equals("") ? defaultValue : value;
    }

    protected boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = pref.getProperty(key);
        return value == null || value.equals("") ? defaultValue : value.equals("true");
    }

    protected int getIntegerProperty(String key, int defaultValue) {
        String value = pref.getProperty(key);
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void save() throws IOException {
        pref.savePreferences();
    }
}

