/*
 * Decompiled with CFR 0.152.
 */
package moj;

import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.language.JavaLanguage;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.InvalidTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import moj.JavaHarnessGenerator;
import moj.Preferences;
import moj.mocks.DataTypeFactoryMock;
import moj.mocks.PreferencesMock;
import moj.mocks.ProblemComponentModelMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class JavaParameterTest {
    private String typename;
    private String value;
    private String expected;
    JavaHarnessGenerator generator;
    ArrayList<String> code;

    public JavaParameterTest(String typename, String varval, String expected) {
        this.typename = typename;
        this.value = varval;
        this.expected = expected;
    }

    @Before
    public void setUp() {
        this.generator = new JavaHarnessGenerator((ProblemComponentModel)new ProblemComponentModelMock(), (Language)JavaLanguage.JAVA_LANGUAGE, (Preferences)new PreferencesMock());
        this.code = new ArrayList();
    }

    static String compressSpaceBeforeEquals(String str) {
        return str.replaceFirst("\\s*=", " =").trim();
    }

    @Parameterized.Parameters
    public static List<Object[]> data() {
        Object[][] data = new Object[][]{{"int", "-2147483648", "int var = -2147483648;"}, {"String", "\"test string\"", "String var = \"test string\";"}, {"String", "\"   multiple  spaces  \"", "String var = \"   multiple  spaces  \";"}, {"String", "\"  a  =  3  \"", "String var = \"  a  =  3  \";"}, {"double", "1.345e08", "double var = 1.345e08;"}, {"long", "123", "long var = 123;"}, {"long", "-9999999999", "long var = -9999999999L;"}, {"long", "2147483648", "long var = 2147483648L;"}, {"int[]", "{-2147483648, 2147483647, 0, -1, 555}", "int[] var = {-2147483648, 2147483647, 0, -1, 555};"}, {"int[]", "{}", "int[] var = {};"}, {"String[]", "{\"a\",\n \"\",\n \"test test\"}", "String[] var = {\"a\",\n \"\",\n \"test test\"};"}, {"String[]", "{\"spaces  space\", \"a   a\"}", "String[] var = {\"spaces  space\", \"a   a\"};"}, {"double[]", "{ 1e9, -3.e-012, -4, 5 }", "double[] var = { 1e9, -3.e-012, -4, 5 };"}, {"long[]", "{ 0, -1, 1, 2147483648,\n-2147483649, 9223372036854775807, -9223372036854775808}", "long[] var = {0, -1, 1, 2147483648L, -2147483649L, 9223372036854775807L, -9223372036854775808L};"}};
        return Arrays.asList(data);
    }

    @Test
    public void test() throws InvalidTypeException {
        DataType dt = DataTypeFactoryMock.getDataType((String)this.typename);
        this.generator.generateParameter(this.code, dt, "var", this.value, false);
        String result = JavaParameterTest.compressSpaceBeforeEquals(this.code.get(0).toString());
        Assert.assertEquals((Object)this.expected, (Object)result);
    }
}

