/*
 * Decompiled with CFR 0.152.
 */
package moj;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import moj.Common;
import moj.Preferences;

class ConfigurationDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6205878572134421087L;
    private Preferences pref;
    private ButtonGroup compilerButtonGroup = new ButtonGroup();
    private JRadioButton gcc11RadioButton = new JRadioButton("GCC -std=c++11");
    private JRadioButton gcc98RadioButton = new JRadioButton("Older GCC");
    private JRadioButton vcRadioButton = new JRadioButton("Visual C++");
    private JTextField placeholdersTextField = new JTextField();
    private JCheckBox switchCheckBox = new JCheckBox();
    private JCheckBox javaSupportCheckBox = new JCheckBox();
    private JButton saveButton = new JButton("Save");
    private JButton closeButton = new JButton("Close");
    private WindowHandler windowHandler = new WindowHandler();

    public ConfigurationDialog(Preferences pref) {
        super((Frame)null, "moj configuration", true);
        this.pref = pref;
        this.setSize(new Dimension(600, 400));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setForeground(Common.FG_COLOR);
        contentPane.setBackground(Common.WPB_COLOR);
        JLabel compilerLabel = new JLabel("Target compiler:");
        compilerLabel.setForeground(Common.FG_COLOR);
        compilerLabel.setBackground(Common.WPB_COLOR);
        compilerLabel.setToolTipText("Select the compiler you will be using. moj needs to make adjustments to the testing code for it to compile under Visual C++.");
        this.compilerButtonGroup.add(this.gcc11RadioButton);
        this.compilerButtonGroup.add(this.gcc98RadioButton);
        this.compilerButtonGroup.add(this.vcRadioButton);
        String current_compiler = pref.getTargetCompiler();
        if (current_compiler.equals("GCC -std=c++11")) {
            this.gcc11RadioButton.setSelected(true);
        } else if (current_compiler.equals("GCC (deprecated)")) {
            this.gcc98RadioButton.setSelected(true);
        } else {
            this.vcRadioButton.setSelected(true);
        }
        Enumeration<AbstractButton> eRadio = this.compilerButtonGroup.getElements();
        while (eRadio.hasMoreElements()) {
            JRadioButton button = (JRadioButton)eRadio.nextElement();
            button.setForeground(Common.FG_COLOR);
            button.setBackground(Common.WPB_COLOR);
            button.setText("<html><body><font color=\"#ffffff\">" + button.getText() + "</font></body></html>");
        }
        JLabel placeholdersLabel = new JLabel("Test case placeholders:");
        placeholdersLabel.setForeground(Common.FG_COLOR);
        placeholdersLabel.setBackground(Common.WPB_COLOR);
        placeholdersLabel.setToolTipText("Set the number of empty test case placeholders to be generated. You can use these to enter your own test cases while solving the problem.");
        this.placeholdersTextField.setText("" + pref.getNumPlaceholders());
        this.switchCheckBox.setText("Enable workaround for FileEdit language switching issue");
        this.switchCheckBox.setForeground(Common.FG_COLOR);
        this.switchCheckBox.setBackground(Common.WPB_COLOR);
        this.switchCheckBox.setToolTipText("If checked, moj will try to allow you to switch between languages mid-contest.");
        this.switchCheckBox.setSelected(pref.getLanguageSwitchWorkaround());
        this.javaSupportCheckBox.setText("Enable Java test code generation");
        this.javaSupportCheckBox.setForeground(Common.FG_COLOR);
        this.javaSupportCheckBox.setBackground(Common.WPB_COLOR);
        this.javaSupportCheckBox.setToolTipText("Uncheck if you want to use a different plug-in to generate Java test code.");
        this.javaSupportCheckBox.setSelected(pref.getEnableJavaSupport());
        contentPane.add((Component)compilerLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 4, 4), 0, 0));
        contentPane.add((Component)this.gcc11RadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 4, 4), 0, 0));
        contentPane.add((Component)this.gcc98RadioButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 4, 4), 0, 0));
        contentPane.add((Component)this.vcRadioButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 4, 4), 0, 0));
        contentPane.add((Component)placeholdersLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 4, 4), 0, 0));
        contentPane.add((Component)this.placeholdersTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 4, 4), 0, 0));
        contentPane.add((Component)this.switchCheckBox, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 4, 4), 0, 0));
        contentPane.add((Component)this.javaSupportCheckBox, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 4, 4), 0, 0));
        contentPane.add((Component)this.saveButton, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        contentPane.add((Component)this.closeButton, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 10), 0, 0));
        this.saveButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowHandler);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.saveButton) {
            this.save();
        } else if (src == this.closeButton) {
            this.windowHandler.windowClosing(new WindowEvent(this, 201));
        }
    }

    private String getSelectedCompiler() {
        return this.gcc11RadioButton.isSelected() ? "GCC -std=c++11" : (this.gcc98RadioButton.isSelected() ? "GCC (deprecated)" : "Visual C++");
    }

    public boolean save() {
        int numPlaceholders;
        try {
            numPlaceholders = Integer.valueOf(this.placeholdersTextField.getText());
        }
        catch (NumberFormatException e) {
            Common.showError("Parse error", "\"" + this.placeholdersTextField.getText() + "\" is not a valid integer.", null);
            return false;
        }
        if (numPlaceholders < 0 || numPlaceholders > 50) {
            Common.showError("Parse error", "The number of placeholders must be between 0 and 50.", null);
            return false;
        }
        try {
            this.pref.setTargetCompiler(this.getSelectedCompiler());
            this.pref.setNumPlaceholders(numPlaceholders);
            this.pref.save();
            Common.showMessage("Save", "Preferences were saved successfully", null);
            return true;
        }
        catch (IOException e) {
            Common.showError("Error saving preferences", e.toString(), null);
            return false;
        }
    }

    public static void main(String[] args) {
        new ConfigurationDialog(null).setVisible(true);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            boolean savePending = false;
            boolean bl = savePending = !ConfigurationDialog.this.getSelectedCompiler().equals(ConfigurationDialog.this.pref.getTargetCompiler()) || !ConfigurationDialog.this.placeholdersTextField.getText().equals("" + ConfigurationDialog.this.pref.getNumPlaceholders()) || ConfigurationDialog.this.switchCheckBox.isSelected() != ConfigurationDialog.this.pref.getLanguageSwitchWorkaround() || ConfigurationDialog.this.javaSupportCheckBox.isSelected() != ConfigurationDialog.this.pref.getEnableJavaSupport();
            if (savePending && Common.confirm("Save Pending", "Changes are pending.  Do you want to save before closing?", null) && !ConfigurationDialog.this.save()) {
                return;
            }
            ConfigurationDialog.this.dispose();
        }
    }
}

