/*
 * Decompiled with CFR 0.152.
 */
package moj;

import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.language.CPPLanguage;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.InvalidTypeException;
import java.util.Arrays;
import java.util.List;
import moj.CPPHarnessGenerator;
import moj.Preferences;
import moj.mocks.DataTypeFactoryMock;
import moj.mocks.PreferencesMock;
import moj.mocks.ProblemComponentModelMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class CPPParameterTest {
    private String typename;
    private String value;
    private String expected;
    CPPHarnessGenerator generator;
    CPPHarnessGenerator.TestCodeGenerationState code;

    public CPPParameterTest(String typename, String varval, String expected) {
        this.typename = typename;
        this.value = varval;
        this.expected = expected;
    }

    @Before
    public void setUp() {
        this.generator = new CPPHarnessGenerator((ProblemComponentModel)new ProblemComponentModelMock(), (Language)CPPLanguage.CPP_LANGUAGE, (Preferences)new PreferencesMock());
        this.code = new CPPHarnessGenerator.TestCodeGenerationState();
    }

    static String compressSpaceBeforeEquals(String str) {
        return str.replaceFirst("\\s*=", " =").trim();
    }

    @Parameterized.Parameters
    public static List<Object[]> data() {
        Object[][] data = new Object[][]{{"int", "-2147483648", "int var = -2147483648;"}, {"String", "\"test string\"", "string var = \"test string\";"}, {"String", "\"   multiple  spaces  \"", "string var = \"   multiple  spaces  \";"}, {"String", "\"  a  =  3  \"", "string var = \"  a  =  3  \";"}, {"double", "1.345e08", "double var = 1.345e08;"}, {"long", "123", "long long var = 123;"}, {"long", "-9999999999", "long long var = -9999999999LL;"}, {"long", "2147483648", "long long var = 2147483648LL;"}, {"int[]", "{-2147483648, 2147483647, 0, -1, 555}", "int var[] = {-2147483648, 2147483647, 0, -1, 555};"}, {"int[]", "{}", "int var[] = {};"}, {"String[]", "{\"a\",\n \"\",\n \"test test\"}", "string var[] = {\"a\",\n \"\",\n \"test test\"};"}, {"String[]", "{\"spaces  space\", \"a   a\"}", "string var[] = {\"spaces  space\", \"a   a\"};"}, {"double[]", "{ 1e9, -3.e-012, -4, 5 }", "double var[] = { 1e9, -3.e-012, -4, 5 };"}, {"long[]", "{ 0, -1, 1, 2147483648,\n-2147483649, 9223372036854775807, -9223372036854775808}", "long long var[] = {0, -1, 1, 2147483648LL, -2147483649LL, 9223372036854775807LL, -9223372036854775808LL};"}};
        return Arrays.asList(data);
    }

    @Test
    public void test() throws InvalidTypeException {
        DataType dt = DataTypeFactoryMock.getDataType((String)this.typename);
        this.generator.generateParameter(this.code, dt, "var", this.value, false);
        String result = CPPParameterTest.compressSpaceBeforeEquals(this.code.lines.get(0).toString());
        Assert.assertEquals((Object)this.expected, (Object)result);
    }
}

