/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter.rules;

import com.topcoder.util.syntaxhighlighter.ContentSegment;
import com.topcoder.util.syntaxhighlighter.HighlightedSequence;
import com.topcoder.util.syntaxhighlighter.rules.Rule;
import com.topcoder.util.syntaxhighlighter.rules.RuleHelper;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WordMatchRule
implements Rule {
    private final Set wordList = new HashSet();

    public WordMatchRule(Node node) {
        RuleHelper.checkNull(node, "node");
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("node is not a element.");
        }
        String[] stringArray = RuleHelper.getNodeText(RuleHelper.getSingleChildElementByName((Element)node, "wordlist")).split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.checkAndAddWord(stringArray[i])) continue;
            throw new IllegalArgumentException(stringArray[i] + " is not a valid word.");
        }
        NodeList nodeList = ((Element)node).getElementsByTagName("word");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getParentNode() != node) {
                throw new IllegalArgumentException("some word nodes are not the wordMatchRule's children.");
            }
            if (this.checkAndAddWord(RuleHelper.getNodeText(node2))) continue;
            throw new IllegalArgumentException(RuleHelper.getNodeText(node2) + " is not a valid word.");
        }
    }

    public Rule.Point getToken(HighlightedSequence highlightedSequence) {
        RuleHelper.checkNull(highlightedSequence, "sequence");
        ContentSegment contentSegment = highlightedSequence.getNextToken();
        while (contentSegment != null) {
            if (this.wordList.contains(contentSegment.getContent())) {
                return new Rule.Point(contentSegment.getStart(), contentSegment.getEnd());
            }
            contentSegment = highlightedSequence.getNextToken();
        }
        return null;
    }

    private boolean checkAndAddWord(String string) {
        if (this.isValidWord(string = string.trim())) {
            this.wordList.add(string);
            return true;
        }
        return false;
    }

    private boolean isValidWord(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

