/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter.rules;

import com.topcoder.util.syntaxhighlighter.HighlightedSequence;
import com.topcoder.util.syntaxhighlighter.rules.Rule;
import com.topcoder.util.syntaxhighlighter.rules.RuleHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PatternMatchRule
implements Rule {
    private final Pattern pattern;

    public PatternMatchRule(Node node) {
        RuleHelper.checkNull(node, "node");
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("node is not a element.");
        }
        String string = RuleHelper.getNodeTextWithoutTrimEmptyCheck(RuleHelper.getSingleChildElementByName((Element)node, "pattern"));
        try {
            this.pattern = Pattern.compile(string, 32);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Problems occurs in pattern's compile.");
        }
    }

    public Rule.Point getToken(HighlightedSequence highlightedSequence) {
        Matcher matcher = this.pattern.matcher(highlightedSequence);
        return matcher.find() ? new Rule.Point(matcher.start(), matcher.end()) : null;
    }
}

