/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter.rules;

import com.topcoder.util.syntaxhighlighter.HighlightedSequence;
import com.topcoder.util.syntaxhighlighter.rules.Rule;
import com.topcoder.util.syntaxhighlighter.rules.RuleHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BlockMatchRule
implements Rule {
    private final String startDelimiter;
    private final String endDelimiter;

    public BlockMatchRule(Node node) {
        RuleHelper.checkNull(node, "node");
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("node is not a element.");
        }
        this.startDelimiter = RuleHelper.getNodeTextWithoutTrimEmptyCheck(RuleHelper.getSingleChildElementByName((Element)node, "startDelimiter"));
        this.endDelimiter = RuleHelper.getNodeTextWithoutTrimEmptyCheck(RuleHelper.getSingleChildElementByName((Element)node, "endDelimiter"));
    }

    public Rule.Point getToken(HighlightedSequence highlightedSequence) {
        int n = highlightedSequence.indexOf(this.startDelimiter);
        if (n >= 0) {
            int n2 = highlightedSequence.indexOf(this.endDelimiter, n + this.startDelimiter.length());
            n2 = n2 < 0 ? highlightedSequence.length() : (n2 += this.endDelimiter.length());
            return new Rule.Point(n, n2);
        }
        return null;
    }
}

