/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.syntaxhighlighter.ContentSegment;
import com.topcoder.util.syntaxhighlighter.HighlightedOutput;
import com.topcoder.util.syntaxhighlighter.SHHelper;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;

public class HtmlOutput
implements HighlightedOutput {
    private String text = null;
    private static int tabSize = 4;

    public HtmlOutput(int n) {
        tabSize = n;
    }

    public void setText(ContentSegment[] contentSegmentArray) {
        SHHelper.checkNull(contentSegmentArray, "contentSegments");
        if (contentSegmentArray.length == 0) {
            throw new IllegalArgumentException("contentSegments should not contain no elements.");
        }
        try {
            Arrays.sort(contentSegmentArray);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Some elements of contentSegments are of wrong type.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < contentSegmentArray.length; ++i) {
            String string;
            if (contentSegmentArray[i] == null) {
                throw new IllegalArgumentException("Some elements of contentSegments are null or illegal.");
            }
            String string2 = this.stringToHtml(contentSegmentArray[i].getContent());
            TextStyle textStyle = contentSegmentArray[i].getStyle();
            if (textStyle == null) {
                stringBuffer.append(string2);
                continue;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            Font font = textStyle.getFont();
            Color color = textStyle.getColor();
            Color color2 = textStyle.getBGColor();
            if (font != null) {
                stringBuffer2.append("font-family: " + font.getFamily());
                stringBuffer2.append("; font-size: " + font.getSize() + "pt");
                if (font.isItalic()) {
                    stringBuffer2.append("; font-style: italic");
                }
                if (font.isBold()) {
                    stringBuffer2.append("; font-weight: bold");
                }
                stringBuffer2.append("; ");
            }
            if (color != null) {
                stringBuffer2.append("color: " + HtmlOutput.colorToString(color) + "; ");
            }
            if (color2 != null) {
                stringBuffer2.append("background-color: " + HtmlOutput.colorToString(color2) + "; ");
            }
            if ((string = stringBuffer2.toString()).trim().length() > 0) {
                stringBuffer.append("<font style=\"" + string + "\">" + string2 + "</font>");
                continue;
            }
            stringBuffer.append(string2);
        }
        this.text = stringBuffer.toString();
        this.text = this.text.replaceAll("\r", "");
    }

    public String getText() {
        return this.text;
    }

    private String stringToHtml(String string) {
        return HtmlOutput.convertStringToHtml(string);
    }

    private static String colorToString(Color color) {
        String string = "#";
        string = string + HtmlOutput.HexString(color.getRed());
        string = string + HtmlOutput.HexString(color.getGreen());
        string = string + HtmlOutput.HexString(color.getBlue());
        return string;
    }

    private static String HexString(int n) {
        return Integer.toHexString(n / 16) + Integer.toHexString(n % 16);
    }

    public static String convertStringToHtml(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        for (int i = 0; i < tabSize; ++i) {
            string2 = string2 + " ";
        }
        string = string.replaceAll("\\t", string2);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append("&nbsp;");
                ++n;
                continue;
            }
            n = 0;
            switch (c) {
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\n<br>");
                    continue block8;
                }
                default: {
                    if (c >= '\u00a0') {
                        stringBuffer.append("&#" + (short)c + ";");
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String span(String string, Font font, Color color, Color color2) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (font != null) {
            stringBuffer2.append("font-family: " + font.getFamily());
            stringBuffer2.append("; font-size: " + font.getSize() + "pt");
            if (font.isItalic()) {
                stringBuffer2.append("; font-style: italic");
            }
            if (font.isBold()) {
                stringBuffer2.append("; font-weight: bold");
            }
            stringBuffer2.append("; ");
        }
        if (color != null) {
            stringBuffer2.append("color: " + HtmlOutput.colorToString(color) + "; ");
        }
        if (color2 != null) {
            stringBuffer2.append("background-color: " + HtmlOutput.colorToString(color2) + "; ");
        }
        if ((string2 = stringBuffer2.toString()).trim().length() > 0) {
            stringBuffer.append("<font style=\"" + string2 + "\">" + string + "</font>");
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

