/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.CustomSerializable;
import com.topcoder.shared.problem.BaseElement;
import com.topcoder.shared.problem.Constraint;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ProblemConstants;
import com.topcoder.shared.problem.ProblemMessage;
import com.topcoder.shared.problem.TestCase;
import com.topcoder.shared.problem.TextElement;
import com.topcoder.shared.problem.WebService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class ProblemComponent
extends BaseElement
implements Element,
Serializable,
Cloneable,
CustomSerializable {
    static String SECTION_HEADER = "h3";
    static String CODE = "<code>";
    public static int DEFAULT_MEM_LIMIT = 64;
    private boolean unsafe = true;
    private boolean valid = true;
    private ArrayList messages = new ArrayList();
    private String name = "";
    private Element intro = new TextElement();
    private String className = "";
    private String exposedClassName = "";
    private String[] methodNames = new String[0];
    private DataType[] returnTypes = new DataType[0];
    private DataType[][] paramTypes = new DataType[0][0];
    private String[][] paramNames = new String[0][0];
    private String[] exposedMethodNames = new String[0];
    private DataType[] exposedReturnTypes = new DataType[0];
    private DataType[][] exposedParamTypes = new DataType[0][0];
    private String[][] exposedParamNames = new String[0][0];
    private Element spec = new TextElement();
    private Element[] notes = new Element[0];
    private Constraint[] constraints = new Constraint[0];
    private TestCase[] testCases = new TestCase[0];
    private int componentTypeID = ProblemConstants.MAIN_COMPONENT;
    private int componentId = -1;
    private int problemId = -1;
    private String defaultSolution = "";
    private WebService[] webServices = new WebService[0];
    private int memLimitMB = DEFAULT_MEM_LIMIT;
    private int roundType = -1;
    private ArrayList categories = new ArrayList();
    private int codeLengthLimit = Integer.MAX_VALUE;

    public ProblemComponent() {
    }

    public ProblemComponent(boolean bl) {
        this.unsafe = bl;
    }

    public static String encodeXML(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (n = 0; n < ProblemConstants.BAD_XML_CHARS.length; ++n) {
            arrayList.add(new Character(ProblemConstants.BAD_XML_CHARS[n]));
        }
        for (n = 0; n < string.length(); ++n) {
            if (arrayList.indexOf(new Character(string.charAt(n))) == -1) {
                stringBuffer.append(string.charAt(n));
                continue;
            }
            stringBuffer.append("/ASCII" + string.charAt(n) + "/");
        }
        return stringBuffer.toString();
    }

    public static String decodeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (string.length() > 0) {
            boolean bl = true;
            if (string.startsWith("/ASCII") && string.indexOf("/", 2) != -1) {
                try {
                    stringBuffer.append((char)Integer.parseInt(string.substring(6, string.indexOf("/", 2))));
                    bl = false;
                    string = string.substring(string.indexOf("/", 2) + 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!bl) continue;
            stringBuffer.append(string.charAt(0));
            string = string.substring(1);
        }
        return stringBuffer.toString();
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeBoolean(this.unsafe);
        cSWriter.writeBoolean(this.valid);
        cSWriter.writeArrayList(this.messages);
        cSWriter.writeString(this.name);
        cSWriter.writeObject(this.intro);
        cSWriter.writeString(this.className);
        cSWriter.writeString(this.exposedClassName);
        cSWriter.writeObjectArray(this.methodNames);
        cSWriter.writeObjectArray(this.returnTypes);
        cSWriter.writeObjectArrayArray(this.paramTypes);
        cSWriter.writeObjectArrayArray(this.paramNames);
        cSWriter.writeObjectArray(this.exposedMethodNames);
        cSWriter.writeObjectArray(this.exposedReturnTypes);
        cSWriter.writeObjectArrayArray(this.exposedParamTypes);
        cSWriter.writeObjectArrayArray(this.exposedParamNames);
        cSWriter.writeObject(this.spec);
        cSWriter.writeObjectArray(this.notes);
        cSWriter.writeObjectArray(this.constraints);
        cSWriter.writeObjectArray(this.testCases);
        cSWriter.writeInt(this.componentTypeID);
        cSWriter.writeInt(this.componentId);
        cSWriter.writeInt(this.problemId);
        cSWriter.writeString(this.defaultSolution);
        cSWriter.writeObjectArray(this.webServices);
        cSWriter.writeInt(this.memLimitMB);
        cSWriter.writeInt(this.roundType);
        cSWriter.writeArrayList(this.categories);
        cSWriter.writeInt(this.codeLengthLimit);
    }

    public void customReadObject(CSReader cSReader) throws IOException {
        this.unsafe = cSReader.readBoolean();
        this.valid = cSReader.readBoolean();
        this.messages = cSReader.readArrayList();
        this.name = cSReader.readString();
        this.intro = (Element)cSReader.readObject();
        this.className = cSReader.readString();
        this.exposedClassName = cSReader.readString();
        this.methodNames = (String[])cSReader.readObjectArray(String.class);
        this.returnTypes = (DataType[])cSReader.readObjectArray(DataType.class);
        this.paramTypes = (DataType[][])cSReader.readObjectArrayArray(DataType.class);
        this.paramNames = (String[][])cSReader.readObjectArrayArray(String.class);
        this.exposedMethodNames = (String[])cSReader.readObjectArray(String.class);
        this.exposedReturnTypes = (DataType[])cSReader.readObjectArray(DataType.class);
        this.exposedParamTypes = (DataType[][])cSReader.readObjectArrayArray(DataType.class);
        this.exposedParamNames = (String[][])cSReader.readObjectArrayArray(String.class);
        this.spec = (Element)cSReader.readObject();
        this.notes = (Element[])cSReader.readObjectArray(Element.class);
        this.constraints = (Constraint[])cSReader.readObjectArray(Constraint.class);
        this.testCases = (TestCase[])cSReader.readObjectArray(TestCase.class);
        this.componentTypeID = cSReader.readInt();
        this.componentId = cSReader.readInt();
        this.problemId = cSReader.readInt();
        this.defaultSolution = cSReader.readString();
        this.webServices = (WebService[])cSReader.readObjectArray(WebService.class);
        this.memLimitMB = cSReader.readInt();
        this.roundType = cSReader.readInt();
        this.categories = cSReader.readArrayList();
        this.codeLengthLimit = cSReader.readInt();
    }

    public boolean isUnsafe() {
        return this.unsafe;
    }

    public void setUnsafe(boolean bl) {
        this.unsafe = bl;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public ArrayList getMessages() {
        return this.messages;
    }

    public void setMessages(ArrayList arrayList) {
        this.messages = arrayList;
    }

    public void clearMessages() {
        this.messages = new ArrayList();
    }

    public void addMessage(ProblemMessage problemMessage) {
        if (problemMessage.getType() != ProblemMessage.WARNING) {
            this.valid = false;
        }
        this.messages.add(problemMessage);
    }

    public Element getIntro() {
        return this.intro;
    }

    public void setIntro(Element element) {
        this.intro = element;
    }

    public Element getSpec() {
        return this.spec;
    }

    public void setSpec(Element element) {
        this.spec = element;
    }

    public String getClassName() {
        return this.className;
    }

    public String getExposedClassName() {
        return this.exposedClassName;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setExposedClassName(String string) {
        this.exposedClassName = string;
    }

    public String getMethodName() {
        return this.methodNames.length > 0 ? this.methodNames[0] : "";
    }

    public String getMethodName(int n) {
        return this.methodNames.length > n ? this.methodNames[n] : "";
    }

    public String getExposedMethodName(int n) {
        return this.exposedMethodNames.length > n ? this.exposedMethodNames[n] : "";
    }

    public void setMethodName(String string) {
        this.methodNames = new String[]{string};
    }

    public void setMethodNames(String[] stringArray) {
        this.methodNames = stringArray;
    }

    public void setExposedMethodNames(String[] stringArray) {
        this.exposedMethodNames = stringArray;
    }

    public DataType getReturnType() {
        return this.returnTypes.length > 0 ? this.returnTypes[0] : new DataType();
    }

    public void setReturnType(DataType dataType) {
        this.returnTypes = new DataType[]{dataType};
    }

    public void setReturnTypes(DataType[] dataTypeArray) {
        this.returnTypes = dataTypeArray;
    }

    public void setExposedReturnType(DataType dataType) {
        this.exposedReturnTypes = new DataType[]{dataType};
    }

    public void setExposedReturnTypes(DataType[] dataTypeArray) {
        this.exposedReturnTypes = dataTypeArray;
    }

    public DataType[] getParamTypes() {
        return this.paramTypes.length > 0 ? this.paramTypes[0] : new DataType[]{};
    }

    public DataType[] getParamTypes(int n) {
        return this.paramTypes.length > n ? this.paramTypes[n] : new DataType[]{};
    }

    public DataType[] getExposedParamTypes() {
        return this.exposedParamTypes.length > 0 ? this.exposedParamTypes[0] : new DataType[]{};
    }

    public DataType[] getExposedParamTypes(int n) {
        return this.exposedParamTypes.length > n ? this.exposedParamTypes[n] : new DataType[]{};
    }

    public void setParamTypes(DataType[] dataTypeArray) {
        this.paramTypes = new DataType[][]{dataTypeArray};
    }

    public void setParamTypes(DataType[][] dataTypeArray) {
        this.paramTypes = dataTypeArray;
    }

    public void setExposedParamTypes(DataType[] dataTypeArray) {
        this.exposedParamTypes = new DataType[][]{dataTypeArray};
    }

    public void setExposedParamTypes(DataType[][] dataTypeArray) {
        this.exposedParamTypes = dataTypeArray;
    }

    public String[] getParamNames() {
        return this.paramNames.length > 0 ? this.paramNames[0] : new String[]{};
    }

    public String[] getParamNames(int n) {
        return this.paramNames.length > n ? this.paramNames[n] : new String[]{};
    }

    public String[] getExposedParamNames() {
        return this.exposedParamNames.length > 0 ? this.exposedParamNames[0] : new String[]{};
    }

    public String[] getExposedParamNames(int n) {
        return this.exposedParamNames.length > n ? this.exposedParamNames[n] : new String[]{};
    }

    public void setParamNames(String[] stringArray) {
        this.paramNames = new String[][]{stringArray};
    }

    public void setParamNames(String[][] stringArray) {
        this.paramNames = stringArray;
    }

    public void setExposedParamNames(String[] stringArray) {
        this.exposedParamNames = new String[][]{stringArray};
    }

    public void setExposedParamNames(String[][] stringArray) {
        this.exposedParamNames = stringArray;
    }

    public Element[] getNotes() {
        return this.notes;
    }

    public void setNotes(Element[] elementArray) {
        this.notes = elementArray;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Constraint[] constraintArray) {
        this.constraints = constraintArray;
    }

    public TestCase[] getTestCases() {
        return this.testCases;
    }

    public void setTestCases(TestCase[] testCaseArray) {
        this.testCases = testCaseArray;
    }

    public void setWebServices(WebService[] webServiceArray) {
        this.webServices = webServiceArray;
    }

    public WebService[] getWebServices() {
        return this.webServices;
    }

    public void setMemLimitMB(int n) {
        this.memLimitMB = n <= 0 ? DEFAULT_MEM_LIMIT : n;
    }

    public int getMemLimitMB() {
        return this.memLimitMB;
    }

    public int getRoundType() {
        return this.roundType;
    }

    public void setRoundType(int n) {
        this.roundType = n;
    }

    public int getCodeLengthLimit() {
        return this.codeLengthLimit;
    }

    public void setCodeLengthLimit(int n) {
        this.codeLengthLimit = n;
    }

    public static String handleTextElement(String string, Element element) {
        if (element instanceof TextElement) {
            return "<" + string + ">" + element.toString() + "</" + string + ">";
        }
        return element.toXML();
    }

    public String toXML() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append("<?xml version=\"1.0\"?>");
        stringBuffer.append("<problem");
        stringBuffer.append(" xmlns=\"http://topcoder.com\"");
        stringBuffer.append(" name=\"");
        stringBuffer.append(this.name);
        stringBuffer.append("\" code_length_limit=\"");
        stringBuffer.append(this.codeLengthLimit);
        stringBuffer.append("\"><signature><class>");
        stringBuffer.append(this.className);
        stringBuffer.append("</class>");
        for (n2 = 0; n2 < this.methodNames.length; ++n2) {
            stringBuffer.append("<method><name>");
            stringBuffer.append(this.methodNames[n2]);
            stringBuffer.append("</name><return>");
            stringBuffer.append(this.returnTypes[n2].toXML());
            stringBuffer.append("</return><params>");
            for (n = 0; n < this.paramTypes[n2].length; ++n) {
                stringBuffer.append("<param>");
                stringBuffer.append(this.paramTypes[n2][n].toXML());
                stringBuffer.append("<name>");
                stringBuffer.append(this.paramNames[n2][n]);
                stringBuffer.append("</name></param>");
            }
            stringBuffer.append("</params></method>");
        }
        if (this.exposedClassName != null && !this.exposedClassName.equals("")) {
            stringBuffer.append("<exposed_class>");
            stringBuffer.append(this.exposedClassName);
            stringBuffer.append("</exposed_class>");
        }
        for (n2 = 0; n2 < this.exposedMethodNames.length; ++n2) {
            stringBuffer.append("<exposed_method><name>");
            stringBuffer.append(this.exposedMethodNames[n2]);
            stringBuffer.append("</name><return>");
            stringBuffer.append(this.exposedReturnTypes[n2].toXML());
            stringBuffer.append("</return><params>");
            for (n = 0; n < this.exposedParamTypes[n2].length; ++n) {
                stringBuffer.append("<param>");
                stringBuffer.append(this.exposedParamTypes[n2][n].toXML());
                stringBuffer.append("<name>");
                stringBuffer.append(this.exposedParamNames[n2][n]);
                stringBuffer.append("</name></param>");
            }
            stringBuffer.append("</params></exposed_method>");
        }
        stringBuffer.append("</signature>");
        if (this.intro != null) {
            stringBuffer.append(ProblemComponent.handleTextElement("intro", this.intro));
        }
        if (this.spec != null) {
            stringBuffer.append(ProblemComponent.handleTextElement("spec", this.spec));
        }
        stringBuffer.append("<notes>");
        for (n2 = 0; n2 < this.notes.length; ++n2) {
            stringBuffer.append(ProblemComponent.handleTextElement("note", this.notes[n2]));
        }
        stringBuffer.append("</notes><constraints>");
        for (n2 = 0; n2 < this.constraints.length; ++n2) {
            stringBuffer.append(this.constraints[n2].toXML());
        }
        stringBuffer.append("</constraints><test-cases>");
        for (n2 = 0; n2 < this.testCases.length; ++n2) {
            stringBuffer.append(this.testCases[n2].toXML());
        }
        stringBuffer.append("</test-cases><memlimit>");
        stringBuffer.append(this.memLimitMB);
        stringBuffer.append("</memlimit><roundType>");
        stringBuffer.append(this.roundType);
        stringBuffer.append("</roundType></problem>");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("com.topcoder.shared.problem.ProblemComponent[");
        stringBuffer.append("unsafe=");
        stringBuffer.append(this.unsafe);
        stringBuffer.append(",codeLengthLimit=");
        stringBuffer.append(this.codeLengthLimit);
        stringBuffer.append(",valid=");
        stringBuffer.append(this.valid);
        stringBuffer.append(",messages=");
        stringBuffer.append(this.messages);
        stringBuffer.append(",name=");
        stringBuffer.append(this.name);
        stringBuffer.append(",intro=");
        stringBuffer.append(this.intro);
        stringBuffer.append(",className=");
        stringBuffer.append(this.className);
        stringBuffer.append(",methodNames=");
        stringBuffer.append(this.methodNames);
        stringBuffer.append(",returnTypes=");
        stringBuffer.append(this.returnTypes);
        stringBuffer.append(",paramTypes=");
        stringBuffer.append(this.paramTypes);
        stringBuffer.append(",paramNames=");
        stringBuffer.append(this.paramNames);
        stringBuffer.append(",exposedMethodNames=");
        stringBuffer.append(this.exposedMethodNames);
        stringBuffer.append(",exposedReturnTypes=");
        stringBuffer.append(this.exposedReturnTypes);
        stringBuffer.append(",exposedParamTypes=");
        stringBuffer.append(this.exposedParamTypes);
        stringBuffer.append(",exposedParamNames=");
        stringBuffer.append(this.exposedParamNames);
        stringBuffer.append(",memLimitMB=");
        stringBuffer.append(this.memLimitMB);
        stringBuffer.append(",roundType=");
        stringBuffer.append(this.roundType);
        stringBuffer.append(",spec=");
        stringBuffer.append(this.spec);
        stringBuffer.append(",notes=");
        stringBuffer.append(this.notes);
        stringBuffer.append(",constraints=");
        stringBuffer.append(this.constraints);
        stringBuffer.append(",testCases=");
        stringBuffer.append(this.testCases);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getComponentTypeID() {
        return this.componentTypeID;
    }

    public void setComponentTypeID(int n) {
        this.componentTypeID = n;
    }

    public final void setComponentId(int n) {
        this.componentId = n;
    }

    public final void setDefaultSolution(String string) {
        this.defaultSolution = string;
    }

    public final int getComponentId() {
        return this.componentId;
    }

    public final String getDefaultSolution() {
        return this.defaultSolution;
    }

    public int getProblemId() {
        return this.problemId;
    }

    public void setProblemId(int n) {
        this.problemId = n;
    }

    public static String getCacheKey(int n) {
        return "ProblemComponent." + n;
    }

    public final String getCacheKey() {
        return ProblemComponent.getCacheKey(this.componentId);
    }

    public String getReturnType(int n) {
        return this.returnTypes[0].getDescriptor(n);
    }

    public String getResultType() {
        return this.returnTypes[0].getDescriptor(1);
    }

    public ArrayList getArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.paramTypes[0].length; ++i) {
            arrayList.add(this.paramTypes[0][i].getDescriptor(1));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        System.out.println("Before: |" + stringArray[0] + "|");
        String string = ProblemComponent.encodeXML(stringArray[0]);
        System.out.println("Encoded: |" + string + "|");
        System.out.println("After: |" + ProblemComponent.decodeXML(string) + "|");
    }

    public DataType[] getAllReturnTypes() {
        return this.returnTypes;
    }

    public String[] getAllMethodNames() {
        return this.methodNames;
    }

    public DataType[][] getAllParamTypes() {
        return this.paramTypes;
    }

    public String[][] getAllParamNames() {
        return this.paramNames;
    }

    public DataType[] getAllExposedReturnTypes() {
        return this.exposedReturnTypes;
    }

    public String[] getAllExposedMethodNames() {
        return this.exposedMethodNames;
    }

    public DataType[][] getAllExposedParamTypes() {
        return this.exposedParamTypes;
    }

    public String[][] getAllExposedParamNames() {
        return this.exposedParamNames;
    }

    public void setCategories(ArrayList arrayList) {
        this.categories = arrayList;
    }

    public ArrayList getCategories() {
        return this.categories;
    }
}

