/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.problem.ArrayValue;
import com.topcoder.shared.problem.BaseElement;
import com.topcoder.shared.problem.CharacterValue;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.DataValueParseException;
import com.topcoder.shared.problem.DataValueReader;
import com.topcoder.shared.problem.DecimalValue;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.IntegralValue;
import com.topcoder.shared.problem.StringValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class DataValue
extends BaseElement
implements Element {
    private static HashMap types = DataValue.buildTypes();

    public abstract void parse(DataValueReader var1, DataType var2) throws IOException, DataValueParseException;

    public abstract String encode();

    public abstract Object getValue();

    public String toXML() {
        return BaseElement.encodeHTML(this.encode());
    }

    public static DataValue parseValue(String string, DataType dataType) throws IOException, DataValueParseException {
        return DataValue.parseValue(new DataValueReader(string), dataType);
    }

    public static DataValue parseValue(DataValueReader dataValueReader, DataType dataType) throws IOException, DataValueParseException {
        if (dataType.getDimension() > 0) {
            return new ArrayValue(dataValueReader, dataType);
        }
        String string = (String)types.get(dataType.getDescription());
        if (string == null) {
            throw new DataValueParseException("Do not know how to handle data of type " + dataType.getDescription());
        }
        try {
            Class<?> clazz = Class.forName(string);
            DataValue dataValue = (DataValue)clazz.newInstance();
            dataValue.parse(dataValueReader, dataType);
            return dataValue;
        }
        catch (DataValueParseException dataValueParseException) {
            throw dataValueParseException;
        }
        catch (Exception exception) {
            throw new DataValueParseException("Error instantiating object of type " + string + ": " + exception);
        }
    }

    public static DataValue[] parseValues(String[] stringArray, DataType[] dataTypeArray) throws IOException, DataValueParseException {
        DataValue[] dataValueArray = new DataValue[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dataValueArray[i] = DataValue.parseValue(stringArray[i], dataTypeArray[i]);
        }
        return dataValueArray;
    }

    public static Object parseValueToObject(String string, DataType dataType) throws IOException, DataValueParseException {
        return DataValue.convertDataValueToObject(DataValue.parseValue(string, dataType), dataType);
    }

    public static Object[] parseValuesToObjects(String[] stringArray, DataType[] dataTypeArray) throws IOException, DataValueParseException {
        return DataValue.convertDataValuesToObjects(DataValue.parseValues(stringArray, dataTypeArray), dataTypeArray);
    }

    public static DataValue[] parseSequence(String string, DataType[] dataTypeArray) throws IOException, DataValueParseException {
        return DataValue.parseSequence(new DataValueReader(string), dataTypeArray);
    }

    public static DataValue[] parseSequence(DataValueReader dataValueReader, DataType[] dataTypeArray) throws IOException, DataValueParseException {
        dataValueReader.expect('{', true);
        DataValue[] dataValueArray = new DataValue[dataTypeArray.length];
        for (int i = 0; i < dataTypeArray.length; ++i) {
            if (i > 0) {
                dataValueReader.expect(',', true);
            }
            dataValueArray[i] = DataValue.parseValue(dataValueReader, dataTypeArray[i]);
        }
        dataValueReader.expect('}', true);
        return dataValueArray;
    }

    public static Object convertDataValueToObject(DataValue dataValue, DataType dataType) throws DataValueParseException {
        String string = dataType.getDescription();
        String[] stringArray = null;
        try {
            if (string.equals("int") || string.equals("Integer")) {
                stringArray = new Integer((int)((Long)dataValue.getValue()).longValue());
            } else if (string.equals("long") || string.equals("Long")) {
                stringArray = (Long)dataValue.getValue();
            } else if (string.equals("float") || string.equals("Float")) {
                stringArray = new Float(((Double)dataValue.getValue()).floatValue());
            } else if (string.equals("double") || string.equals("Double")) {
                stringArray = (Double)dataValue.getValue();
            } else if (string.equals("short") || string.equals("Short")) {
                stringArray = new Short((short)((Long)dataValue.getValue()).longValue());
            } else {
                if (string.equals("byte") || string.equals("Byte")) {
                    throw new DataValueParseException("byte and Byte not supported.");
                }
                if (string.equals("boolean") || string.equals("Boolean")) {
                    throw new DataValueParseException("boolean and Boolean not supported.");
                }
                if (string.equals("char") || string.equals("Character")) {
                    stringArray = (Character)dataValue.getValue();
                } else if (string.equals("String")) {
                    stringArray = (String)dataValue.getValue();
                } else {
                    if (string.equals("ArrayList")) {
                        throw new DataValueParseException("ArrayList not supported.");
                    }
                    if (string.equals("int[]")) {
                        Object[] objectArray = (Object[])dataValue.getValue();
                        int[] nArray = new int[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            nArray[i] = (int)((Long)((DataValue)objectArray[i]).getValue()).longValue();
                        }
                        stringArray = (String[])nArray;
                    } else if (string.equals("long[]")) {
                        Object[] objectArray = (Object[])dataValue.getValue();
                        long[] lArray = new long[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            lArray[i] = (Long)((DataValue)objectArray[i]).getValue();
                        }
                        stringArray = (String[])lArray;
                    } else if (string.equals("double[]")) {
                        Object[] objectArray = (Object[])dataValue.getValue();
                        double[] dArray = new double[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            dArray[i] = (Double)((DataValue)objectArray[i]).getValue();
                        }
                        stringArray = (String[])dArray;
                    } else if (string.equals("String[]")) {
                        Object[] objectArray = (Object[])dataValue.getValue();
                        String[] stringArray2 = new String[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            stringArray2[i] = (String)((DataValue)objectArray[i]).getValue();
                        }
                        stringArray = stringArray2;
                    }
                }
            }
        }
        catch (DataValueParseException dataValueParseException) {
            throw dataValueParseException;
        }
        catch (Exception exception) {
            throw new DataValueParseException(exception.toString());
        }
        return stringArray;
    }

    public static Object[] convertDataValuesToObjects(DataValue[] dataValueArray, DataType[] dataTypeArray) throws DataValueParseException {
        Object[] objectArray = new Object[dataValueArray.length];
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = DataValue.convertDataValueToObject(dataValueArray[i], dataTypeArray[i]);
            }
        }
        catch (DataValueParseException dataValueParseException) {
            throw dataValueParseException;
        }
        catch (Exception exception) {
            throw new DataValueParseException(exception.toString());
        }
        return objectArray;
    }

    public static DataValue convertObjectToDataValue(Object object, DataType dataType) throws DataValueParseException {
        DataValue dataValue = null;
        try {
            String string = dataType.getDescription();
            if (string.equals("int") || string.equals("Integer")) {
                dataValue = new IntegralValue(((Integer)object).longValue());
            } else if (string.equals("long") || string.equals("Long")) {
                dataValue = new IntegralValue((Long)object);
            } else if (string.equals("float") || string.equals("Float")) {
                dataValue = new DecimalValue(((Float)object).doubleValue());
            } else if (string.equals("double") || string.equals("Double")) {
                dataValue = new DecimalValue((Double)object);
            } else if (string.equals("short") || string.equals("Short")) {
                dataValue = new IntegralValue((Long)object);
            } else {
                if (string.equals("byte") || string.equals("Byte")) {
                    throw new DataValueParseException("byte and Byte not supported.");
                }
                if (string.equals("boolean") || string.equals("Boolean")) {
                    throw new DataValueParseException("boolean and Boolean not supported.");
                }
                if (string.equals("char") || string.equals("Character")) {
                    dataValue = new CharacterValue(((Character)object).charValue());
                } else if (string.equals("String")) {
                    dataValue = new StringValue((String)object);
                } else {
                    if (string.equals("ArrayList")) {
                        throw new DataValueParseException("ArrayList not supported.");
                    }
                    if (string.equals("int[]")) {
                        ArrayList<IntegralValue> arrayList = new ArrayList<IntegralValue>();
                        int[] nArray = (int[])object;
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList.add(new IntegralValue(nArray[i]));
                        }
                        dataValue = new ArrayValue(arrayList);
                    } else if (string.equals("long[]")) {
                        ArrayList<IntegralValue> arrayList = new ArrayList<IntegralValue>();
                        long[] lArray = (long[])object;
                        for (int i = 0; i < lArray.length; ++i) {
                            arrayList.add(new IntegralValue(lArray[i]));
                        }
                        dataValue = new ArrayValue(arrayList);
                    } else if (string.equals("double[]")) {
                        ArrayList<DecimalValue> arrayList = new ArrayList<DecimalValue>();
                        double[] dArray = (double[])object;
                        for (int i = 0; i < dArray.length; ++i) {
                            arrayList.add(new DecimalValue(dArray[i]));
                        }
                        dataValue = new ArrayValue(arrayList);
                    } else if (string.equals("String[]")) {
                        ArrayList<StringValue> arrayList = new ArrayList<StringValue>();
                        String[] stringArray = (String[])object;
                        for (int i = 0; i < stringArray.length; ++i) {
                            arrayList.add(new StringValue(stringArray[i]));
                        }
                        dataValue = new ArrayValue(arrayList);
                    }
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new DataValueParseException("Error converting Object to DataValue. Expected " + dataType.getDescription() + ", got " + classCastException.getMessage());
        }
        return dataValue;
    }

    public static DataValue[] convertObjectsToDataValues(Object[] objectArray, DataType[] dataTypeArray) throws DataValueParseException {
        DataValue[] dataValueArray = new DataValue[objectArray.length];
        for (int i = 0; i < dataValueArray.length; ++i) {
            dataValueArray[i] = DataValue.convertObjectToDataValue(objectArray[i], dataTypeArray[i]);
        }
        return dataValueArray;
    }

    private static HashMap buildTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("char", "com.topcoder.shared.problem.CharacterValue");
        hashMap.put("Character", "com.topcoder.shared.problem.CharacterValue");
        hashMap.put("int", "com.topcoder.shared.problem.IntegralValue");
        hashMap.put("Integer", "com.topcoder.shared.problem.IntegralValue");
        hashMap.put("long", "com.topcoder.shared.problem.IntegralValue");
        hashMap.put("Long", "com.topcoder.shared.problem.IntegralValue");
        hashMap.put("short", "com.topcoder.shared.problem.IntegralValue");
        hashMap.put("Short", "com.topcoder.shared.problem.IntegralValue");
        hashMap.put("double", "com.topcoder.shared.problem.DecimalValue");
        hashMap.put("Double", "com.topcoder.shared.problem.DecimalValue");
        hashMap.put("float", "com.topcoder.shared.problem.DecimalValue");
        hashMap.put("Float", "com.topcoder.shared.problem.DecimalValue");
        hashMap.put("String", "com.topcoder.shared.problem.StringValue");
        return hashMap;
    }
}

