/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.InvalidTypeException;
import com.topcoder.shared.util.DBMS;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;

public class DataTypeFactory {
    private static HashMap types = new HashMap();
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        if (initialized) {
            return;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = DBMS.getConnection();
            preparedStatement = connection.prepareStatement("SELECT data_type_id, language_id, display_value FROM data_type_mapping");
            resultSet = preparedStatement.executeQuery();
            HashMap<Integer, HashMap<Integer, String>> hashMap = new HashMap<Integer, HashMap<Integer, String>>();
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                int n2 = resultSet.getInt(2);
                String string = resultSet.getString(3);
                HashMap<Integer, String> hashMap2 = (HashMap<Integer, String>)hashMap.get(new Integer(n));
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<Integer, String>();
                    hashMap.put(new Integer(n), hashMap2);
                }
                hashMap2.put(new Integer(n2), string);
            }
            resultSet.close();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("SELECT data_type_id, data_type_desc  FROM data_type");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                new DataType(resultSet.getInt(1), resultSet.getString(2), (HashMap)hashMap.get(new Integer(resultSet.getInt(1))));
            }
            initialized = true;
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                DBMS.close((Connection)connection, (PreparedStatement)preparedStatement, resultSet);
                throw throwable;
            }
            DBMS.close((Connection)connection, (PreparedStatement)preparedStatement, (ResultSet)resultSet);
        }
        DBMS.close((Connection)connection, (PreparedStatement)preparedStatement, (ResultSet)resultSet);
    }

    public static DataType getDataType(String string) throws InvalidTypeException {
        DataTypeFactory.initialize();
        DataType dataType = (DataType)types.get(string);
        if (dataType == null) {
            throw new InvalidTypeException(string);
        }
        return dataType.cloneDataType();
    }

    public static DataType getDataType(int n) throws InvalidTypeException {
        DataTypeFactory.initialize();
        DataType dataType = (DataType)types.get(new Integer(n));
        if (dataType == null) {
            throw new InvalidTypeException(new String("" + n));
        }
        return dataType.cloneDataType();
    }

    static void registerDataType(DataType dataType) {
        initialized = true;
        if (types.containsKey(dataType.getDescription())) {
            return;
        }
        types.put(dataType.getDescription(), dataType.cloneDataType());
        types.put(new Integer(dataType.getID()), dataType.cloneDataType());
    }

    public static Collection getDataTypes() {
        DataTypeFactory.initialize();
        return types.values();
    }
}

