/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.language;

import com.topcoder.shared.language.CPPLanguage;
import com.topcoder.shared.language.CSharpLanguage;
import com.topcoder.shared.language.JavaLanguage;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.language.PythonLanguage;
import com.topcoder.shared.language.VBLanguage;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.ResolvedCustomSerializable;
import com.topcoder.shared.problem.DataType;
import java.io.IOException;
import java.io.ObjectStreamException;

public abstract class BaseLanguage
implements Language,
ResolvedCustomSerializable {
    private int id;
    private transient String name;

    protected BaseLanguage(int n, String string) {
        this.id = n;
        this.name = string;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Language && ((Language)object).getId() == this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeInt(this.id);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.id = cSReader.readInt();
    }

    public Object readResolve() {
        return BaseLanguage.getLanguage(this.id);
    }

    public abstract String getMethodSignature(String var1, DataType var2, DataType[] var3, String[] var4);

    public static Language getLanguage(int n) {
        switch (n) {
            case 1: {
                return JavaLanguage.JAVA_LANGUAGE;
            }
            case 3: {
                return CPPLanguage.CPP_LANGUAGE;
            }
            case 4: {
                return CSharpLanguage.CSHARP_LANGUAGE;
            }
            case 5: {
                return VBLanguage.VB_LANGUAGE;
            }
            case 6: {
                return PythonLanguage.PYTHON_LANGUAGE;
            }
        }
        throw new IllegalArgumentException("Invalid language: " + n);
    }
}

