/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.io.buffer;

import com.topcoder.netCommon.io.buffer.BufferOverflowException;
import com.topcoder.netCommon.io.buffer.BufferUnderflowException;
import com.topcoder.netCommon.io.buffer.ByteBuffer;

final class ByteBuffer13
extends ByteBuffer {
    private final byte[] array;
    private final int capacity;
    private int limit;
    private int position;
    private int mark;

    ByteBuffer13(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
        this.array = new byte[n];
        this.position = 0;
        this.limit = n;
        this.mark = -1;
    }

    public int capacity() {
        return this.capacity;
    }

    public int limit() {
        return this.limit;
    }

    public int position() {
        return this.position;
    }

    public byte[] array() {
        return this.array;
    }

    public ByteBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public ByteBuffer put(byte by) {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        this.array[this.position++] = by;
        return this;
    }

    public byte get() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.array[this.position++];
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public ByteBuffer get(byte[] byArray, int n, int n2) {
        ByteBuffer13.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            byArray[i] = this.get();
        }
        return this;
    }

    public ByteBuffer position(int n) {
        if (n < 0 || n > this.limit) {
            throw new IllegalArgumentException();
        }
        this.position = n;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    public ByteBuffer limit(int n) {
        if (n < 0 || n > this.capacity) {
            throw new IllegalArgumentException("newLimit = " + n + ", capacity = " + this.capacity);
        }
        this.limit = n;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    public ByteBuffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public ByteBuffer putInt(int n) {
        for (int i = 0; i < 4; ++i) {
            byte by = (byte)(n >> (3 - i) * 8);
            this.put(by);
        }
        return this;
    }

    public int getInt() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n |= (this.get() & 0xFF) << (3 - i) * 8;
        }
        return n;
    }

    public ByteBuffer put(byte[] byArray, int n, int n2) {
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(byArray, n, this.array, this.position, n2);
        this.position(this.position + n2);
        return this;
    }

    static void checkBounds(int n, int n2, int n3) {
        if ((n | n2 | n + n2 | n3 - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

