/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages.response;

import com.topcoder.netCommon.contestantMessages.response.BaseResponse;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import java.io.IOException;

public class SubmissionHistoryResponse
extends BaseResponse {
    private int roundId;
    private int componentId;
    private String handle;
    private int pendingSubmissionNumber;
    private boolean exampleHistory;
    private int[] numbers;
    private long[] times;
    private int[] langs;
    private double[] scores;

    public SubmissionHistoryResponse(int n, String string, int n2, boolean bl, int n3, int[] nArray, long[] lArray, int[] nArray2, double[] dArray) {
        this.roundId = n;
        this.handle = string;
        this.componentId = n2;
        this.exampleHistory = bl;
        this.pendingSubmissionNumber = n3;
        this.numbers = nArray;
        this.times = lArray;
        this.langs = nArray2;
        this.scores = dArray;
    }

    public SubmissionHistoryResponse() {
    }

    public void customReadObject(CSReader cSReader) throws IOException {
        super.customReadObject(cSReader);
        this.roundId = cSReader.readInt();
        this.handle = cSReader.readString();
        this.componentId = cSReader.readInt();
        this.exampleHistory = cSReader.readBoolean();
        this.pendingSubmissionNumber = cSReader.readInt();
        this.numbers = (int[])cSReader.readObject();
        this.times = (long[])cSReader.readObject();
        this.langs = (int[])cSReader.readObject();
        this.scores = (double[])cSReader.readObject();
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        super.customWriteObject(cSWriter);
        cSWriter.writeInt(this.roundId);
        cSWriter.writeString(this.handle);
        cSWriter.writeInt(this.componentId);
        cSWriter.writeBoolean(this.exampleHistory);
        cSWriter.writeInt(this.pendingSubmissionNumber);
        cSWriter.writeObject(this.numbers);
        cSWriter.writeObject(this.times);
        cSWriter.writeObject(this.langs);
        cSWriter.writeObject(this.scores);
    }

    public boolean hasPendingTest(int n) {
        return this.numbers[n] == this.pendingSubmissionNumber;
    }

    public int getNumber(int n) {
        return this.numbers[n];
    }

    public long getTime(int n) {
        return this.times[n];
    }

    public int getLanguageId(int n) {
        return this.langs[n];
    }

    public double getScore(int n) {
        return this.scores[n];
    }

    public int getCount() {
        return this.numbers == null ? 0 : this.numbers.length;
    }

    public String toString() {
        return "SubmissionHistoryResponse[count=" + this.getCount() + " ]";
    }

    public boolean isExampleHistory() {
        return this.exampleHistory;
    }

    public int[] getLangs() {
        return this.langs;
    }

    public int[] getNumbers() {
        return this.numbers;
    }

    public double[] getScores() {
        return this.scores;
    }

    public long[] getTimes() {
        return this.times;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public String getHandle() {
        return this.handle;
    }

    public int getRoundId() {
        return this.roundId;
    }
}

