/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contest;

import com.topcoder.netCommon.contest.Answer;
import com.topcoder.netCommon.contest.Question;
import com.topcoder.netCommon.contest.SurveyAnswerData;
import com.topcoder.netCommon.contest.SurveyChoiceData;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.CustomSerializable;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;

public class SurveyQuestionData
implements Question,
Serializable,
CustomSerializable {
    protected int questionID;
    protected int questionType;
    protected boolean eligibleQuestion;
    protected String questionText;
    protected ArrayList choices;

    public SurveyQuestionData() {
    }

    public SurveyQuestionData(int n, String string, int n2, boolean bl, ArrayList arrayList) {
        this.questionID = n;
        this.questionText = string;
        this.questionType = n2;
        this.choices = arrayList;
        this.eligibleQuestion = bl;
    }

    public int getQuestionID() {
        return this.questionID;
    }

    public int getQuestionCategory() {
        if (this.isEligibleQuestion()) {
            return 1;
        }
        return 2;
    }

    public int getQuestionType() {
        return this.questionType;
    }

    public boolean isEligibleQuestion() {
        return this.eligibleQuestion;
    }

    public String getQuestionText() {
        return this.questionText;
    }

    public ArrayList getAnswerText() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        if (this.choices != null) {
            n = this.choices.size();
        }
        for (int i = 0; i < n; ++i) {
            SurveyChoiceData surveyChoiceData = (SurveyChoiceData)this.choices.get(i);
            arrayList.add(surveyChoiceData.getText());
        }
        return arrayList;
    }

    public Answer getAnswer(ArrayList arrayList) {
        SurveyAnswerData surveyAnswerData = new SurveyAnswerData(this.questionID, this.questionType, this.isEligibleQuestion());
        surveyAnswerData.setAnswers(arrayList);
        boolean bl = true;
        if (this.getQuestionType() == 1 || this.getQuestionType() == 2) {
            ArrayList<SurveyChoiceData> arrayList2 = new ArrayList<SurveyChoiceData>();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                for (int j = 0; j < this.choices.size(); ++j) {
                    SurveyChoiceData surveyChoiceData = (SurveyChoiceData)this.choices.get(j);
                    if (!surveyChoiceData.getText().equals(string)) continue;
                    arrayList2.add(surveyChoiceData);
                    if (!this.isEligibleQuestion() || surveyChoiceData.isCorrect()) continue;
                    bl = false;
                }
            }
            surveyAnswerData.setChoices(arrayList2);
        } else {
            surveyAnswerData.setChoices(this.choices);
        }
        surveyAnswerData.setCorrect(bl);
        return surveyAnswerData;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeInt(this.questionID);
        cSWriter.writeInt(this.questionType);
        cSWriter.writeBoolean(this.eligibleQuestion);
        cSWriter.writeString(this.questionText);
        cSWriter.writeArrayList(this.choices);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.questionID = cSReader.readInt();
        this.questionType = cSReader.readInt();
        this.eligibleQuestion = cSReader.readBoolean();
        this.questionText = cSReader.readString();
        this.choices = cSReader.readArrayList();
    }
}

