/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.net.httptunnel.client;

import com.topcoder.net.httptunnel.common.digest.TokenDigester;
import com.topcoder.netCommon.io.ClientConnector;
import com.topcoder.shared.util.concurrent.Waiter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;

public class HTTPTunnelClientConnector
implements ClientConnector {
    private final TokenDigester digestGenerator = new TokenDigester();
    private DisconnecterThread outputDisconnecter;
    private DisconnecterThread inputDisconnecter;
    private final String tunnelLocation;
    private int tunnelId;
    private boolean reuseOutputStream;
    private HttpURLConnection inputConnection;
    private HttpURLConnection outputConnection;
    private String tunnelURLString;
    private InputStream inputStream;
    private OutputStream outputStream;
    private String token;
    private long serverTSDiff;
    private int maxOutputChunk;

    public HTTPTunnelClientConnector(String string) throws IOException {
        this(string, "true".equals(System.getProperty("com.topcoder.net.httptunnel.client.reuseConnection", "true")));
    }

    public HTTPTunnelClientConnector(String string, boolean bl) throws IOException {
        this.tunnelLocation = string;
        this.reuseOutputStream = bl;
        this.init();
        this.outputDisconnecter = new OutputDisconnecterThread();
        this.inputDisconnecter = new InputDisconnecterThread();
    }

    private void init() throws IOException {
        System.gc();
        System.runFinalization();
        ConnectThread connectThread = new ConnectThread();
        connectThread.start();
        try {
            connectThread.join(this.getInitialConnectTimeout());
            if (!connectThread.isAlive()) {
                if (connectThread.getException() != null) {
                    throw connectThread.getException();
                }
                if (connectThread.getRuntimeException() != null) {
                    throw connectThread.getRuntimeException();
                }
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        connectThread.interrupt();
        this.close();
        throw new IOException("Could not connect");
    }

    private long getInitialConnectTimeout() {
        long l = 10000L;
        try {
            l = Long.parseLong(System.getProperty("com.topcoder.net.httptunnel.client.connect.timeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    protected OutputStream getHttpOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        this.createOutputConnection();
        return this.outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            public void write(int n) throws IOException {
                try {
                    HTTPTunnelClientConnector.this.getHttpOutputStream().write(n);
                }
                catch (IOException iOException) {
                    HTTPTunnelClientConnector.this.cleanOutputConnection();
                    throw iOException;
                }
            }

            public void write(byte[] byArray) throws IOException {
                try {
                    HTTPTunnelClientConnector.this.getHttpOutputStream().write(byArray);
                }
                catch (IOException iOException) {
                    HTTPTunnelClientConnector.this.cleanOutputConnection();
                    throw iOException;
                }
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                try {
                    HTTPTunnelClientConnector.this.getHttpOutputStream().write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    HTTPTunnelClientConnector.this.cleanOutputConnection();
                    throw iOException;
                }
            }

            public void flush() throws IOException {
                try {
                    HTTPTunnelClientConnector.this.getHttpOutputStream().flush();
                    HTTPTunnelClientConnector.this.cleanOutputIfNeeded();
                }
                catch (IOException iOException) {
                    HTTPTunnelClientConnector.this.cleanOutputConnection();
                    throw iOException;
                }
            }

            public void close() throws IOException {
                try {
                    HTTPTunnelClientConnector.this.getHttpOutputStream().close();
                }
                catch (IOException iOException) {
                    HTTPTunnelClientConnector.this.cleanOutputConnection();
                    throw iOException;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanOutputIfNeeded() throws IOException {
        if (!this.reuseOutputStream) {
            try {
                HttpURLConnection httpURLConnection = this.outputConnection;
                if (httpURLConnection != null) {
                    httpURLConnection.getInputStream();
                }
            }
            finally {
                this.cleanOutputConnection();
            }
        }
    }

    protected void createOutputConnection() throws IOException {
        try {
            Random random = new Random();
            URL uRL = new URL(this.tunnelURLString + "&c1=" + random.nextInt() + "&c2=" + random.nextInt() + "&c3=" + random.nextInt() + "&c4=" + random.nextInt());
            if (this.reuseOutputStream) {
                this.doHeadForURL(uRL);
            }
            this.outputConnection = (HttpURLConnection)uRL.openConnection();
            this.outputConnection.setRequestMethod("POST");
            this.outputConnection.setDoOutput(true);
            this.outputConnection.setUseCaches(false);
            if (this.reuseOutputStream) {
                this.outputConnection.setChunkedStreamingMode(this.getMaxOutputChunkSize());
            }
            this.outputConnection.setRequestProperty("Connection", "keep-alive");
            this.outputConnection.setRequestProperty("Content-Type", "application/octet-stream");
            this.addNewSecurityHeaders();
            this.outputStream = this.outputConnection.getOutputStream();
        }
        catch (IOException iOException) {
            System.out.println("Could not create output connection to tunnel server. Cleanning output connection");
            this.cleanOutputConnection();
            throw iOException;
        }
    }

    private void doHeadForURL(URL uRL) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            try {
                httpURLConnection.setRequestMethod("HEAD");
                httpURLConnection.setUseCaches(false);
                InputStream inputStream = httpURLConnection.getInputStream();
                inputStream.close();
            }
            catch (Exception exception) {
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addNewSecurityHeaders() {
        if (this.token != null) {
            String string = String.valueOf(this.serverTSDiff + System.currentTimeMillis());
            this.outputConnection.setRequestProperty("TC-TS", string);
            this.outputConnection.setRequestProperty("TC-Digest", this.digestGenerator.generateDigest(this.token, this.tunnelId, string));
        }
    }

    private void cleanOutputConnection() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Could not close output to tunnel server");
                iOException.printStackTrace();
            }
            this.outputStream = null;
        }
        if (this.outputConnection != null) {
            this.forceDisconnectOfHttp(this.outputConnection);
            this.outputConnection = null;
        }
    }

    public void close() {
        this.forceDisconnectOfHttp(this.outputConnection);
        this.forceDisconnectOfHttp(this.inputConnection);
        this.interrupThread(this.inputDisconnecter);
        this.interrupThread(this.outputDisconnecter);
    }

    private void interrupThread(DisconnecterThread disconnecterThread) {
        if (disconnecterThread != null) {
            disconnecterThread.interrupt();
        }
    }

    private void forceDisconnectOfHttp(HttpURLConnection httpURLConnection) {
        if (httpURLConnection == null) {
            return;
        }
        DisconnecterThread disconnecterThread = null;
        disconnecterThread = httpURLConnection == this.inputConnection ? this.inputDisconnecter : this.outputDisconnecter;
        if (disconnecterThread != null && !disconnecterThread.disconnect()) {
            try {
                Method method = httpURLConnection.getClass().getDeclaredMethod("disconnectInternal", null);
                method.setAccessible(true);
                method.invoke((Object)httpURLConnection, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getMaxOutputChunkSize() {
        if (this.maxOutputChunk == 0) {
            String string = System.getProperty("com.topcoder.net.httptunnel.client.output.buffer.size");
            if (string != null) {
                try {
                    this.maxOutputChunk = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.maxOutputChunk == 0) {
                this.maxOutputChunk = 0x1900000;
            }
        }
        return this.maxOutputChunk;
    }

    public class OutputDisconnecterThread
    extends DisconnecterThread {
        public OutputDisconnecterThread() {
            super("OutputDisconnecter");
        }

        protected HttpURLConnection closeStreamAndReturnConnection() throws IOException {
            try {
                InputStream inputStream = HTTPTunnelClientConnector.this.outputConnection.getInputStream();
                while (inputStream.available() > 0) {
                    inputStream.read();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return HTTPTunnelClientConnector.this.outputConnection;
        }
    }

    public class InputDisconnecterThread
    extends DisconnecterThread {
        public InputDisconnecterThread() {
            super("InputDisconnecter");
        }

        protected HttpURLConnection closeStreamAndReturnConnection() throws IOException {
            return HTTPTunnelClientConnector.this.inputConnection;
        }
    }

    public abstract class DisconnecterThread
    extends Thread {
        private Object mutex = new Object();
        private boolean mustDisconnect = false;
        private boolean disconnected = true;

        public DisconnecterThread(String string) {
            super(string);
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = this.mutex;
                synchronized (object) {
                    while (!this.mustDisconnect) {
                        try {
                            this.mutex.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    this.mustDisconnect = false;
                }
                try {
                    this.closeStreamAndReturnConnection().disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = this.mutex;
                synchronized (object) {
                    this.disconnected = true;
                    this.mutex.notify();
                }
            }
        }

        protected abstract HttpURLConnection closeStreamAndReturnConnection() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean disconnect() {
            Object object = this.mutex;
            synchronized (object) {
                this.mustDisconnect = true;
                this.disconnected = false;
                this.mutex.notify();
                try {
                    Waiter waiter = new Waiter(1000L, this.mutex);
                    while (!waiter.elapsed() && !this.disconnected) {
                        waiter.await();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                return this.disconnected;
            }
        }
    }

    private class ConnectThread
    extends Thread {
        private IOException exception;
        private RuntimeException runtimeException;

        public ConnectThread() {
            super("HTTPConnector-" + System.currentTimeMillis());
            this.setDaemon(true);
        }

        public void run() {
            try {
                Random random = new Random();
                URL uRL = new URL(HTTPTunnelClientConnector.this.tunnelLocation + "&c1=" + random.nextInt() + "&c2=" + random.nextInt() + "&c3=" + random.nextInt() + "&c4=" + random.nextInt());
                HTTPTunnelClientConnector.this.inputConnection = (HttpURLConnection)uRL.openConnection();
                HTTPTunnelClientConnector.this.inputConnection.setRequestMethod("GET");
                HTTPTunnelClientConnector.this.inputConnection.setUseCaches(false);
                HTTPTunnelClientConnector.this.inputConnection.setRequestProperty("Content-Type", "application/octet-stream");
                HTTPTunnelClientConnector.this.inputStream = HTTPTunnelClientConnector.this.inputConnection.getInputStream();
                HTTPTunnelClientConnector.this.token = HTTPTunnelClientConnector.this.inputConnection.getHeaderField("TC-Token");
                if (HTTPTunnelClientConnector.this.token != null) {
                    HTTPTunnelClientConnector.this.tunnelId = Integer.parseInt(HTTPTunnelClientConnector.this.inputConnection.getHeaderField("TC-TunnelID"));
                    long l = Long.parseLong(HTTPTunnelClientConnector.this.inputConnection.getHeaderField("TC-TS"));
                    HTTPTunnelClientConnector.this.serverTSDiff = l - System.currentTimeMillis();
                    if (HTTPTunnelClientConnector.this.inputConnection.getHeaderField("TC-Byte") != null) {
                        HTTPTunnelClientConnector.this.inputStream.read();
                    }
                } else {
                    HTTPTunnelClientConnector.this.tunnelId = new DataInputStream(HTTPTunnelClientConnector.this.inputStream).readInt();
                    if (HTTPTunnelClientConnector.this.reuseOutputStream) {
                        throw new IOException("Tunnel Mode not available.");
                    }
                }
                System.out.println(HTTPTunnelClientConnector.this.tunnelId);
                HTTPTunnelClientConnector.this.tunnelURLString = HTTPTunnelClientConnector.this.tunnelLocation + "&id=" + HTTPTunnelClientConnector.this.tunnelId;
            }
            catch (RuntimeException runtimeException) {
                this.runtimeException = runtimeException;
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }

        public IOException getException() {
            return this.exception;
        }

        public RuntimeException getRuntimeException() {
            return this.runtimeException;
        }
    }
}

