/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.ui.impl.component;

import com.topcoder.client.ui.UIComponentException;
import com.topcoder.client.ui.UIEventListener;
import com.topcoder.client.ui.event.UIWindowFocusListener;
import com.topcoder.client.ui.event.UIWindowListener;
import com.topcoder.client.ui.event.UIWindowStateListener;
import com.topcoder.client.ui.impl.component.UIContainer;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Window;

public class UIAWTWindow
extends UIContainer {
    private Window component;

    protected Object createComponent() {
        Object v = this.properties.get("owner");
        Window window = v instanceof Frame ? new Window((Frame)v) : new Window((Window)v);
        window.setLayout(new GridBagLayout());
        return window;
    }

    protected void initialize() throws UIComponentException {
        try {
            super.initialize();
        }
        catch (ClassCastException classCastException) {
            throw new UIComponentException("The owner is not a window or frame.", classCastException);
        }
        this.component = (Window)this.getEventSource();
    }

    protected void destroyImpl() {
        this.component.dispose();
        super.destroyImpl();
    }

    protected void setPropertyImpl(String string, Object object) throws UIComponentException {
        if ("owner".equalsIgnoreCase(string)) {
            if (this.component.getOwner() != object) {
                throw new UIComponentException("The window owner can only be set before usage.");
            }
        } else if ("focusablewindowstate".equalsIgnoreCase(string)) {
            this.component.setFocusableWindowState((Boolean)object);
        } else if ("focuscycleroot".equalsIgnoreCase(string)) {
            this.component.setFocusCycleRoot((Boolean)object);
        } else if ("locationrelativeto".equalsIgnoreCase(string)) {
            this.component.setLocationRelativeTo((Component)object);
        } else {
            super.setPropertyImpl(string, object);
        }
    }

    protected Object getPropertyImpl(String string) throws UIComponentException {
        if ("focusablewindowstate".equalsIgnoreCase(string)) {
            return this.component.getFocusableWindowState();
        }
        if ("focusowner".equalsIgnoreCase(string)) {
            return this.component.getFocusOwner();
        }
        if ("mostrecentfocusowner".equalsIgnoreCase(string)) {
            return this.component.getMostRecentFocusOwner();
        }
        if ("ownedwindows".equalsIgnoreCase(string)) {
            return this.component.getOwnedWindows();
        }
        if ("owner".equalsIgnoreCase(string)) {
            return this.component.getOwner();
        }
        if ("toolkit".equalsIgnoreCase(string)) {
            return this.component.getToolkit();
        }
        if ("warningstring".equalsIgnoreCase(string)) {
            return this.component.getWarningString();
        }
        if ("active".equalsIgnoreCase(string)) {
            return this.component.isActive();
        }
        if ("focusablewindow".equalsIgnoreCase(string)) {
            return this.component.isFocusableWindow();
        }
        if ("focuscycleroot".equalsIgnoreCase(string)) {
            return this.component.isFocusCycleRoot();
        }
        if ("focused".equalsIgnoreCase(string)) {
            return this.component.isFocused();
        }
        if ("showing".equalsIgnoreCase(string)) {
            return this.component.isShowing();
        }
        return super.getPropertyImpl(string);
    }

    protected void addEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        if ("windowfocus".equalsIgnoreCase(string)) {
            this.component.addWindowFocusListener((UIWindowFocusListener)uIEventListener);
        } else if ("window".equalsIgnoreCase(string)) {
            this.component.addWindowListener((UIWindowListener)uIEventListener);
        } else if ("windowstate".equalsIgnoreCase(string)) {
            this.component.addWindowStateListener((UIWindowStateListener)uIEventListener);
        } else {
            super.addEventListenerImpl(string, uIEventListener);
        }
    }

    protected void removeEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        if ("windowfocus".equalsIgnoreCase(string)) {
            this.component.removeWindowFocusListener((UIWindowFocusListener)uIEventListener);
        } else if ("window".equalsIgnoreCase(string)) {
            this.component.removeWindowListener((UIWindowListener)uIEventListener);
        } else if ("windowstate".equalsIgnoreCase(string)) {
            this.component.removeWindowStateListener((UIWindowStateListener)uIEventListener);
        } else {
            super.removeEventListenerImpl(string, uIEventListener);
        }
    }

    protected Object performActionImpl(String string, Object[] objectArray) throws UIComponentException {
        if ("hide".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.hide();
            return null;
        }
        if ("show".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.show();
            return null;
        }
        if ("pack".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.pack();
            return null;
        }
        if ("toback".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.toBack();
            return null;
        }
        if ("tofront".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.toFront();
            return null;
        }
        if ("dispose".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.dispose();
            return null;
        }
        return super.performActionImpl(string, objectArray);
    }
}

