/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.ui.impl;

import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIComponentException;
import com.topcoder.client.ui.UIManager;
import com.topcoder.client.ui.UIManagerConfigurationException;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.UIPageException;
import com.topcoder.client.ui.UIPageNotFoundException;
import com.topcoder.client.ui.UIPropertyValueParser;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUIManager
implements UIManager {
    private Map pages = new HashMap();
    private String name;
    private String description;
    private URL xmlConfig;
    private ClassLoader loader = null;
    private UIPage currentPage;
    static /* synthetic */ Class class$java$awt$GridBagConstraints;
    static /* synthetic */ Class class$com$topcoder$client$ui$UIManager;

    public XMLUIManager(URL uRL) throws UIManagerConfigurationException {
        this.xmlConfig = uRL;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(new DefaultHandler(){

                private String getMandatoryAttribute(Attributes attributes, String string) throws SAXException {
                    String string2 = attributes.getValue(string);
                    if (string2 == null) {
                        throw new SAXException("Attribute " + string + " must exist.");
                    }
                    return string2;
                }

                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    if ("scheme".equals(string2)) {
                        XMLUIManager.this.name = this.getMandatoryAttribute(attributes, "name");
                        XMLUIManager.this.description = this.getMandatoryAttribute(attributes, "description");
                    }
                }
            });
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            throw new UIManagerConfigurationException("The configuration file cannot be read.", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new UIManagerConfigurationException("The SAX parser cannot be created.", parserConfigurationException);
        }
        catch (SAXParseException sAXParseException) {
            throw new UIManagerConfigurationException("The XML configuration for this UI is invalid at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ".", sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new UIManagerConfigurationException("The XML configuration for this UI is invalid.", sAXException);
        }
        finally {
            Locale.setDefault(locale);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void create() throws UIManagerConfigurationException {
        this.create(null);
    }

    public URL getXMLConfig() {
        return this.xmlConfig;
    }

    public UIPage getCurrentPage() {
        return this.currentPage;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    private void create(String string) throws UIManagerConfigurationException {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        InputStream inputStream = null;
        try {
            inputStream = this.xmlConfig.openStream();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            ConfigurationContentHandler configurationContentHandler = new ConfigurationContentHandler(this.xmlConfig, string);
            xMLReader.setContentHandler(configurationContentHandler);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            throw new UIManagerConfigurationException("The configuration file cannot be read.", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new UIManagerConfigurationException("The SAX parser cannot be created.", parserConfigurationException);
        }
        catch (SAXParseException sAXParseException) {
            throw new UIManagerConfigurationException("The XML configuration for this UI is invalid at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ".", sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new UIManagerConfigurationException("The XML configuration for this UI is invalid.", sAXException);
        }
        finally {
            Locale.setDefault(locale);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void destroy() {
        Iterator iterator = this.pages.values().iterator();
        while (iterator.hasNext()) {
            UIPage uIPage = (UIPage)iterator.next();
            uIPage.destroy();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public UIPage getUIPage(String string) throws UIPageNotFoundException {
        return this.getUIPage(string, false);
    }

    public UIPage getUIPage(String string, boolean bl) throws UIPageNotFoundException {
        UIPage uIPage = (UIPage)this.pages.get(string);
        if (uIPage == null) {
            throw new UIPageNotFoundException("The UI page " + string + " is not available.");
        }
        if (bl) {
            try {
                this.create(string);
            }
            catch (UIManagerConfigurationException uIManagerConfigurationException) {
                throw new UIPageNotFoundException("The UI page cannot be re-created.", uIManagerConfigurationException);
            }
            uIPage.destroy();
            uIPage = (UIPage)this.pages.get(string);
        }
        return uIPage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ConfigurationContentHandler
    implements ContentHandler {
        private Stack elements = new Stack();
        private Stack constraints = new Stack();
        private URL dir;
        private String pageName;
        private boolean skipping = false;
        private Locator locator = null;

        private String getMandatoryAttribute(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                throw new SAXParseException("Attribute " + string + " must exist.", this.locator);
            }
            return string2;
        }

        private int parseConstraintsConstants(String string) {
            try {
                return (class$java$awt$GridBagConstraints == null ? (class$java$awt$GridBagConstraints = XMLUIManager.class$("java.awt.GridBagConstraints")) : class$java$awt$GridBagConstraints).getField(string.toUpperCase()).getInt(null);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("The value is not a valid GridBagConstraints constant.");
            }
        }

        private Insets parseIntsets(String string) {
            String[] stringArray = string.split(",");
            if (stringArray.length != 4) {
                throw new IllegalArgumentException("The value is not a valid inset value.");
            }
            return new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        }

        public ConfigurationContentHandler(URL uRL, String string) {
            this.dir = uRL;
            this.pageName = string;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("component".equals(string2) && !this.skipping) {
                UIComponent uIComponent = (UIComponent)this.elements.pop();
                GridBagConstraints gridBagConstraints = (GridBagConstraints)this.constraints.pop();
                Object e = this.elements.peek();
                if (e instanceof UIComponent) {
                    try {
                        ((UIComponent)e).addChild(uIComponent, gridBagConstraints);
                    }
                    catch (UIComponentException uIComponentException) {
                        throw new SAXParseException("The parent component cannot have child.", this.locator, uIComponentException);
                    }
                }
            } else if ("action".equals(string2) && !this.skipping) {
                PerformAction performAction = (PerformAction)this.elements.pop();
                UIComponent uIComponent = (UIComponent)this.elements.peek();
                try {
                    uIComponent.performAction(performAction.name, performAction.params.toArray());
                }
                catch (UIComponentException uIComponentException) {
                    throw new SAXParseException("Performing action failed.", this.locator, uIComponentException);
                }
            } else if (!this.skipping) {
                this.elements.pop();
            } else if ("page".equals(string2)) {
                this.skipping = false;
            }
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void startDocument() throws SAXException {
            if (this.pageName == null) {
                XMLUIManager.this.pages.clear();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("scheme".equals(string2)) {
                if (!this.elements.isEmpty()) {
                    throw new SAXParseException("scheme element must be the root.", this.locator);
                }
                XMLUIManager.this.name = this.getMandatoryAttribute(attributes, "name");
                XMLUIManager.this.description = this.getMandatoryAttribute(attributes, "description");
                if (XMLUIManager.this.loader == null) {
                    URL[] uRLArray;
                    String[] stringArray;
                    String string4 = attributes.getValue("classpath");
                    String[] stringArray2 = stringArray = string4 != null ? string4.split(";") : new String[]{};
                    if (this.dir.getProtocol().equalsIgnoreCase("jar")) {
                        uRLArray = new URL[stringArray.length + 1];
                        try {
                            uRLArray[stringArray.length] = ((JarURLConnection)this.dir.openConnection()).getJarFileURL();
                        }
                        catch (IOException iOException) {
                            throw new SAXParseException("The jar file is invalid.", this.locator, iOException);
                        }
                    } else {
                        uRLArray = new URL[stringArray.length];
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            uRLArray[i] = new URL(this.dir, stringArray[i]);
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new SAXParseException("The classpath is invalid.", this.locator, malformedURLException);
                        }
                    }
                    if (uRLArray.length == 0) {
                        XMLUIManager.this.loader = this.getClass().getClassLoader();
                    } else {
                        XMLUIManager.this.loader = URLClassLoader.newInstance(uRLArray, this.getClass().getClassLoader());
                    }
                }
                this.elements.push(string2);
                return;
            }
            if ("call".equals(string2)) {
                if (this.skipping) return;
                try {
                    String string5 = this.getMandatoryAttribute(attributes, "class");
                    String string6 = this.getMandatoryAttribute(attributes, "method");
                    Class.forName(string5, true, XMLUIManager.this.loader).getMethod(string6, class$com$topcoder$client$ui$UIManager == null ? (class$com$topcoder$client$ui$UIManager = XMLUIManager.class$("com.topcoder.client.ui.UIManager")) : class$com$topcoder$client$ui$UIManager).invoke(null, XMLUIManager.this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SAXParseException("The invocation class cannot be loaded.", this.locator, classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new SAXParseException("The invocation method cannot be found.", this.locator, noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SAXParseException("The invocation method cannot be accessed.", this.locator, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new SAXParseException("The invocation method causes an error.", this.locator, (Exception)invocationTargetException.getTargetException());
                }
                this.elements.push(string2);
                return;
            }
            if ("page".equals(string2)) {
                if (this.elements.size() != 1) {
                    throw new SAXParseException("Page can only be defined under scheme.", this.locator);
                }
                this.skipping = this.pageName != null && !this.pageName.equals(this.getMandatoryAttribute(attributes, "name"));
                try {
                    if (this.skipping) return;
                    String string7 = this.getMandatoryAttribute(attributes, "class");
                    UIPage uIPage = (UIPage)Class.forName(string7, true, XMLUIManager.this.loader).newInstance();
                    XMLUIManager.this.pages.put(this.getMandatoryAttribute(attributes, "name"), uIPage);
                    this.elements.push(uIPage);
                    XMLUIManager.this.currentPage = uIPage;
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXParseException("The page is not an UIPage.", this.locator, classCastException);
                }
                catch (InstantiationException instantiationException) {
                    throw new SAXParseException("The page does not have a default constructor.", this.locator, instantiationException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SAXParseException("The page class cannot be loaded.", this.locator, classNotFoundException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SAXParseException("The default constructor of the page class is not public.", this.locator, illegalAccessException);
                }
            }
            if ("componentref".equals(string2)) {
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIPage)) {
                    throw new SAXParseException("Component reference can be only used under page.", this.locator);
                }
                try {
                    this.elements.push(XMLUIManager.this.currentPage.getComponent(this.getMandatoryAttribute(attributes, "name")));
                    return;
                }
                catch (UIPageException uIPageException) {
                    throw new SAXParseException("The component reference cannot be found in the page.", this.locator, uIPageException);
                }
            }
            if ("component".equals(string2)) {
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIPage) && !(this.elements.peek() instanceof UIComponent)) {
                    throw new SAXParseException("Only page or component can be added with child components.", this.locator);
                }
                try {
                    UIComponent uIComponent = (UIComponent)Class.forName(this.getMandatoryAttribute(attributes, "class"), true, XMLUIManager.this.loader).newInstance();
                    this.constraints.push(new GridBagConstraints());
                    this.elements.push(uIComponent);
                    XMLUIManager.this.currentPage.addComponent(this.getMandatoryAttribute(attributes, "name"), uIComponent);
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXParseException("The component is not an UIComponent.", this.locator, classCastException);
                }
                catch (InstantiationException instantiationException) {
                    throw new SAXParseException("The component does not have a default constructor.", this.locator, instantiationException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SAXParseException("The component class cannot be loaded.", this.locator, classNotFoundException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SAXParseException("The default constructor of the component class is not public.", this.locator, illegalAccessException);
                }
                catch (UIPageException uIPageException) {
                    throw new SAXParseException("Adding component to the page fails.", this.locator, uIPageException);
                }
            }
            if ("constraints".equals(string2)) {
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIComponent)) {
                    throw new SAXParseException("Only component can be set with constraints.", this.locator);
                }
                GridBagConstraints gridBagConstraints = (GridBagConstraints)this.constraints.peek();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string8 = attributes.getLocalName(i);
                    String string9 = attributes.getValue(i);
                    boolean bl = true;
                    int n = 0;
                    try {
                        n = this.parseConstraintsConstants(string9);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bl = false;
                    }
                    try {
                        if ("insets".equals(string8)) {
                            gridBagConstraints.insets = this.parseIntsets(string9);
                            continue;
                        }
                        if ("weightx".equals(string8)) {
                            gridBagConstraints.weightx = Double.parseDouble(string9);
                            continue;
                        }
                        if ("weighty".equals(string8)) {
                            gridBagConstraints.weighty = Double.parseDouble(string9);
                            continue;
                        }
                        if ("anchor".equals(string8)) {
                            gridBagConstraints.anchor = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if ("fill".equals(string8)) {
                            gridBagConstraints.fill = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if ("gridheight".equals(string8)) {
                            gridBagConstraints.gridheight = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if ("gridwidth".equals(string8)) {
                            gridBagConstraints.gridwidth = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if ("gridx".equals(string8)) {
                            gridBagConstraints.gridx = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if ("gridy".equals(string8)) {
                            gridBagConstraints.gridy = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if ("ipadx".equals(string8)) {
                            gridBagConstraints.ipadx = bl ? n : Integer.parseInt(string9);
                            continue;
                        }
                        if (!"ipady".equals(string8)) throw new SAXParseException("Unknown constraints " + string8 + ".", this.locator);
                        gridBagConstraints.ipady = bl ? n : Integer.parseInt(string9);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SAXParseException("The value of the constraints is invalid.", this.locator, illegalArgumentException);
                    }
                }
                this.elements.push(string2);
                return;
            }
            if ("property".equals(string2)) {
                Object object;
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIComponent)) {
                    throw new SAXParseException("Only component can be set with properties.", this.locator);
                }
                UIComponent uIComponent = (UIComponent)this.elements.peek();
                if (attributes.getValue("parser") != null) {
                    try {
                        UIPropertyValueParser uIPropertyValueParser = (UIPropertyValueParser)Class.forName(attributes.getValue("parser"), true, XMLUIManager.this.loader).newInstance();
                        object = uIPropertyValueParser.parse(XMLUIManager.this.currentPage, this.getMandatoryAttribute(attributes, "value"), XMLUIManager.this.loader);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXParseException("The parser is not an UIPropertyValueParser.", this.locator, classCastException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new SAXParseException("The parser does not have a default constructor.", this.locator, instantiationException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SAXParseException("The parser class cannot be loaded.", this.locator, classNotFoundException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SAXParseException("The default constructor of the parser class is not public.", this.locator, illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SAXParseException("The property value is invalid for the parser.", this.locator, illegalArgumentException);
                    }
                    catch (Exception exception) {
                        throw new SAXParseException("Other error occurred when parsing the value.", this.locator, exception);
                    }
                } else {
                    object = this.getMandatoryAttribute(attributes, "value");
                }
                try {
                    uIComponent.setProperty(this.getMandatoryAttribute(attributes, "name"), object);
                }
                catch (UIComponentException uIComponentException) {
                    throw new SAXParseException("The property cannot be set.", this.locator, uIComponentException);
                }
                this.elements.push(string2);
                return;
            }
            if ("action".equals(string2)) {
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof UIComponent)) {
                    throw new SAXParseException("Only components can perform actions.", this.locator);
                }
                PerformAction performAction = new PerformAction();
                performAction.name = this.getMandatoryAttribute(attributes, "name");
                this.elements.push(performAction);
                return;
            } else {
                Object object;
                if (!"param".equals(string2)) throw new SAXParseException("Illegal element '" + string2 + "' in the configuration file.", this.locator);
                if (this.skipping) {
                    return;
                }
                if (!(this.elements.peek() instanceof PerformAction)) {
                    throw new SAXParseException("Only actions can have parameters.", this.locator);
                }
                PerformAction performAction = (PerformAction)this.elements.peek();
                if (attributes.getValue("parser") != null) {
                    try {
                        UIPropertyValueParser uIPropertyValueParser = (UIPropertyValueParser)Class.forName(attributes.getValue("parser"), true, XMLUIManager.this.loader).newInstance();
                        object = uIPropertyValueParser.parse(XMLUIManager.this.currentPage, this.getMandatoryAttribute(attributes, "value"), XMLUIManager.this.loader);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXParseException("The parser is not an UIPropertyValueParser.", this.locator, classCastException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new SAXParseException("The parser does not have a default constructor.", this.locator, instantiationException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SAXParseException("The parser class cannot be loaded.", this.locator, classNotFoundException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new SAXParseException("The default constructor of the parser class is not public.", this.locator, illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SAXParseException("The property value is invalid for the parser.", this.locator, illegalArgumentException);
                    }
                } else {
                    object = this.getMandatoryAttribute(attributes, "value");
                }
                performAction.params.add(object);
                this.elements.push(string2);
            }
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        private class PerformAction {
            public String name;
            public List params = new ArrayList();

            private PerformAction() {
            }
        }
    }
}

