/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.client.render.DataTypeRenderer;
import com.topcoder.client.render.LongTestCaseRenderer;
import com.topcoder.client.render.ProblemRenderer;
import com.topcoder.client.render.TestCaseRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Constraint;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ElementRenderer;
import com.topcoder.shared.problem.ProblemComponent;
import com.topcoder.shared.problem.TestCase;
import java.awt.Color;

public class ProblemComponentRenderer
extends BaseRenderer
implements ElementRenderer {
    private String SECTION_HEADER = "h3";
    private ProblemComponent problemComponent;
    private String LEFT_MARGIN = "&#160;&#160;&#160;&#160;";
    private Color backgroundColor = null;
    private Color foregroundColor = null;

    public ProblemComponentRenderer() {
        this.problemComponent = null;
    }

    public ProblemComponentRenderer(ProblemComponent problemComponent) {
        this.problemComponent = problemComponent;
    }

    public void setElement(Element element) {
        if (!(element instanceof ProblemComponent)) {
            throw new IllegalArgumentException("element must be a ProblemComponent Object.");
        }
        this.problemComponent = (ProblemComponent)element;
    }

    public String toHTML(Language language) throws Exception {
        return this.toHTML(language, true, false);
    }

    public String toHTML(Language language, boolean bl) throws Exception {
        return this.toHTML(language, bl, false);
    }

    public String toHTML(Language language, boolean bl, boolean bl2) throws Exception {
        TestCase[] testCaseArray;
        Constraint[] constraintArray;
        Element[] elementArray;
        StringBuffer stringBuffer = new StringBuffer(4096);
        if (bl) {
            stringBuffer.append("<html>");
            stringBuffer.append("<body");
            if (this.backgroundColor != null) {
                stringBuffer.append(" bgcolor=\"#");
                stringBuffer.append(ProblemRenderer.rgbColor(this.backgroundColor));
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(" bgcolor='black'");
            }
            if (this.foregroundColor != null) {
                stringBuffer.append(" text=\"#");
                stringBuffer.append(ProblemRenderer.rgbColor(this.foregroundColor));
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(" text='white'");
            }
            stringBuffer.append(">");
        }
        stringBuffer.append("<table>");
        stringBuffer.append("<tr>");
        stringBuffer.append("<td colspan=\"2\">");
        if (bl2) {
            ProblemComponentRenderer.appendTag(stringBuffer, this.SECTION_HEADER, "Problem Statement for Primary Component");
        } else {
            ProblemComponentRenderer.appendTag(stringBuffer, this.SECTION_HEADER, "Problem Statement");
        }
        stringBuffer.append("</td>");
        stringBuffer.append("</tr>");
        if (this.problemComponent.getIntro() != null) {
            stringBuffer.append("<tr>");
            stringBuffer.append("<td>");
            stringBuffer.append(this.LEFT_MARGIN);
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(super.getRenderer(this.problemComponent.getIntro()).toHTML(language));
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("<tr>");
        stringBuffer.append("<td colspan=\"2\">");
        ProblemComponentRenderer.appendTag(stringBuffer, this.SECTION_HEADER, "Definition");
        stringBuffer.append("</td>");
        stringBuffer.append("</tr>");
        stringBuffer.append("<tr>");
        stringBuffer.append("<td>");
        stringBuffer.append(this.LEFT_MARGIN);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        stringBuffer.append("<table>");
        stringBuffer.append("<tr>");
        stringBuffer.append("<td>Class:</td>");
        stringBuffer.append("<td>");
        stringBuffer.append(this.problemComponent.getClassName());
        stringBuffer.append("</td>");
        stringBuffer.append("</tr>");
        String[] stringArray = this.problemComponent.getAllMethodNames();
        DataType[][] dataTypeArray = this.problemComponent.getAllParamTypes();
        String[][] stringArray2 = this.problemComponent.getAllParamNames();
        DataType[] dataTypeArray2 = this.problemComponent.getAllReturnTypes();
        boolean bl3 = false;
        if (stringArray.length > 0) {
            Object[] objectArray;
            int n;
            int n2 = n = stringArray.length == 1 ? 0 : 1;
            if (n == 1) {
                bl3 = true;
            }
            while (n < stringArray.length) {
                stringBuffer.append("<tr><td>Method:</td>");
                stringBuffer.append("<td>");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
                stringBuffer.append("<tr><td>Parameters:</td>");
                stringBuffer.append("<td>");
                objectArray = dataTypeArray[n];
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(new DataTypeRenderer((DataType)objectArray[i]).toHTML(language));
                }
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
                stringBuffer.append("<tr><td>Returns:</td>");
                stringBuffer.append("<td>");
                stringBuffer.append(new DataTypeRenderer(dataTypeArray2[n]).toHTML(language));
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
                stringBuffer.append("<tr><td>Method signature:</td>");
                stringBuffer.append("<td>");
                stringBuffer.append(ProblemComponentRenderer.encodeHTML(language.getMethodSignature(stringArray[n], dataTypeArray2[n], (DataType[])objectArray, stringArray2[n])));
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
                if (language.getId() != 6 && n == stringArray.length - 1) {
                    if (stringArray.length > 1) {
                        stringBuffer.append("<tr><td colspan=\"2\">(be sure your methods are public)</td></tr>");
                    } else {
                        stringBuffer.append("<tr><td colspan=\"2\">(be sure your method is public)</td></tr>");
                    }
                } else {
                    stringBuffer.append("<tr><td colspan=\"2\"></td></tr>");
                }
                ++n;
            }
            stringBuffer.append("</table>");
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
            objectArray = this.problemComponent.getAllExposedMethodNames();
            DataType[][] dataTypeArray3 = this.problemComponent.getAllExposedParamTypes();
            String[][] stringArray3 = this.problemComponent.getAllExposedParamNames();
            DataType[] dataTypeArray4 = this.problemComponent.getAllExposedReturnTypes();
            if (objectArray.length > 0) {
                stringBuffer.append("<tr>");
                stringBuffer.append("<td colspan=\"2\">");
                ProblemComponentRenderer.appendTag(stringBuffer, this.SECTION_HEADER, "Available Libraries");
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
                stringBuffer.append("<tr>");
                stringBuffer.append("<td>");
                stringBuffer.append(this.LEFT_MARGIN);
                stringBuffer.append("</td>");
                stringBuffer.append("<td>");
                stringBuffer.append("<table>");
                stringBuffer.append("<tr>");
                stringBuffer.append("<td>Class:</td>");
                stringBuffer.append("<td>");
                stringBuffer.append(this.problemComponent.getExposedClassName());
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
                for (n = 0; n < objectArray.length; ++n) {
                    stringBuffer.append("<tr><td>Method:</td>");
                    stringBuffer.append("<td>");
                    stringBuffer.append((String)objectArray[n]);
                    stringBuffer.append("</td>");
                    stringBuffer.append("</tr>");
                    stringBuffer.append("<tr><td>Parameters:</td>");
                    stringBuffer.append("<td>");
                    DataType[] dataTypeArray5 = dataTypeArray3[n];
                    for (int i = 0; i < dataTypeArray5.length; ++i) {
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(new DataTypeRenderer(dataTypeArray5[i]).toHTML(language));
                    }
                    stringBuffer.append("</td>");
                    stringBuffer.append("</tr>");
                    stringBuffer.append("<tr><td>Returns:</td>");
                    stringBuffer.append("<td>");
                    stringBuffer.append(new DataTypeRenderer(dataTypeArray4[n]).toHTML(language));
                    stringBuffer.append("</td>");
                    stringBuffer.append("</tr>");
                    stringBuffer.append("<tr><td>Sample Call:</td>");
                    stringBuffer.append("<td>");
                    stringBuffer.append(ProblemComponentRenderer.encodeHTML(language.exampleExposedCall(this.problemComponent.getExposedClassName(), (String)objectArray[n], stringArray3[n])));
                    stringBuffer.append("</td>");
                    stringBuffer.append("</tr>");
                }
                stringBuffer.append("</table>");
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
            }
        } else {
            stringBuffer.append("<tr><td>Method:</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(this.problemComponent.getMethodName());
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
            stringBuffer.append("<tr><td>Parameters:</td>");
            stringBuffer.append("<td>");
            DataType[] dataTypeArray6 = this.problemComponent.getParamTypes();
            for (int i = 0; i < dataTypeArray6.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(new DataTypeRenderer(dataTypeArray6[i]).toHTML(language));
            }
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
            stringBuffer.append("<tr><td>Returns:</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(new DataTypeRenderer(this.problemComponent.getReturnType()).toHTML(language));
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
            stringBuffer.append("<tr><td>Method signature:</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(ProblemComponentRenderer.encodeHTML(language.getMethodSignature(this.problemComponent.getMethodName(), this.problemComponent.getReturnType(), this.problemComponent.getParamTypes(), this.problemComponent.getParamNames())));
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
            if (language.getId() != 6) {
                stringBuffer.append("<tr><td colspan=\"2\">(be sure your method is public)</td></tr>");
            }
            stringBuffer.append("</table>");
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
        }
        if (this.problemComponent.getSpec() != null) {
            stringBuffer.append("<tr>");
            stringBuffer.append("<td>");
            stringBuffer.append(this.LEFT_MARGIN);
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
            stringBuffer.append("<tr>");
            stringBuffer.append("<td>");
            stringBuffer.append(super.getRenderer(this.problemComponent.getSpec()).toHTML(language));
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
        }
        if ((elementArray = this.problemComponent.getNotes()) != null && elementArray.length > 0) {
            stringBuffer.append("<tr>");
            stringBuffer.append("<td colspan=\"2\">");
            ProblemComponentRenderer.appendTag(stringBuffer, this.SECTION_HEADER, "Notes");
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
            for (int i = 0; i < elementArray.length; ++i) {
                stringBuffer.append("<tr>");
                stringBuffer.append("<td align=\"center\" valign=\"top\">");
                stringBuffer.append("-");
                stringBuffer.append("</td>");
                stringBuffer.append("<td>");
                stringBuffer.append(super.getRenderer(elementArray[i]).toHTML(language));
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
            }
        }
        if ((constraintArray = this.problemComponent.getConstraints()) != null && constraintArray.length > 0) {
            stringBuffer.append("<tr>");
            stringBuffer.append("<td colspan=\"2\">");
            ProblemComponentRenderer.appendTag(stringBuffer, this.SECTION_HEADER, "Constraints");
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>");
            for (int i = 0; i < constraintArray.length; ++i) {
                stringBuffer.append("<tr>");
                stringBuffer.append("<td align=\"center\" valign=\"top\">");
                stringBuffer.append("-");
                stringBuffer.append("</td>");
                stringBuffer.append("<td>");
                stringBuffer.append(super.getRenderer(constraintArray[i]).toHTML(language));
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
            }
        }
        if ((testCaseArray = this.problemComponent.getTestCases()) != null && testCaseArray.length > 0) {
            int n;
            boolean bl4 = false;
            for (n = 0; n < testCaseArray.length && !bl4; ++n) {
                bl4 = testCaseArray[n].isExample();
            }
            if (bl4) {
                stringBuffer.append("<tr>");
                stringBuffer.append("<td colspan=\"2\">");
                ProblemComponentRenderer.appendTag(stringBuffer, this.SECTION_HEADER, "Examples");
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
                n = 0;
                for (int i = 0; i < testCaseArray.length; ++i) {
                    if (!testCaseArray[i].isExample()) continue;
                    stringBuffer.append("<tr>");
                    stringBuffer.append("<td align=\"center\" nowrap=\"true\">");
                    stringBuffer.append(n + ")");
                    stringBuffer.append("</td>");
                    stringBuffer.append("<td>");
                    stringBuffer.append("</td>");
                    stringBuffer.append("</tr>");
                    stringBuffer.append("<tr>");
                    stringBuffer.append("<td>");
                    stringBuffer.append(this.LEFT_MARGIN);
                    stringBuffer.append("</td>");
                    stringBuffer.append("<td>");
                    if (bl3) {
                        stringBuffer.append(new LongTestCaseRenderer(testCaseArray[i]).toHTML(language));
                    } else {
                        stringBuffer.append(new TestCaseRenderer(testCaseArray[i]).toHTML(language));
                    }
                    stringBuffer.append("</td>");
                    stringBuffer.append("</tr>");
                    ++n;
                }
            }
        }
        stringBuffer.append("</table>");
        if (bl) {
            stringBuffer.append("<p>");
            stringBuffer.append("This problem statement is the exclusive and proprietary property of TopCoder, Inc.  Any unauthorized use or reproduction of this information without the prior written consent of TopCoder, Inc. is strictly prohibited.  (c)2003, TopCoder, Inc.  All rights reserved.  ");
            stringBuffer.append("</p>");
            stringBuffer.append("</body>");
            stringBuffer.append("</html>");
        }
        return stringBuffer.toString();
    }

    static void appendTag(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append('<');
        stringBuffer.append(string);
        stringBuffer.append('>');
        stringBuffer.append(string2);
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append('>');
    }

    public static String encodeHTML(String string) {
        return ProblemRenderer.encodeHTML(string);
    }

    public String toPlainText(Language language) throws Exception {
        TestCase[] testCaseArray;
        Constraint[] constraintArray;
        Element[] elementArray;
        StringBuffer stringBuffer = new StringBuffer(4000);
        stringBuffer.append("PROBLEM STATEMENT\n");
        if (this.problemComponent.getIntro() != null) {
            stringBuffer.append(super.getRenderer(this.problemComponent.getIntro()).toPlainText(language));
        }
        stringBuffer.append("\n\nDEFINITION");
        stringBuffer.append("\nClass:");
        stringBuffer.append(this.problemComponent.getClassName());
        stringBuffer.append("\nMethod:");
        stringBuffer.append(this.problemComponent.getMethodName());
        stringBuffer.append("\nParameters:");
        DataType[] dataTypeArray = this.problemComponent.getParamTypes();
        for (int i = 0; i < dataTypeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(new DataTypeRenderer(dataTypeArray[i]).toPlainText(language));
        }
        stringBuffer.append("\nReturns:");
        stringBuffer.append(new DataTypeRenderer(this.problemComponent.getReturnType()).toPlainText(language));
        stringBuffer.append("\nMethod signature:");
        stringBuffer.append(language.getMethodSignature(this.problemComponent.getMethodName(), this.problemComponent.getReturnType(), this.problemComponent.getParamTypes(), this.problemComponent.getParamNames()));
        stringBuffer.append("\n");
        if (this.problemComponent.getSpec() != null) {
            stringBuffer.append(super.getRenderer(this.problemComponent.getSpec()).toPlainText(language));
        }
        if ((elementArray = this.problemComponent.getNotes()) != null && elementArray.length > 0) {
            stringBuffer.append("\n\nNOTES\n");
            for (int i = 0; i < elementArray.length; ++i) {
                stringBuffer.append("-");
                stringBuffer.append(super.getRenderer(elementArray[i]).toPlainText(language));
                stringBuffer.append("\n");
            }
        }
        if ((constraintArray = this.problemComponent.getConstraints()) != null && constraintArray.length > 0) {
            stringBuffer.append("\n\nCONSTRAINTS\n");
            for (int i = 0; i < constraintArray.length; ++i) {
                stringBuffer.append("-");
                stringBuffer.append(super.getRenderer(constraintArray[i]).toPlainText(language));
                stringBuffer.append("\n");
            }
        }
        if ((testCaseArray = this.problemComponent.getTestCases()) != null && testCaseArray.length > 0) {
            stringBuffer.append("\n\nEXAMPLES\n");
            int n = 0;
            for (int i = 0; i < testCaseArray.length; ++i) {
                if (!testCaseArray[i].isExample()) continue;
                stringBuffer.append("\n" + n + ")\n");
                stringBuffer.append(new TestCaseRenderer(testCaseArray[i]).toPlainText(language));
                stringBuffer.append("\n");
                ++n;
            }
        }
        return BaseRenderer.removeHtmlTags(stringBuffer.toString());
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }
}

