/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.RendererFactory;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ElementRenderer;

abstract class BaseRenderer
implements ElementRenderer {
    static String[] XML_ONLY_TAGS = new String[]{"tctype", "list", "fontstyle", "heading", "special", "inline", "type", "block", "flow", "type", "problem", "signature", "intro", "spec", "notes", "note", "constraints", "user-constraint", "test-cases", "test-case", "input", "output", "annotation", "example", "name"};
    static String[] HTML_ONLY_TAGS = new String[]{"ul", "ol", "li", "tt", "i", "b", "h1", "h2", "h3", "h4", "h5", "a", "img", "br", "sub", "sup", "p", "pre", "hr", "list"};
    private static final RendererFactory RENDERER_FACTORY_DEFAULT = new RendererFactory();
    private RendererFactory rendererFactory;

    BaseRenderer() {
    }

    public abstract String toHTML(Language var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception;

    public abstract String toPlainText(Language var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception;

    static String encodeHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    ElementRenderer getRenderer(Element element) throws Exception {
        if (this.rendererFactory == null) {
            this.rendererFactory = RENDERER_FACTORY_DEFAULT;
        }
        return this.rendererFactory.getRenderer(element);
    }

    static String removeHtmlTags(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < HTML_ONLY_TAGS.length; ++i) {
            boolean bl = false;
            while (!bl) {
                int n = stringBuffer.indexOf("<" + HTML_ONLY_TAGS[i] + ">");
                int n2 = stringBuffer.indexOf("</" + HTML_ONLY_TAGS[i] + ">");
                int n3 = stringBuffer.indexOf("<" + HTML_ONLY_TAGS[i] + "/>");
                boolean bl2 = bl = n < 0 && n2 < 0 && n3 < 0;
                if (n > -1) {
                    stringBuffer.delete(n, n + HTML_ONLY_TAGS[i].length() + 2);
                }
                if (n2 > -1) {
                    stringBuffer.delete(n2, n2 + HTML_ONLY_TAGS[i].length() + 3);
                }
                if (n3 <= -1) continue;
                stringBuffer.delete(n3, n3 + HTML_ONLY_TAGS[i].length() + 3);
            }
        }
        return stringBuffer.toString();
    }

    public RendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public void setRendererFactory(RendererFactory rendererFactory) {
        this.rendererFactory = rendererFactory;
    }
}

