/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.netClient;

import com.topcoder.client.netClient.ResponseToSyncRequestWaiter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ResponseWaiterManager {
    private Map waiters = new HashMap(101, 0.7f);
    private int lastRequestIdStarted = -1;
    private long startTimeout;
    private long endTimeout;
    private long inactivityTimeout;

    public ResponseWaiterManager() {
        this(ResponseToSyncRequestWaiter.getStartTimeoutDefault(), ResponseToSyncRequestWaiter.getEndTimeoutDefault(), ResponseToSyncRequestWaiter.getInactivityTimeoutDefault());
    }

    public ResponseWaiterManager(long l, long l2, long l3) {
        this.startTimeout = l;
        this.endTimeout = l2;
        this.inactivityTimeout = l3;
    }

    public ResponseToSyncRequestWaiter registerWaiterFor(int n) {
        return this.registerWaiterFor(n, this.startTimeout, this.endTimeout, this.inactivityTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseToSyncRequestWaiter registerWaiterFor(int n, long l, long l2, long l3) {
        ResponseToSyncRequestWaiter responseToSyncRequestWaiter;
        Map map = this.waiters;
        synchronized (map) {
            responseToSyncRequestWaiter = new ResponseToSyncRequestWaiter(l, l2, l3);
            this.waiters.put(new Integer(n), responseToSyncRequestWaiter);
        }
        return responseToSyncRequestWaiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockAll() {
        Map map = this.waiters;
        synchronized (map) {
            Iterator iterator = this.waiters.values().iterator();
            while (iterator.hasNext()) {
                ResponseToSyncRequestWaiter responseToSyncRequestWaiter = (ResponseToSyncRequestWaiter)iterator.next();
                responseToSyncRequestWaiter.unblock();
            }
            this.waiters.clear();
        }
    }

    public void startOfSyncResponse(int n) {
        ResponseToSyncRequestWaiter responseToSyncRequestWaiter = this.getWaiter(n);
        if (responseToSyncRequestWaiter != null) {
            this.lastRequestIdStarted = n;
            responseToSyncRequestWaiter.startOfResponse();
        }
    }

    public boolean endOfSyncResponse(int n) {
        ResponseToSyncRequestWaiter responseToSyncRequestWaiter = this.getWaiter(n);
        if (responseToSyncRequestWaiter != null) {
            responseToSyncRequestWaiter.endOfResponse();
            return true;
        }
        return false;
    }

    public void dataRead() {
        ResponseToSyncRequestWaiter responseToSyncRequestWaiter = this.getWaiter(this.lastRequestIdStarted);
        if (responseToSyncRequestWaiter != null) {
            responseToSyncRequestWaiter.dataRead();
        }
    }

    public void unblock(int n) {
        ResponseToSyncRequestWaiter responseToSyncRequestWaiter = this.getWaiter(n);
        if (responseToSyncRequestWaiter != null) {
            responseToSyncRequestWaiter.unblock();
        }
    }

    public void unregisterWaiterFor(int n) {
        this.removeWaiter(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseToSyncRequestWaiter getWaiter(int n) {
        ResponseToSyncRequestWaiter responseToSyncRequestWaiter;
        Map map = this.waiters;
        synchronized (map) {
            responseToSyncRequestWaiter = (ResponseToSyncRequestWaiter)this.waiters.get(new Integer(n));
        }
        return responseToSyncRequestWaiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseToSyncRequestWaiter removeWaiter(int n) {
        ResponseToSyncRequestWaiter responseToSyncRequestWaiter;
        Map map = this.waiters;
        synchronized (map) {
            responseToSyncRequestWaiter = (ResponseToSyncRequestWaiter)this.waiters.remove(new Integer(n));
        }
        return responseToSyncRequestWaiter;
    }
}

