/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.netClient;

import com.topcoder.shared.util.concurrent.Waiter;

public class ResponseToSyncRequestWaiter {
    private long startTimeout;
    private long endTimeout;
    private long inactivityTimeout;
    private boolean started;
    private boolean finished;
    private boolean dataRead;
    private Object mutex = new Object();
    private boolean timeout;

    public ResponseToSyncRequestWaiter(long l, long l2, long l3) {
        this.startTimeout = l;
        this.endTimeout = l2;
        this.inactivityTimeout = l3;
    }

    public boolean block() throws InterruptedException {
        return this.blockUntilEnd();
    }

    public void unblock() {
        this.endOfResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockUntilEnd() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            Waiter waiter = new Waiter(this.startTimeout, this.mutex);
            while (!(this.started || this.finished || waiter.elapsed() || this.timeout)) {
                waiter.await();
            }
            if (this.started && !this.finished && !this.timeout) {
                this.dataRead = true;
                waiter = new Waiter(this.endTimeout, this.mutex);
                while (!this.timeout && !this.finished && this.dataRead && !waiter.elapsed()) {
                    long l = Math.min(Math.max(waiter.getRemaining(), 1L), this.inactivityTimeout);
                    this.dataRead = false;
                    Waiter waiter2 = new Waiter(l, this.mutex);
                    while (!(this.timeout || this.finished || this.dataRead || waiter2.elapsed())) {
                        waiter2.await();
                    }
                }
            }
            return this.timeout || !this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startOfResponse() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOfResponse() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRead() {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.started || this.finished) {
                return;
            }
            this.dataRead = true;
            this.mutex.notifyAll();
        }
    }

    public static long getStartTimeoutDefault() {
        return ResponseToSyncRequestWaiter.resolveValue("com.topcoder.response.start.timeout", 30000L);
    }

    public static long getEndTimeoutDefault() {
        return ResponseToSyncRequestWaiter.resolveValue("com.topcoder.response.end.timeout", 1800000L);
    }

    public static long getInactivityTimeoutDefault() {
        return ResponseToSyncRequestWaiter.resolveValue("com.topcoder.response.inactivity.timeout", 60000L);
    }

    private static long resolveValue(String string, long l) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Long.parseLong(string2);
        }
        return l;
    }
}

