/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.impl.ContestantImpl;
import com.topcoder.client.contestant.impl.ProblemComponentModelImpl;
import com.topcoder.client.contestant.impl.ProblemModelImpl;
import com.topcoder.client.contestant.impl.RoomModelImpl;
import com.topcoder.client.contestant.view.EventService;
import com.topcoder.client.contestant.view.LeaderListener;
import com.topcoder.client.contestant.view.PhaseListener;
import com.topcoder.client.contestant.view.RoundProblemsListener;
import com.topcoder.netCommon.contest.round.RoundCustomProperties;
import com.topcoder.netCommon.contest.round.RoundProperties;
import com.topcoder.netCommon.contest.round.RoundType;
import com.topcoder.netCommon.contestantMessages.response.data.ComponentLabel;
import com.topcoder.netCommon.contestantMessages.response.data.LeaderboardItem;
import com.topcoder.netCommon.contestantMessages.response.data.PhaseData;
import com.topcoder.netCommon.contestantMessages.response.data.ProblemLabel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

class RoundModelImpl
implements RoundModel {
    private Long roundID;
    private String contestName;
    private int roundCategoryID;
    private String roundName;
    private Integer roundType;
    private Integer phase;
    private boolean menuStatus;
    private ContestantImpl contestantModel;
    private EventService eventService;
    private long endOfPhase;
    private HashSet roomLeadersSet = new HashSet();
    private LeaderboardItem[] leaderboard;
    private RoomModelImpl[] coderRooms;
    private RoomModelImpl adminRoom;
    private HashMap problems = new HashMap();
    private HashMap assignedComponents = new HashMap();
    private PhaseData[] schedule;
    private RoundType roundTypeImpl;
    private RoundProperties roundProperties;
    private Vector leaderListeners = new Vector();
    private Vector phaseViews = new Vector();
    private Vector roundProblemsViews = new Vector();

    public RoundModelImpl(ContestantImpl contestantImpl, long l, String string, String string2, int n, PhaseData phaseData) {
        this.roundID = new Long(l);
        this.contestName = string;
        this.roundName = string2;
        this.roundType = new Integer(n);
        this.phase = new Integer(phaseData.getPhaseType());
        this.endOfPhase = phaseData.getEndTime();
        this.contestantModel = contestantImpl;
        this.menuStatus = false;
        this.eventService = contestantImpl.getEventService();
        this.roundTypeImpl = RoundType.get(n);
    }

    public RoundModelImpl(ContestantImpl contestantImpl, long l, String string, String string2, int n, PhaseData phaseData, int n2, RoundCustomProperties roundCustomProperties) {
        this(contestantImpl, l, string, string2, n, phaseData);
        this.roundCategoryID = n2;
        this.setRoundCustomProperties(roundCustomProperties);
    }

    public int getRoundCategoryID() {
        return this.roundCategoryID;
    }

    public Long getRoundID() {
        return this.roundID;
    }

    public String getContestName() {
        return this.contestName;
    }

    public String getRoundName() {
        return this.roundName;
    }

    public String getDisplayName() {
        if (this.getRoundType().isLongRound()) {
            if (this.getRoundTypeId() == 19) {
                return this.getContestName() + " - " + this.getRoundName();
            }
            return this.getContestName();
        }
        return this.getContestName() + " - " + this.getRoundName();
    }

    public String getSingleName() {
        if (this.getRoundType().isPracticeRound() && this.getRoundType().isLongRound()) {
            return this.getRoundName();
        }
        return this.getContestName();
    }

    public Integer getRoundTypeId() {
        return this.roundType;
    }

    public synchronized Integer getPhase() {
        return this.phase;
    }

    public synchronized boolean getMenuStatus() {
        return this.menuStatus;
    }

    synchronized void setMenuStatus(boolean bl) {
        this.menuStatus = bl;
        Runnable runnable = new Runnable(){

            public void run() {
                Iterator iterator = RoundModelImpl.this.phaseViews.iterator();
                while (iterator.hasNext()) {
                    ((PhaseListener)iterator.next()).enableRound(RoundModelImpl.this);
                }
            }
        };
        this.eventService.invokeLater(runnable);
    }

    public synchronized int getSecondsLeftInPhase() {
        long l = this.endOfPhase - this.contestantModel.getServerTime();
        return l > 0L ? (int)(l / 1000L) : 0;
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        this.phaseViews.add(phaseListener);
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        this.phaseViews.remove(phaseListener);
    }

    public boolean containsPhaseListener(PhaseListener phaseListener) {
        return this.phaseViews.contains(phaseListener);
    }

    public void addRoundProblemsListener(RoundProblemsListener roundProblemsListener) {
        this.roundProblemsViews.add(roundProblemsListener);
    }

    public void removeRoundProblemsListener(RoundProblemsListener roundProblemsListener) {
        this.roundProblemsViews.remove(roundProblemsListener);
    }

    synchronized void setPhase(final int n, long l) {
        this.phase = new Integer(n);
        this.endOfPhase = l;
        Runnable runnable = new Runnable(){

            public void run() {
                Iterator iterator = RoundModelImpl.this.phaseViews.iterator();
                while (iterator.hasNext()) {
                    ((PhaseListener)iterator.next()).phaseEvent(n, RoundModelImpl.this);
                }
            }
        };
        this.eventService.invokeLater(runnable);
    }

    void updateSystestProgress(final int n, final int n2) {
        Runnable runnable = new Runnable(){

            public void run() {
                Iterator iterator = RoundModelImpl.this.phaseViews.iterator();
                while (iterator.hasNext()) {
                    ((PhaseListener)iterator.next()).updateSystestProgress(n, n2, RoundModelImpl.this);
                }
            }
        };
        this.eventService.invokeLater(runnable);
    }

    public synchronized boolean hasLeaderboard() {
        return this.leaderboard != null;
    }

    public synchronized LeaderboardItem[] getLeaderboard() {
        return this.leaderboard;
    }

    public boolean isRoomLeader(String string) {
        return this.roomLeadersSet.contains(string);
    }

    synchronized void setLeaderboard(LeaderboardItem[] leaderboardItemArray) {
        this.leaderboard = leaderboardItemArray;
        this.roomLeadersSet.clear();
        for (int i = 0; i < leaderboardItemArray.length; ++i) {
            this.roomLeadersSet.add(leaderboardItemArray[i].getUserName());
        }
    }

    synchronized void updateLeaderboard(RoomModelImpl roomModelImpl, LeaderboardItem leaderboardItem) {
        if (this.leaderboard == null) {
            throw new IllegalStateException("Unitialized leaderboard for round #" + this.roundID);
        }
        for (int i = 0; i < this.leaderboard.length; ++i) {
            if (this.leaderboard[i].getRoomID() != leaderboardItem.getRoomID()) continue;
            this.roomLeadersSet.remove(this.leaderboard[i].getUserName());
            this.updateLeader(roomModelImpl, leaderboardItem, i);
            return;
        }
        LeaderboardItem[] leaderboardItemArray = new LeaderboardItem[this.leaderboard.length + 1];
        System.arraycopy(this.leaderboard, 0, leaderboardItemArray, 0, this.leaderboard.length);
        this.leaderboard = leaderboardItemArray;
        this.updateLeader(roomModelImpl, leaderboardItem, this.leaderboard.length - 1);
    }

    private void updateLeader(RoomModelImpl roomModelImpl, LeaderboardItem leaderboardItem, int n) {
        this.leaderboard[n] = leaderboardItem;
        this.roomLeadersSet.add(leaderboardItem.getUserName());
        this.notifyLeaderListeners(roomModelImpl);
    }

    public synchronized boolean hasAdminRoom() {
        return this.adminRoom != null;
    }

    public synchronized RoomModel getAdminRoom() {
        return this.adminRoom;
    }

    synchronized void setAdminRoom(RoomModelImpl roomModelImpl) {
        this.adminRoom = roomModelImpl;
        Runnable runnable = new Runnable(){

            public void run() {
                Iterator iterator = RoundModelImpl.this.phaseViews.iterator();
                while (iterator.hasNext()) {
                    ((PhaseListener)iterator.next()).roomListEvent(RoundModelImpl.this);
                }
            }
        };
        this.eventService.invokeLater(runnable);
    }

    public synchronized boolean hasCoderRooms() {
        return this.coderRooms != null && this.coderRooms.length > 0;
    }

    public synchronized RoomModel[] getCoderRooms() {
        return this.coderRooms;
    }

    synchronized void setCoderRooms(RoomModelImpl[] roomModelImplArray) {
        this.coderRooms = roomModelImplArray;
        Runnable runnable = new Runnable(){

            public void run() {
                Iterator iterator = RoundModelImpl.this.phaseViews.iterator();
                while (iterator.hasNext()) {
                    ((PhaseListener)iterator.next()).roomListEvent(RoundModelImpl.this);
                }
            }
        };
        this.eventService.invokeLater(runnable);
    }

    public synchronized boolean hasProblems(Integer n) {
        return this.problems.get(n) != null;
    }

    public synchronized ProblemComponentModel[] getAssignedComponents(Integer n) {
        if (this.assignedComponents.containsKey(n)) {
            return (ProblemComponentModelImpl[])this.assignedComponents.get(n);
        }
        throw new IllegalArgumentException("No assigned components for division: " + n);
    }

    public synchronized ProblemModel[] getProblems(Integer n) {
        return this.getProblemsImpl(n);
    }

    synchronized ProblemModelImpl[] getProblemsImpl(Integer n) {
        if (this.problems.containsKey(n)) {
            return (ProblemModelImpl[])this.problems.get(n);
        }
        throw new IllegalArgumentException("No problems for division: " + n);
    }

    public synchronized ProblemModel getProblem(Integer n, Long l) {
        return this.getProblemImpl(n, l);
    }

    synchronized ProblemModelImpl getProblemImpl(Integer n, Long l) {
        ProblemModelImpl[] problemModelImplArray = this.getProblemsImpl(n);
        for (int i = 0; i < problemModelImplArray.length; ++i) {
            ProblemModelImpl problemModelImpl = problemModelImplArray[i];
            if (!problemModelImpl.getProblemID().equals(l)) continue;
            return problemModelImpl;
        }
        throw new IllegalArgumentException("Bad problemID: " + l);
    }

    public synchronized ProblemComponentModel getComponent(Integer n, Long l) {
        return this.getComponentImpl(n, l);
    }

    synchronized ProblemComponentModelImpl getComponentImpl(Integer n, Long l) {
        ProblemModelImpl[] problemModelImplArray = this.getProblemsImpl(n);
        for (int i = 0; i < problemModelImplArray.length; ++i) {
            ProblemComponentModel[] problemComponentModelArray = problemModelImplArray[i].getComponents();
            for (int j = 0; j < problemComponentModelArray.length; ++j) {
                ProblemComponentModel problemComponentModel = problemComponentModelArray[j];
                if (!problemComponentModel.getID().equals(l)) continue;
                return (ProblemComponentModelImpl)problemComponentModel;
            }
        }
        throw new IllegalArgumentException("Bad componentID: " + l);
    }

    synchronized void setAssignedComponents(Integer n, ComponentLabel[] componentLabelArray) {
        ProblemComponentModelImpl[] problemComponentModelImplArray = new ProblemComponentModelImpl[componentLabelArray.length];
        for (int i = 0; i < componentLabelArray.length; ++i) {
            problemComponentModelImplArray[i] = new ProblemComponentModelImpl(componentLabelArray[i].getComponentID(), componentLabelArray[i].getComponentTypeID(), componentLabelArray[i].getPointValue(), componentLabelArray[i].getClassName(), componentLabelArray[i].getComponentChallengeData(), this.getProblem(n, componentLabelArray[i].getProblemID()));
        }
        Arrays.sort(problemComponentModelImplArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ProblemComponentModel problemComponentModel = (ProblemComponentModel)object;
                ProblemComponentModel problemComponentModel2 = (ProblemComponentModel)object2;
                return problemComponentModel.getPoints().compareTo(problemComponentModel2.getPoints());
            }
        });
        this.assignedComponents.put(n, problemComponentModelImplArray);
        Runnable runnable = new Runnable(){

            public void run() {
                Iterator iterator = RoundModelImpl.this.roundProblemsViews.iterator();
                while (iterator.hasNext()) {
                    ((RoundProblemsListener)iterator.next()).roundProblemsEvent();
                }
            }
        };
        this.eventService.invokeLater(runnable);
    }

    synchronized void setProblems(Integer n, ComponentLabel[] componentLabelArray, ProblemLabel[] problemLabelArray) {
        ProblemModelImpl[] problemModelImplArray = new ProblemModelImpl[problemLabelArray.length];
        for (int i = 0; i < problemLabelArray.length; ++i) {
            ProblemLabel problemLabel = problemLabelArray[i];
            problemModelImplArray[i] = new ProblemModelImpl(problemLabel.getProblemID(), this, n, problemLabel.getName(), problemLabel.getProblemTypeID(), this.eventService);
            ProblemComponentModelImpl[] problemComponentModelImplArray = new ProblemComponentModelImpl[problemLabel.getComponents().length];
            for (int j = 0; j < problemLabel.getComponents().length; ++j) {
                problemComponentModelImplArray[j] = new ProblemComponentModelImpl(problemLabel.getComponents()[j].getComponentID(), problemLabel.getComponents()[j].getComponentTypeID(), problemLabel.getComponents()[j].getPointValue(), problemLabel.getComponents()[j].getClassName(), problemLabel.getComponents()[j].getComponentChallengeData(), problemModelImplArray[i]);
            }
            problemModelImplArray[i].setComponents(problemComponentModelImplArray);
        }
        Arrays.sort(problemModelImplArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ProblemModelImpl problemModelImpl = (ProblemModelImpl)object;
                ProblemModelImpl problemModelImpl2 = (ProblemModelImpl)object2;
                return problemModelImpl.getPrimaryComponent().getPoints().compareTo(problemModelImpl2.getPrimaryComponent().getPoints());
            }
        });
        this.problems.put(n, problemModelImplArray);
        ProblemComponentModelImpl[] problemComponentModelImplArray = new ProblemComponentModelImpl[componentLabelArray.length];
        for (int i = 0; i < componentLabelArray.length; ++i) {
            problemComponentModelImplArray[i] = new ProblemComponentModelImpl(componentLabelArray[i].getComponentID(), componentLabelArray[i].getComponentTypeID(), componentLabelArray[i].getPointValue(), componentLabelArray[i].getClassName(), componentLabelArray[i].getComponentChallengeData(), this.getProblem(n, componentLabelArray[i].getProblemID()));
        }
        Arrays.sort(problemComponentModelImplArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ProblemComponentModel problemComponentModel = (ProblemComponentModel)object;
                ProblemComponentModel problemComponentModel2 = (ProblemComponentModel)object2;
                return problemComponentModel.getPoints().compareTo(problemComponentModel2.getPoints());
            }
        });
        this.assignedComponents.put(n, problemComponentModelImplArray);
        Runnable runnable = new Runnable(){

            public void run() {
                Iterator iterator = RoundModelImpl.this.roundProblemsViews.iterator();
                while (iterator.hasNext()) {
                    ((RoundProblemsListener)iterator.next()).roundProblemsEvent();
                }
            }
        };
        this.eventService.invokeLater(runnable);
    }

    public RoomModel getRoomByCoder(String string) {
        RoomModel[] roomModelArray = this.getCoderRooms();
        Coder coder = null;
        for (int i = 0; i < roomModelArray.length; ++i) {
            coder = roomModelArray[i].getCoder(string);
            if (coder == null) continue;
            return roomModelArray[i];
        }
        if (this.getAdminRoom() != null && this.getAdminRoom().getCoder(string) != null) {
            return this.getAdminRoom();
        }
        throw new IllegalStateException("Cannot find room for " + string);
    }

    public synchronized boolean hasSchedule() {
        return this.schedule != null;
    }

    public synchronized PhaseData[] getSchedule() {
        return this.schedule;
    }

    synchronized void setSchedule(PhaseData[] phaseDataArray) {
        this.schedule = phaseDataArray;
    }

    public synchronized boolean isInChallengePhase() {
        return this.phase == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeaderListener(LeaderListener leaderListener) {
        if (leaderListener == null) {
            return;
        }
        Vector vector = this.leaderListeners;
        synchronized (vector) {
            if (!this.leaderListeners.contains(leaderListener)) {
                this.leaderListeners.add(leaderListener);
            }
        }
    }

    public void removeLeaderListener(LeaderListener leaderListener) {
        this.leaderListeners.remove(leaderListener);
    }

    private void notifyLeaderListeners(final RoomModelImpl roomModelImpl) {
        this.eventService.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LinkedList linkedList;
                Object object = RoundModelImpl.this.leaderListeners;
                synchronized (object) {
                    linkedList = new LinkedList(RoundModelImpl.this.leaderListeners);
                }
                object = linkedList.iterator();
                while (object.hasNext()) {
                    LeaderListener leaderListener = (LeaderListener)object.next();
                    if (leaderListener == null) continue;
                    leaderListener.updateLeader(roomModelImpl);
                }
            }
        });
    }

    void setContestName(String string) {
        this.contestName = string;
    }

    void setRoundName(String string) {
        this.roundName = string;
    }

    public RoundProperties getRoundProperties() {
        return this.roundProperties;
    }

    public RoundType getRoundType() {
        return this.roundTypeImpl;
    }

    public boolean canDisplaySummary() {
        return this.getRoundProperties().isSummaryEnabledDuringContest() || this.getPhase() != null & this.getPhase() >= 9;
    }

    public void setRoundCustomProperties(RoundCustomProperties roundCustomProperties) {
        this.roundProperties = new RoundProperties(this.roundTypeImpl, roundCustomProperties);
    }
}

