/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.impl.CoderComponentImpl;
import com.topcoder.client.contestant.impl.CoderImpl;
import com.topcoder.client.contestant.impl.ContestantImpl;
import com.topcoder.client.contestant.impl.ProblemComponentModelImpl;
import com.topcoder.client.contestant.impl.ProblemModelImpl;
import com.topcoder.client.contestant.impl.RoomModelImpl;
import com.topcoder.client.contestant.impl.RoundModelImpl;
import com.topcoder.client.contestant.message.ResponseProcessor;
import com.topcoder.client.contestant.view.ContestantView;
import com.topcoder.netCommon.contestantMessages.AdminBroadcast;
import com.topcoder.netCommon.contestantMessages.response.AssignComponentsResponse;
import com.topcoder.netCommon.contestantMessages.response.ChallengeInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.CoderHistoryResponse;
import com.topcoder.netCommon.contestantMessages.response.ComponentAssignmentDataResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateCategoryListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateChallengeTableResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateLeaderBoardResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateMenuResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateProblemsResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateRoomListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateRoundListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateTeamListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateUserListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateVisitedPracticeResponse;
import com.topcoder.netCommon.contestantMessages.response.EnableRoundResponse;
import com.topcoder.netCommon.contestantMessages.response.EnterRoomResponse;
import com.topcoder.netCommon.contestantMessages.response.ForcedLogoutResponse;
import com.topcoder.netCommon.contestantMessages.response.GetAdminBroadcastResponse;
import com.topcoder.netCommon.contestantMessages.response.GetCurrentAppletVersionResponse;
import com.topcoder.netCommon.contestantMessages.response.GetImportantMessagesResponse;
import com.topcoder.netCommon.contestantMessages.response.GetProblemResponse;
import com.topcoder.netCommon.contestantMessages.response.GetTeamProblemResponse;
import com.topcoder.netCommon.contestantMessages.response.ImportantMessageResponse;
import com.topcoder.netCommon.contestantMessages.response.LoginResponse;
import com.topcoder.netCommon.contestantMessages.response.LongTestResultsResponse;
import com.topcoder.netCommon.contestantMessages.response.NoBadgeIdResponse;
import com.topcoder.netCommon.contestantMessages.response.OpenComponentResponse;
import com.topcoder.netCommon.contestantMessages.response.PhaseDataResponse;
import com.topcoder.netCommon.contestantMessages.response.PopUpGenericResponse;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResponse;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResultResponse;
import com.topcoder.netCommon.contestantMessages.response.ReconnectResponse;
import com.topcoder.netCommon.contestantMessages.response.RegisteredUsersResponse;
import com.topcoder.netCommon.contestantMessages.response.RoomInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.RoundScheduleResponse;
import com.topcoder.netCommon.contestantMessages.response.RoundStatsResponse;
import com.topcoder.netCommon.contestantMessages.response.SingleBroadcastResponse;
import com.topcoder.netCommon.contestantMessages.response.SubmissionHistoryResponse;
import com.topcoder.netCommon.contestantMessages.response.SubmitResultsResponse;
import com.topcoder.netCommon.contestantMessages.response.SynchTimeResponse;
import com.topcoder.netCommon.contestantMessages.response.SystestProgressResponse;
import com.topcoder.netCommon.contestantMessages.response.TestInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateChatResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateCoderComponentResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateCoderPointsResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateLeaderBoardResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateMenuResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdatePreferencesResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateRoundListResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateTeamListResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateUserListResponse;
import com.topcoder.netCommon.contestantMessages.response.UserInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.VerifyResponse;
import com.topcoder.netCommon.contestantMessages.response.VerifyResultResponse;
import com.topcoder.netCommon.contestantMessages.response.VoteResponse;
import com.topcoder.netCommon.contestantMessages.response.VoteResultsResponse;
import com.topcoder.netCommon.contestantMessages.response.WLMyTeamInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.WLTeamsInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.WatchResponse;
import com.topcoder.netCommon.contestantMessages.response.data.LeaderboardItem;
import com.topcoder.netCommon.contestantMessages.response.data.PhaseData;
import com.topcoder.netCommon.contestantMessages.response.data.RoundData;
import com.topcoder.netCommon.contestantMessages.response.data.TeamListInfo;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import com.topcoder.shared.problem.Problem;
import com.topcoder.shared.problem.ProblemComponent;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Iterator;

final class ResponseProcessorImpl
implements ResponseProcessor {
    private final ContestantImpl model;
    private final ContestantView view;

    ResponseProcessorImpl(ContestantImpl contestantImpl) {
        this.model = contestantImpl;
        this.view = contestantImpl.getView();
    }

    private RoomModelImpl getRoomModel(long l) {
        return (RoomModelImpl)this.model.getRoom(l);
    }

    public void currentAppletVersion(GetCurrentAppletVersionResponse getCurrentAppletVersionResponse) {
        this.model.setCurrentAppletVersion(getCurrentAppletVersionResponse.getVersion());
    }

    public void reconnect(ReconnectResponse reconnectResponse) {
        if (reconnectResponse.getSuccess()) {
            this.model.setLoggedIn(reconnectResponse.getSuccess());
            this.model.setConnectionID(reconnectResponse.getConnectionID());
            this.model.setHashCode(reconnectResponse.getHashCode());
            Iterator iterator = this.model.getBroadcastManager().getBroadcasts().iterator();
            while (iterator.hasNext()) {
                AdminBroadcast adminBroadcast = (AdminBroadcast)iterator.next();
                if (this.model.getBroadcastManager().hasRead(adminBroadcast)) continue;
                this.model.getBroadcastManager().newBroadcast(adminBroadcast);
            }
            this.view.setConnectionStatus(true);
        } else {
            this.model.reconnectFailed();
            this.view.setConnectionStatus(true);
            this.view.reconnectFailedEvent();
        }
    }

    public void login(LoginResponse loginResponse) {
        this.model.setLoggedIn(loginResponse.getSuccess());
        if (loginResponse.getSuccess()) {
            this.view.setConnectionStatus(true);
            this.model.setConnectionID(loginResponse.getConnectionID());
            this.model.setHashCode(loginResponse.getHashCode());
        }
    }

    public void userInfo(UserInfoResponse userInfoResponse) {
        this.model.setUserInfo(userInfoResponse.getUserInfo());
    }

    public void updatePreferences(UpdatePreferencesResponse updatePreferencesResponse) {
    }

    public void createMenu(CreateMenuResponse createMenuResponse) {
        switch (createMenuResponse.getType()) {
            case 3: {
                ArrayList arrayList = createMenuResponse.getIDs();
                ArrayList arrayList2 = createMenuResponse.getNames();
                for (int i = 0; i < arrayList.size(); ++i) {
                    Integer n = (Integer)arrayList.get(i);
                    this.model.newLobby(new Long(n.intValue()));
                }
                this.model.getMenuView().createLobbyMenu(arrayList2, createMenuResponse.getStatii(), arrayList);
                break;
            }
            case 4: {
                this.model.getMenuView().createActiveChatMenu(createMenuResponse.getNames(), createMenuResponse.getStatii(), createMenuResponse.getIDs());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid menu type: " + createMenuResponse.getType());
            }
        }
    }

    public void updateMenu(UpdateMenuResponse updateMenuResponse) {
        switch (updateMenuResponse.getType()) {
            case 3: {
                this.model.getMenuView().modifyLobbyMenu(updateMenuResponse.getElement(), updateMenuResponse.getStatus());
                break;
            }
            case 4: {
                this.model.getMenuView().modifyActiveChatMenu(updateMenuResponse.getElement(), updateMenuResponse.getStatus());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid update menu type: " + updateMenuResponse.getType());
            }
        }
    }

    public void watch(WatchResponse watchResponse) {
    }

    public void createLeaderBoard(CreateLeaderBoardResponse createLeaderBoardResponse) {
        this.model.getRoundModel(createLeaderBoardResponse.getRoundID()).setLeaderboard(createLeaderBoardResponse.getItems());
        LeaderboardItem[] leaderboardItemArray = createLeaderBoardResponse.getItems();
        for (int i = 0; i < leaderboardItemArray.length; ++i) {
            LeaderboardItem leaderboardItem = leaderboardItemArray[i];
            RoomModelImpl roomModelImpl = this.getRoomModel(leaderboardItem.getRoomID());
            roomModelImpl.setLeader(leaderboardItem);
        }
    }

    public void updateLeaderBoard(UpdateLeaderBoardResponse updateLeaderBoardResponse) {
        LeaderboardItem leaderboardItem = updateLeaderBoardResponse.getItem();
        RoomModelImpl roomModelImpl = this.getRoomModel(leaderboardItem.getRoomID());
        roomModelImpl.setLeader(leaderboardItem);
        this.model.getRoundModel(updateLeaderBoardResponse.getRoundID()).updateLeaderboard(roomModelImpl, leaderboardItem);
    }

    public void popupGeneric(PopUpGenericResponse popUpGenericResponse) {
        int n = popUpGenericResponse.getType1();
        int n2 = popUpGenericResponse.getType2();
        String string = popUpGenericResponse.getMessage();
        String string2 = popUpGenericResponse.getTitle();
        if (n == 2) {
            this.view.popup(n2, string2, string);
        } else if (n == 4) {
            ArrayList arrayList = popUpGenericResponse.getButtons();
            arrayList.add(popUpGenericResponse.getSurveyQuestions());
            arrayList.add(popUpGenericResponse.getSurveyMessage());
            Object object = popUpGenericResponse.getMoveData();
            this.view.popup(n, n2, string2, string, arrayList, object);
        } else {
            ArrayList arrayList = popUpGenericResponse.getButtons();
            Object object = popUpGenericResponse.getMoveData();
            this.view.popup(n, n2, string2, string, arrayList, object);
        }
    }

    public void submitResponse(SubmitResultsResponse submitResultsResponse) {
        ArrayList<Constable> arrayList = new ArrayList<Constable>();
        arrayList.add(submitResultsResponse.getRoundID());
        arrayList.add(new Boolean(submitResultsResponse.getSystest()));
        this.view.popup(5, 0, "Submission Results", submitResultsResponse.getMessage(), arrayList, submitResultsResponse.getRoundID());
    }

    public void forceLogoff(ForcedLogoutResponse forcedLogoutResponse) {
        this.view.popup(1, forcedLogoutResponse.getTitle(), forcedLogoutResponse.getMessage());
        this.view.loggingOff();
        this.model.reset();
    }

    public void createUserList(CreateUserListResponse createUserListResponse) {
        RoomModelImpl roomModelImpl = this.getRoomModel(createUserListResponse.getRoomID());
        UserListItem[] userListItemArray = createUserListResponse.getUserListItems();
        if (roomModelImpl == null) {
            return;
        }
        int n = createUserListResponse.getType();
        switch (n) {
            case 0: {
                roomModelImpl.setUserList(userListItemArray);
                break;
            }
            case 2: {
                this.model.getActiveUsersView().updateUserList(userListItemArray);
                break;
            }
            case 4: {
                roomModelImpl.addToAvailableList(userListItemArray);
                break;
            }
            case 5: {
                roomModelImpl.addToMemberList(userListItemArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid user list type: " + n);
            }
        }
    }

    public void updateUserList(UpdateUserListResponse updateUserListResponse) {
        RoomModelImpl roomModelImpl = this.getRoomModel(updateUserListResponse.getRoomID());
        UserListItem userListItem = updateUserListResponse.getUserListItem();
        if (roomModelImpl == null) {
            return;
        }
        int n = updateUserListResponse.getType();
        int n2 = updateUserListResponse.getAction();
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    roomModelImpl.addToUserList(userListItem);
                    break;
                }
                if (n2 != 1) break;
                roomModelImpl.removeFromUserList(userListItem);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (n2 == 0) {
                    roomModelImpl.addToAvailableList(userListItem);
                    break;
                }
                if (n2 != 1) break;
                roomModelImpl.removeFromAvailableList(userListItem);
                break;
            }
            case 5: {
                if (n2 == 0) {
                    roomModelImpl.addToMemberList(userListItem);
                    break;
                }
                if (n2 != 1) break;
                roomModelImpl.removeFromMemberList(userListItem);
            }
        }
    }

    public void updateChat(UpdateChatResponse updateChatResponse) {
        RoomModelImpl roomModelImpl;
        if (updateChatResponse.getRoomID() == -1) {
            roomModelImpl = this.model.getCurrentRoomImpl();
            if (roomModelImpl == null) {
                throw new IllegalStateException("Global chat message received but no current room to direct it to: " + updateChatResponse);
            }
        } else {
            roomModelImpl = this.getRoomModel(updateChatResponse.getRoomID());
        }
        if (updateChatResponse.getType() == 0 || updateChatResponse.getType() == 5 || updateChatResponse.getType() == 4) {
            String string = updateChatResponse.getPrefix();
            roomModelImpl.updateChatRoom(string, updateChatResponse.getRating(), updateChatResponse.getData(), updateChatResponse.getScope());
        } else {
            String string = updateChatResponse.getData();
            roomModelImpl.updateChatRoom(updateChatResponse.getType(), string, updateChatResponse.getScope());
        }
    }

    public void getProblem(GetProblemResponse getProblemResponse) {
        RoundModelImpl roundModelImpl = this.model.getRoundModel(getProblemResponse.getRoundID());
        Problem problem = getProblemResponse.getProblem();
        ProblemModelImpl problemModelImpl = roundModelImpl.getProblemImpl(getProblemResponse.getDivisionID(), new Long(getProblemResponse.getProblem().getProblemId()));
        ProblemComponent[] problemComponentArray = problem.getProblemComponents();
        for (int i = 0; i < problemComponentArray.length; ++i) {
            ProblemComponent problemComponent = problemComponentArray[i];
            ProblemComponentModelImpl problemComponentModelImpl = roundModelImpl.getComponentImpl(getProblemResponse.getDivisionID(), new Long(problemComponent.getComponentId()));
            problemComponentModelImpl.setServerComponentObject(problemComponent);
        }
        problemModelImpl.setServerProblemObject(problem);
    }

    public void getTeamProblem(GetTeamProblemResponse getTeamProblemResponse) {
        RoundModelImpl roundModelImpl = this.model.getRoundModel(getTeamProblemResponse.getRoundID());
        Problem problem = getTeamProblemResponse.getProblem();
        ProblemModelImpl problemModelImpl = roundModelImpl.getProblemImpl(getTeamProblemResponse.getDivisionID(), new Long(getTeamProblemResponse.getProblem().getProblemId()));
        ProblemComponent[] problemComponentArray = problem.getProblemComponents();
        for (int i = 0; i < problemComponentArray.length; ++i) {
            ProblemComponent problemComponent = problemComponentArray[i];
            ProblemComponentModelImpl problemComponentModelImpl = roundModelImpl.getComponentImpl(getTeamProblemResponse.getDivisionID(), new Long(problemComponent.getComponentId()));
            problemComponentModelImpl.setServerComponentObject(problemComponent);
        }
        problemModelImpl.setReadOnlyServerProblemObject(problem);
    }

    public void testInfo(TestInfoResponse testInfoResponse) {
        this.model.getCurrentRoomImpl().updateTestInfo(testInfoResponse.getDataTypes(), testInfoResponse.getComponentID());
    }

    public void createProblems(CreateProblemsResponse createProblemsResponse) {
        RoundModelImpl roundModelImpl = this.model.getRoundModel(createProblemsResponse.getRoundID());
        roundModelImpl.setProblems(createProblemsResponse.getDivisionID(), createProblemsResponse.getAssignedComponents(), createProblemsResponse.getProblems());
    }

    public void assignComponents(AssignComponentsResponse assignComponentsResponse) {
        RoundModelImpl roundModelImpl = this.model.getRoundModel(assignComponentsResponse.getRoundID());
        roundModelImpl.setAssignedComponents(assignComponentsResponse.getDivisionID(), assignComponentsResponse.getAssignedComponents());
    }

    public void challengeInfo(ChallengeInfoResponse challengeInfoResponse) {
    }

    public void updateCoderComponent(UpdateCoderComponentResponse updateCoderComponentResponse) {
        RoomModelImpl roomModelImpl = this.getRoomModel(updateCoderComponentResponse.getRoomID());
        if (roomModelImpl == null) {
            return;
        }
        roomModelImpl.updateCoderComponent(updateCoderComponentResponse.getCoderHandle(), updateCoderComponentResponse.getComponent());
    }

    public void updateCoderPoints(UpdateCoderPointsResponse updateCoderPointsResponse) {
        RoomModelImpl roomModelImpl = this.getRoomModel(updateCoderPointsResponse.getRoomID());
        if (roomModelImpl == null) {
            return;
        }
        roomModelImpl.updateCoderPoints(updateCoderPointsResponse.getCoderHandle(), updateCoderPointsResponse.getPoints());
    }

    public void createChallengeTable(CreateChallengeTableResponse createChallengeTableResponse) {
        RoomModelImpl roomModelImpl = this.getRoomModel(createChallengeTableResponse.getRoomID());
        roomModelImpl.updateChallengeTable(createChallengeTableResponse.getCoders());
    }

    public void roomType(RoomInfoResponse roomInfoResponse) {
        this.model.roomInfo(roomInfoResponse.getRoomType(), roomInfoResponse.getRoomID(), roomInfoResponse.getName(), roomInfoResponse.getStatus());
    }

    public void singleBroadcast(SingleBroadcastResponse singleBroadcastResponse) {
        this.model.getBroadcastManager().newBroadcast(singleBroadcastResponse.getBroadcast());
    }

    public void getAdminBroadcast(GetAdminBroadcastResponse getAdminBroadcastResponse) {
        this.model.getBroadcastManager().refresh(getAdminBroadcastResponse.getBroadcasts());
    }

    public void systestProgress(SystestProgressResponse systestProgressResponse) {
        this.model.getRoundModel(systestProgressResponse.getRoundID()).updateSystestProgress(systestProgressResponse.getDone(), systestProgressResponse.getTotal());
    }

    public void updateTeamList(UpdateTeamListResponse updateTeamListResponse) {
        this.model.getTeamListView().updateTeamList(updateTeamListResponse.getTeamListInfo());
    }

    public void createTeamList(CreateTeamListResponse createTeamListResponse) {
        TeamListInfo[] teamListInfoArray = createTeamListResponse.getTeamListInfo();
        for (int i = 0; i < teamListInfoArray.length; ++i) {
            this.model.getTeamListView().updateTeamList(teamListInfoArray[i]);
        }
    }

    public void createRoundList(CreateRoundListResponse createRoundListResponse) {
        RoundData[] roundDataArray = createRoundListResponse.getRoundData();
        if (createRoundListResponse.getType() == 1) {
            this.model.setPracticeRounds(roundDataArray);
        } else if (createRoundListResponse.getType() == 2) {
            this.model.setActiveRounds(roundDataArray);
        } else {
            throw new IllegalArgumentException("Bad type: " + createRoundListResponse);
        }
    }

    public void createCategoryList(CreateCategoryListResponse createCategoryListResponse) {
        this.model.setRoundCategories(createCategoryListResponse.getCategories());
    }

    public void createRoomList(CreateRoomListResponse createRoomListResponse) {
        if (createRoomListResponse.hasAdminRoom()) {
            this.model.newAdminRoom(createRoomListResponse.getRoundID(), createRoomListResponse.getAdminRoom());
        }
        this.model.newCoderRooms(createRoomListResponse.getRoundID(), createRoomListResponse.getCoderRooms());
    }

    public void enableRound(EnableRoundResponse enableRoundResponse) {
        this.model.getRoundModel(enableRoundResponse.getRoundID()).setMenuStatus(true);
    }

    public void registeredUsers(RegisteredUsersResponse registeredUsersResponse) {
        if (registeredUsersResponse.isHighSchool()) {
            this.model.getHSRegisteredUsersView().updateUserList(registeredUsersResponse.getUserListItems());
        } else if (this.model.getRoundModel(registeredUsersResponse.getRoundID()).getRoundType().isLongRound()) {
            this.model.getLongRoundRegisteredUsersView().updateUserList(registeredUsersResponse.getUserListItems());
        } else {
            this.model.getRegisteredUsersView().updateUserList(registeredUsersResponse.getUserListItems());
        }
    }

    public void updateRoundList(UpdateRoundListResponse updateRoundListResponse) {
        switch (updateRoundListResponse.getAction()) {
            case 1: {
                this.model.newRound(updateRoundListResponse.getRoundData());
                break;
            }
            case 2: {
                this.model.removeRound(updateRoundListResponse.getRoundData());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad action: " + updateRoundListResponse.getAction());
            }
        }
    }

    public void enterRoom(EnterRoomResponse enterRoomResponse) {
    }

    public void phaseData(PhaseDataResponse phaseDataResponse) {
        PhaseData phaseData = phaseDataResponse.getPhaseData();
        RoundModelImpl roundModelImpl = this.model.getRoundModel(phaseData.getRoundID());
        roundModelImpl.setPhase(phaseData.getPhaseType(), phaseData.getEndTime());
    }

    public void synchTime(SynchTimeResponse synchTimeResponse) {
        this.model.updateServerTime(synchTimeResponse.getTime());
    }

    public void openComponent(OpenComponentResponse openComponentResponse) {
        RoomModelImpl roomModelImpl = this.getRoomModel(openComponentResponse.getRoomID());
        CoderImpl coderImpl = roomModelImpl.getCoderImpl(openComponentResponse.getWriterHandle());
        CoderComponentImpl coderComponentImpl = coderImpl.getCoderComponent(new Long(openComponentResponse.getComponentID()));
        String string = openComponentResponse.getCode();
        coderComponentImpl.setSourceCode(openComponentResponse.getLanguageID(), string);
    }

    public void roundSchedule(RoundScheduleResponse roundScheduleResponse) {
        RoundModelImpl roundModelImpl = this.model.getRoundModel(roundScheduleResponse.getRoundID());
        roundModelImpl.setSchedule(roundScheduleResponse.getSchedule());
    }

    public void vote(VoteResponse voteResponse) {
        this.view.vote(voteResponse);
    }

    public void voteResults(VoteResultsResponse voteResultsResponse) {
        this.view.voteResults(voteResultsResponse);
    }

    public void roundStatsResponse(RoundStatsResponse roundStatsResponse) {
        this.view.roundStatsResponse(roundStatsResponse);
    }

    public void noBadgeId(NoBadgeIdResponse noBadgeIdResponse) {
        this.view.noBadgeId(noBadgeIdResponse);
    }

    public void wlMyTeamInfoResponse(WLMyTeamInfoResponse wLMyTeamInfoResponse) {
        this.view.wlMyTeamInfoResponse(wLMyTeamInfoResponse);
    }

    public void wlTeamsInfoResponse(WLTeamsInfoResponse wLTeamsInfoResponse) {
        this.view.wlTeamsInfoResponse(wLTeamsInfoResponse);
    }

    public void updateAssignedComponents(ComponentAssignmentDataResponse componentAssignmentDataResponse) {
        this.model.setComponentAssignmentData(componentAssignmentDataResponse.getData());
    }

    public void importantMessage(ImportantMessageResponse importantMessageResponse) {
        this.view.importantMessage(importantMessageResponse);
    }

    public void getImportantMessages(GetImportantMessagesResponse getImportantMessagesResponse) {
        this.view.importantMessageSummry(getImportantMessagesResponse);
    }

    public void visitedPracticeList(CreateVisitedPracticeResponse createVisitedPracticeResponse) {
        this.view.visitedPracticeList(createVisitedPracticeResponse);
    }

    public void practiceSystemTestResult(PracticeSystemTestResultResponse practiceSystemTestResultResponse) {
        this.view.practiceSystestResult(practiceSystemTestResultResponse);
    }

    public void practiceSystemTestResponse(PracticeSystemTestResponse practiceSystemTestResponse) {
        this.view.startPracticeSystest(practiceSystemTestResponse);
    }

    public void verifyResponse(VerifyResponse verifyResponse) {
        this.model.setVerifyCode(verifyResponse.getVerifyCode());
    }

    public void verifyResult(VerifyResultResponse verifyResultResponse) {
        this.model.setVerifyResult(verifyResultResponse.getSuccess());
    }

    public void submissionHistory(SubmissionHistoryResponse submissionHistoryResponse) {
        this.view.showSubmissionHistory(submissionHistoryResponse);
    }

    public void longTestResults(LongTestResultsResponse longTestResultsResponse) {
        this.view.showLongTestResults(longTestResultsResponse);
    }

    public void coderHistory(CoderHistoryResponse coderHistoryResponse) {
        this.view.showCoderHistory(coderHistoryResponse);
    }
}

