/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.InterceptorManager;
import com.topcoder.client.contestant.message.MessageProcessor;
import com.topcoder.client.contestant.message.ResponseProcessor;
import com.topcoder.client.contestant.view.ContestantView;
import com.topcoder.client.netClient.Client;
import com.topcoder.netCommon.contestantMessages.response.AssignComponentsResponse;
import com.topcoder.netCommon.contestantMessages.response.BaseResponse;
import com.topcoder.netCommon.contestantMessages.response.ChallengeInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.CoderHistoryResponse;
import com.topcoder.netCommon.contestantMessages.response.ComponentAssignmentDataResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateCategoryListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateChallengeTableResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateLeaderBoardResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateMenuResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateProblemsResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateRoomListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateRoundListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateTeamListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateUserListResponse;
import com.topcoder.netCommon.contestantMessages.response.CreateVisitedPracticeResponse;
import com.topcoder.netCommon.contestantMessages.response.EnableRoundResponse;
import com.topcoder.netCommon.contestantMessages.response.EnterRoomResponse;
import com.topcoder.netCommon.contestantMessages.response.ForcedLogoutResponse;
import com.topcoder.netCommon.contestantMessages.response.GetAdminBroadcastResponse;
import com.topcoder.netCommon.contestantMessages.response.GetCurrentAppletVersionResponse;
import com.topcoder.netCommon.contestantMessages.response.GetImportantMessagesResponse;
import com.topcoder.netCommon.contestantMessages.response.GetProblemResponse;
import com.topcoder.netCommon.contestantMessages.response.GetTeamProblemResponse;
import com.topcoder.netCommon.contestantMessages.response.ImportantMessageResponse;
import com.topcoder.netCommon.contestantMessages.response.KeepAliveResponse;
import com.topcoder.netCommon.contestantMessages.response.LoginResponse;
import com.topcoder.netCommon.contestantMessages.response.LongTestResultsResponse;
import com.topcoder.netCommon.contestantMessages.response.NoBadgeIdResponse;
import com.topcoder.netCommon.contestantMessages.response.OpenComponentResponse;
import com.topcoder.netCommon.contestantMessages.response.PhaseDataResponse;
import com.topcoder.netCommon.contestantMessages.response.PopUpGenericResponse;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResponse;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResultResponse;
import com.topcoder.netCommon.contestantMessages.response.ReconnectResponse;
import com.topcoder.netCommon.contestantMessages.response.RegisteredUsersResponse;
import com.topcoder.netCommon.contestantMessages.response.RoomInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.RoundScheduleResponse;
import com.topcoder.netCommon.contestantMessages.response.RoundStatsResponse;
import com.topcoder.netCommon.contestantMessages.response.SingleBroadcastResponse;
import com.topcoder.netCommon.contestantMessages.response.SubmissionHistoryResponse;
import com.topcoder.netCommon.contestantMessages.response.SubmitResultsResponse;
import com.topcoder.netCommon.contestantMessages.response.SynchTimeResponse;
import com.topcoder.netCommon.contestantMessages.response.SystestProgressResponse;
import com.topcoder.netCommon.contestantMessages.response.TestInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateChatResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateCoderComponentResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateCoderPointsResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateLeaderBoardResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateMenuResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdatePreferencesResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateRoundListResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateTeamListResponse;
import com.topcoder.netCommon.contestantMessages.response.UpdateUserListResponse;
import com.topcoder.netCommon.contestantMessages.response.UserInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.VerifyResponse;
import com.topcoder.netCommon.contestantMessages.response.VerifyResultResponse;
import com.topcoder.netCommon.contestantMessages.response.VoteResponse;
import com.topcoder.netCommon.contestantMessages.response.VoteResultsResponse;
import com.topcoder.netCommon.contestantMessages.response.WLMyTeamInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.WLTeamsInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.WatchResponse;
import java.io.IOException;

class MessageProcessorImpl
implements MessageProcessor {
    private Client client = null;
    private String host = null;
    private String tunnel = null;
    private int port;
    private ContestantView view;
    private ResponseProcessor responseProcessor;
    private String destinationHost = null;
    private InterceptorManager interceptorManager;

    MessageProcessorImpl(String string, int n, String string2, ContestantView contestantView, ResponseProcessor responseProcessor, String string3, InterceptorManager interceptorManager) {
        this.host = string;
        this.port = n;
        this.view = contestantView;
        this.tunnel = string2;
        this.responseProcessor = responseProcessor;
        this.destinationHost = string3;
        this.interceptorManager = interceptorManager;
    }

    public boolean openConnection(boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (this.client == null) {
            try {
                this.client = bl2 ? new Client(this.host, this.port, this.destinationHost) : (bl ? new Client(this.tunnel) : new Client(this.host, this.port));
                this.client.getContestResponseHandler(this);
            }
            catch (IOException iOException) {
                System.out.println("FAILED TO ESTABLISH A CONNECTION TO THE SOCKET SERVER");
                bl3 = false;
            }
        }
        return bl3;
    }

    public void lostConnection() {
        this.closeConnection();
        this.view.lostConnectionEvent();
    }

    public void closeConnection() {
        this.view.closingConnectionEvent();
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public Client getClient() {
        return this.client;
    }

    public void receive(BaseResponse baseResponse) {
        if (this.interceptorManager != null && this.interceptorManager.receiveMessage(baseResponse)) {
            return;
        }
        if (baseResponse instanceof LoginResponse) {
            this.responseProcessor.login((LoginResponse)baseResponse);
        } else if (baseResponse instanceof GetCurrentAppletVersionResponse) {
            this.responseProcessor.currentAppletVersion((GetCurrentAppletVersionResponse)baseResponse);
        } else if (baseResponse instanceof ReconnectResponse) {
            this.responseProcessor.reconnect((ReconnectResponse)baseResponse);
        } else if (baseResponse instanceof CreateMenuResponse) {
            this.responseProcessor.createMenu((CreateMenuResponse)baseResponse);
        } else if (baseResponse instanceof UpdateMenuResponse) {
            this.responseProcessor.updateMenu((UpdateMenuResponse)baseResponse);
        } else if (baseResponse instanceof CreateLeaderBoardResponse) {
            this.responseProcessor.createLeaderBoard((CreateLeaderBoardResponse)baseResponse);
        } else if (baseResponse instanceof UpdateLeaderBoardResponse) {
            this.responseProcessor.updateLeaderBoard((UpdateLeaderBoardResponse)baseResponse);
        } else if (baseResponse instanceof UpdatePreferencesResponse) {
            this.responseProcessor.updatePreferences((UpdatePreferencesResponse)baseResponse);
        } else if (baseResponse instanceof CreateUserListResponse) {
            this.responseProcessor.createUserList((CreateUserListResponse)baseResponse);
        } else if (baseResponse instanceof UpdateUserListResponse) {
            this.responseProcessor.updateUserList((UpdateUserListResponse)baseResponse);
        } else if (baseResponse instanceof PopUpGenericResponse) {
            this.responseProcessor.popupGeneric((PopUpGenericResponse)baseResponse);
        } else if (baseResponse instanceof SubmitResultsResponse) {
            this.responseProcessor.submitResponse((SubmitResultsResponse)baseResponse);
        } else if (baseResponse instanceof ForcedLogoutResponse) {
            this.responseProcessor.forceLogoff((ForcedLogoutResponse)baseResponse);
        } else if (baseResponse instanceof CreateChallengeTableResponse) {
            this.responseProcessor.createChallengeTable((CreateChallengeTableResponse)baseResponse);
        } else if (baseResponse instanceof UpdateCoderComponentResponse) {
            this.responseProcessor.updateCoderComponent((UpdateCoderComponentResponse)baseResponse);
        } else if (baseResponse instanceof UpdateCoderPointsResponse) {
            this.responseProcessor.updateCoderPoints((UpdateCoderPointsResponse)baseResponse);
        } else if (baseResponse instanceof UpdateChatResponse) {
            this.responseProcessor.updateChat((UpdateChatResponse)baseResponse);
        } else if (baseResponse instanceof GetProblemResponse) {
            this.responseProcessor.getProblem((GetProblemResponse)baseResponse);
        } else if (baseResponse instanceof GetTeamProblemResponse) {
            this.responseProcessor.getTeamProblem((GetTeamProblemResponse)baseResponse);
        } else if (baseResponse instanceof TestInfoResponse) {
            this.responseProcessor.testInfo((TestInfoResponse)baseResponse);
        } else if (baseResponse instanceof ChallengeInfoResponse) {
            this.responseProcessor.challengeInfo((ChallengeInfoResponse)baseResponse);
        } else if (baseResponse instanceof RoomInfoResponse) {
            this.responseProcessor.roomType((RoomInfoResponse)baseResponse);
        } else if (baseResponse instanceof CreateProblemsResponse) {
            this.responseProcessor.createProblems((CreateProblemsResponse)baseResponse);
        } else if (baseResponse instanceof AssignComponentsResponse) {
            this.responseProcessor.assignComponents((AssignComponentsResponse)baseResponse);
        } else if (baseResponse instanceof GetAdminBroadcastResponse) {
            this.responseProcessor.getAdminBroadcast((GetAdminBroadcastResponse)baseResponse);
        } else if (baseResponse instanceof SingleBroadcastResponse) {
            this.responseProcessor.singleBroadcast((SingleBroadcastResponse)baseResponse);
        } else if (baseResponse instanceof UserInfoResponse) {
            this.responseProcessor.userInfo((UserInfoResponse)baseResponse);
        } else if (baseResponse instanceof WatchResponse) {
            this.responseProcessor.watch((WatchResponse)baseResponse);
        } else if (baseResponse instanceof ComponentAssignmentDataResponse) {
            this.responseProcessor.updateAssignedComponents((ComponentAssignmentDataResponse)baseResponse);
        } else if (!(baseResponse instanceof KeepAliveResponse)) {
            if (baseResponse instanceof SystestProgressResponse) {
                this.responseProcessor.systestProgress((SystestProgressResponse)baseResponse);
            } else if (baseResponse instanceof UpdateTeamListResponse) {
                this.responseProcessor.updateTeamList((UpdateTeamListResponse)baseResponse);
            } else if (baseResponse instanceof CreateTeamListResponse) {
                this.responseProcessor.createTeamList((CreateTeamListResponse)baseResponse);
            } else if (baseResponse instanceof CreateRoundListResponse) {
                this.responseProcessor.createRoundList((CreateRoundListResponse)baseResponse);
            } else if (baseResponse instanceof CreateCategoryListResponse) {
                this.responseProcessor.createCategoryList((CreateCategoryListResponse)baseResponse);
            } else if (baseResponse instanceof EnableRoundResponse) {
                this.responseProcessor.enableRound((EnableRoundResponse)baseResponse);
            } else if (baseResponse instanceof CreateRoomListResponse) {
                this.responseProcessor.createRoomList((CreateRoomListResponse)baseResponse);
            } else if (baseResponse instanceof UpdateRoundListResponse) {
                this.responseProcessor.updateRoundList((UpdateRoundListResponse)baseResponse);
            } else if (baseResponse instanceof EnterRoomResponse) {
                this.responseProcessor.enterRoom((EnterRoomResponse)baseResponse);
            } else if (baseResponse instanceof PhaseDataResponse) {
                this.responseProcessor.phaseData((PhaseDataResponse)baseResponse);
            } else if (baseResponse instanceof SynchTimeResponse) {
                this.responseProcessor.synchTime((SynchTimeResponse)baseResponse);
            } else if (baseResponse instanceof OpenComponentResponse) {
                this.responseProcessor.openComponent((OpenComponentResponse)baseResponse);
            } else if (baseResponse instanceof RegisteredUsersResponse) {
                this.responseProcessor.registeredUsers((RegisteredUsersResponse)baseResponse);
            } else if (baseResponse instanceof RoundScheduleResponse) {
                this.responseProcessor.roundSchedule((RoundScheduleResponse)baseResponse);
            } else if (baseResponse instanceof VoteResponse) {
                this.responseProcessor.vote((VoteResponse)baseResponse);
            } else if (baseResponse instanceof VoteResultsResponse) {
                this.responseProcessor.voteResults((VoteResultsResponse)baseResponse);
            } else if (baseResponse instanceof RoundStatsResponse) {
                this.responseProcessor.roundStatsResponse((RoundStatsResponse)baseResponse);
            } else if (baseResponse instanceof NoBadgeIdResponse) {
                this.responseProcessor.noBadgeId((NoBadgeIdResponse)baseResponse);
            } else if (baseResponse instanceof WLMyTeamInfoResponse) {
                this.responseProcessor.wlMyTeamInfoResponse((WLMyTeamInfoResponse)baseResponse);
            } else if (baseResponse instanceof WLTeamsInfoResponse) {
                this.responseProcessor.wlTeamsInfoResponse((WLTeamsInfoResponse)baseResponse);
            } else if (baseResponse instanceof ImportantMessageResponse) {
                this.responseProcessor.importantMessage((ImportantMessageResponse)baseResponse);
            } else if (baseResponse instanceof GetImportantMessagesResponse) {
                this.responseProcessor.getImportantMessages((GetImportantMessagesResponse)baseResponse);
            } else if (baseResponse instanceof CreateVisitedPracticeResponse) {
                this.responseProcessor.visitedPracticeList((CreateVisitedPracticeResponse)baseResponse);
            } else if (baseResponse instanceof PracticeSystemTestResultResponse) {
                this.responseProcessor.practiceSystemTestResult((PracticeSystemTestResultResponse)baseResponse);
            } else if (baseResponse instanceof PracticeSystemTestResponse) {
                this.responseProcessor.practiceSystemTestResponse((PracticeSystemTestResponse)baseResponse);
            } else if (baseResponse instanceof VerifyResponse) {
                this.responseProcessor.verifyResponse((VerifyResponse)baseResponse);
            } else if (baseResponse instanceof VerifyResultResponse) {
                this.responseProcessor.verifyResult((VerifyResultResponse)baseResponse);
            } else if (baseResponse instanceof SubmissionHistoryResponse) {
                this.responseProcessor.submissionHistory((SubmissionHistoryResponse)baseResponse);
            } else if (baseResponse instanceof LongTestResultsResponse) {
                this.responseProcessor.longTestResults((LongTestResultsResponse)baseResponse);
            } else if (baseResponse instanceof CoderHistoryResponse) {
                this.responseProcessor.coderHistory((CoderHistoryResponse)baseResponse);
            } else {
                System.err.println("MessageProcessorImpl, Unrecognized response: " + baseResponse);
            }
        }
    }
}

