/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.impl.CoderComponentImpl;
import com.topcoder.client.contestant.impl.LongCoderComponentImpl;
import com.topcoder.netCommon.contestantMessages.response.data.CoderComponentItem;
import com.topcoder.netCommon.contestantMessages.response.data.LongCoderComponentItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

class CoderImpl
implements Coder {
    private String handle;
    private Integer rating;
    private CoderComponentImpl[] components;
    private Double score;
    private Double finalScore;
    private int userType;
    private ArrayList memberNames = null;
    private List listeners = new LinkedList();

    CoderImpl(String string, int n, double d, int n2, ArrayList arrayList) {
        this.handle = string;
        this.rating = new Integer(n);
        this.score = new Double(d);
        this.userType = n2;
        this.memberNames = arrayList;
    }

    public ArrayList getMemberNames() {
        return this.memberNames;
    }

    public synchronized void addListener(Coder.Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private synchronized void notifyListeners() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            Coder.Listener listener = (Coder.Listener)this.listeners.get(i);
            listener.coderEvent(this);
        }
    }

    public Integer getRating() {
        return this.rating;
    }

    public String getHandle() {
        return this.handle;
    }

    public synchronized CoderComponent[] getComponents() {
        return this.components;
    }

    public CoderComponent getComponent(Long l) {
        return this.getCoderComponent(l);
    }

    synchronized CoderComponentImpl getCoderComponent(Long l) {
        for (int i = 0; i < this.components.length; ++i) {
            CoderComponentImpl coderComponentImpl = this.components[i];
            if (!coderComponentImpl.getComponent().getID().equals(l)) continue;
            return coderComponentImpl;
        }
        throw new IllegalArgumentException("Bad component ID #" + l);
    }

    synchronized void setComponents(CoderComponentImpl[] coderComponentImplArray) {
        this.components = coderComponentImplArray;
        Arrays.sort(coderComponentImplArray, new Comparator(){

            public int compare(Object object, Object object2) {
                CoderComponentImpl coderComponentImpl = (CoderComponentImpl)object;
                CoderComponentImpl coderComponentImpl2 = (CoderComponentImpl)object2;
                return coderComponentImpl.getComponent().getPoints().compareTo(coderComponentImpl2.getComponent().getPoints());
            }
        });
        this.notifyListeners();
    }

    void updateComponent(CoderComponentItem coderComponentItem) {
        for (int i = 0; i < this.components.length; ++i) {
            CoderComponentImpl coderComponentImpl = this.components[i];
            if (!coderComponentImpl.getComponent().getID().equals(coderComponentItem.getComponentID())) continue;
            coderComponentImpl.setPoints(coderComponentItem.getPoints());
            coderComponentImpl.setStatus(coderComponentItem.getStatus());
            coderComponentImpl.setLanguage(coderComponentItem.getLanguage());
            coderComponentImpl.setPassedSystemTests(coderComponentItem.getPassedSystemTest());
            this.updateLongComponentIfNeeded(coderComponentImpl, coderComponentItem);
            this.notifyListeners();
            return;
        }
        throw new IllegalArgumentException("Couldn't find matching component: " + coderComponentItem);
    }

    void updateComponentFromTable(CoderComponentItem coderComponentItem) {
        for (int i = 0; i < this.components.length; ++i) {
            CoderComponentImpl coderComponentImpl = this.components[i];
            if (!coderComponentImpl.getComponent().getID().equals(coderComponentItem.getComponentID())) continue;
            coderComponentImpl.setPoints(coderComponentItem.getPoints());
            coderComponentImpl.setStatus(coderComponentItem.getStatus());
            coderComponentImpl.setLanguage(coderComponentItem.getLanguage());
            coderComponentImpl.setPassedSystemTests(coderComponentItem.getPassedSystemTest());
            this.updateLongComponentIfNeeded(coderComponentImpl, coderComponentItem);
            return;
        }
        throw new IllegalArgumentException("Couldn't find matching component: " + coderComponentItem);
    }

    private void updateLongComponentIfNeeded(CoderComponentImpl coderComponentImpl, CoderComponentItem coderComponentItem) {
        if (coderComponentItem instanceof LongCoderComponentItem) {
            LongCoderComponentItem longCoderComponentItem = (LongCoderComponentItem)coderComponentItem;
            LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coderComponentImpl;
            longCoderComponentImpl.setExampleLastLanguage(longCoderComponentItem.getExampleLastLanguage());
            longCoderComponentImpl.setExampleLastSubmissionTime(longCoderComponentItem.getExampleLastSubmissionTime());
            longCoderComponentImpl.setExampleSubmissionCount(longCoderComponentItem.getExampleSubmissionCount());
            longCoderComponentImpl.setLastSubmissionTime(longCoderComponentItem.getLastSubmissionTime());
            longCoderComponentImpl.setSubmissionCount(longCoderComponentItem.getSubmissionCount());
        }
    }

    public Double getScore() {
        return this.score;
    }

    void setScore(double d) {
        this.score = new Double(d);
        this.notifyListeners();
    }

    void setScoreFromTable(double d) {
        this.score = new Double(d);
    }

    public int getUserType() {
        return this.userType;
    }

    public Double getFinalScore() {
        return this.finalScore;
    }

    public void setFinalScore(Double d) {
        this.finalScore = d;
    }
}

