/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.widgets.ui;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.widgets.SortedComboBoxModel;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIComponentException;
import com.topcoder.client.ui.impl.component.UIPanel;
import com.topcoder.netCommon.contest.ComponentAssignmentData;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class UIUserAssignmentContentPanel
extends UIPanel {
    private JPanel panel;
    private ComponentAssignmentData cad;
    private UIComponent labelTemplate;
    private UIComponent comboTemplate;
    private RoomModel room;
    private ArrayList problemSet = null;
    private String[] problems = null;
    private String[][] components = null;
    private String[] headers = null;
    private ArrayList users;
    private SortedComboBoxModel[][] userModel = null;
    private JComboBox[][] combos = null;

    protected void initialize() throws UIComponentException {
        super.initialize();
        this.panel = (JPanel)this.getEventSource();
    }

    protected void setPropertyImpl(String string, Object object) throws UIComponentException {
        if ("ComponentAssignmentData".equalsIgnoreCase(string)) {
            this.cad = (ComponentAssignmentData)object;
            if (this.cad != null && this.room != null) {
                this.createPanel();
            }
        } else if ("RoomModel".equalsIgnoreCase(string)) {
            this.room = (RoomModel)object;
            if (this.cad != null && this.room != null) {
                this.createPanel();
            }
        } else if ("LabelTemplate".equalsIgnoreCase(string)) {
            this.labelTemplate = (UIComponent)object;
        } else if ("ComboBoxTemplate".equalsIgnoreCase(string)) {
            this.comboTemplate = this.comboTemplate;
        } else {
            super.setPropertyImpl(string, object);
        }
    }

    protected Object getPropertyImpl(String string) throws UIComponentException {
        if ("ComponentAssignmentData".equalsIgnoreCase(string)) {
            this.build();
            return this.cad;
        }
        if ("RoomModel".equalsIgnoreCase(string)) {
            return this.room;
        }
        return super.getPropertyImpl(string);
    }

    private void build() {
        if (this.room == null || this.cad == null) {
            throw new UIComponentException("The necessary runtime information is not available.");
        }
        RoundModel roundModel = this.room.getRoundModel();
        this.cad = new ComponentAssignmentData(this.cad.getTeamID(), this.cad.getRoundID());
        ProblemModel[] problemModelArray = roundModel.getProblems(this.room.getDivisionID());
        for (int i = 0; i < this.components.length; ++i) {
            for (int j = 0; j < this.components[i].length; ++j) {
                if (!(this.combos[i][j].getSelectedItem() instanceof UserListItem)) continue;
                this.cad.assignComponent((int)problemModelArray[i].getComponents()[j].getID().longValue(), ((UserListItem)this.combos[i][j].getSelectedItem()).getUserID());
            }
        }
    }

    private void createPanel() {
        this.createProblems();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ProblemModel[] problemModelArray = this.room.getRoundModel().getProblems(this.room.getDivisionID());
        this.combos = new JComboBox[this.problems.length][this.headers.length - 1];
        this.userModel = new SortedComboBoxModel[this.problems.length][this.headers.length - 1];
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof UserListItem) {
                    object = ((UserListItem)object).getUserName();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        };
        int n = 0;
        for (int i = 0; i < this.problems.length; ++i) {
            int n2 = 0;
            JLabel jLabel = (JLabel)this.labelTemplate.performAction("clone");
            jLabel.setText(this.problems[i] + ":");
            gridBagConstraints.anchor = 10;
            Common.insertInPanel(jLabel, this.panel, gridBagConstraints, 0, n, 1, 1, 1.0, 0.0);
            Common.insertInPanel(new JLabel(" "), this.panel, gridBagConstraints, 0, n + 1, 1, 1, 0.0, 0.0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            for (n2 = 0; n2 < ((ProblemModel)this.problemSet.get(i)).getComponents().length; ++n2) {
                jLabel = (JLabel)this.labelTemplate.performAction("clone");
                jLabel.setText(this.components[i][n2]);
                Common.insertInPanel(jLabel, this.panel, gridBagConstraints, n2 + 1, n, 1, 1, 0.0, 1.0);
                this.combos[i][n2] = (JComboBox)this.comboTemplate.performAction("clone");
                this.combos[i][n2].setRenderer(defaultListCellRenderer);
                int n3 = 0;
                for (int j = 0; j < this.users.size(); ++j) {
                    this.combos[i][n2].addItem(this.users.get(j));
                    if (this.cad.getAssignedUserForComponent((int)problemModelArray[i].getComponents()[n2].getID().longValue()) != ((UserListItem)this.users.get(j)).getUserID()) continue;
                    n3 = j;
                }
                if (this.users.size() > 0) {
                    this.combos[i][n2].setSelectedIndex(n3);
                }
                this.combos[i][n2].setUI(this.combos[i][n2].getUI());
                Common.insertInPanel(this.combos[i][n2], this.panel, gridBagConstraints, n2 + 1, n + 1, 1, 1, 1.0, 1.0);
            }
            while (n2 < this.headers.length - 1) {
                this.combos[i][n2] = null;
                this.userModel[i][n2] = null;
                Common.insertInPanel(new JLabel(""), this.panel, gridBagConstraints, n2 + 1, n, 1, 1, 1.0, 0.0);
                Common.insertInPanel(new JLabel(""), this.panel, gridBagConstraints, n2 + 1, n + 1, 1, 1, 1.0, 0.0);
                ++n2;
            }
            n += 2;
        }
    }

    private void createProblems() {
        int n;
        if (!this.room.hasRoundModel()) {
            throw new IllegalStateException("Can't build assignment panel, no round for room: " + this.room);
        }
        RoundModel roundModel = this.room.getRoundModel();
        if (!roundModel.hasProblems(this.room.getDivisionID())) {
            throw new IllegalStateException("Can't build assignment panel, no problems for round: " + roundModel);
        }
        ProblemModel[] problemModelArray = roundModel.getProblems(this.room.getDivisionID());
        ArrayList<ProblemModel> arrayList = new ArrayList<ProblemModel>();
        int n2 = 0;
        for (n = 0; n < problemModelArray.length; ++n) {
            arrayList.add(problemModelArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (n2 >= ((ProblemModel)arrayList.get(n)).getComponents().length) continue;
            n2 = ((ProblemModel)arrayList.get(n)).getComponents().length;
        }
        this.headers = new String[n2 + 1];
        this.headers[0] = "Problem";
        for (n = 0; n < n2; ++n) {
            this.headers[n + 1] = "Component " + (n + 1);
        }
        this.problems = new String[arrayList.size()];
        this.components = new String[arrayList.size()][];
        for (n = 0; n < arrayList.size(); ++n) {
            this.problems[n] = ((ProblemModel)arrayList.get(n)).getName();
            this.components[n] = new String[((ProblemModel)arrayList.get(n)).getComponents().length];
            for (int i = 0; i < this.components[n].length; ++i) {
                this.components[n][i] = ((ProblemModel)arrayList.get(n)).getComponents()[i].getClassName();
            }
        }
        this.problemSet = arrayList;
        this.users = new ArrayList();
        for (n = 0; n < this.cad.getTeamMembers().size(); ++n) {
            this.users.add(this.cad.getTeamMembers().get(n));
        }
    }
}

