/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.widgets;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ResultDisplayTypeSelectionPanel
extends JPanel {
    private ButtonGroup viewGroup;
    private Set resultDisplayTypes;
    private Listener listener;

    public ResultDisplayTypeSelectionPanel(RoundModel roundModel, Listener listener) {
        super(new FlowLayout(0));
        this.setOpaque(false);
        this.listener = listener;
        this.init(roundModel);
    }

    private void init(RoundModel roundModel) {
        this.resultDisplayTypes = new HashSet<ResultDisplayType>(Arrays.asList(roundModel.getRoundProperties().getAllowedScoreTypesToShow()));
        this.viewGroup = new ButtonGroup();
        this.addViewButton(this.viewGroup, this, ResultDisplayType.STATUS);
        this.addViewButton(this.viewGroup, this, ResultDisplayType.POINTS);
        this.addViewButton(this.viewGroup, this, ResultDisplayType.PASSED_TESTS);
        this.viewGroup.setSelected(this.viewGroup.getElements().nextElement().getModel(), true);
    }

    private void addViewButton(ButtonGroup buttonGroup, JPanel jPanel, final ResultDisplayType resultDisplayType) {
        if (this.resultDisplayTypes.contains(resultDisplayType)) {
            JRadioButton jRadioButton = new JRadioButton(resultDisplayType.getDescription());
            jRadioButton.setBackground(Common.WPB_COLOR);
            jRadioButton.setForeground(Color.white);
            jRadioButton.setActionCommand(String.valueOf(resultDisplayType.getId()));
            jRadioButton.setOpaque(false);
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResultDisplayTypeSelectionPanel.this.listener.typeChanged(resultDisplayType);
                }
            });
            buttonGroup.add(jRadioButton);
            jPanel.add(jRadioButton);
        }
    }

    public void setSelectedType(ResultDisplayType resultDisplayType) {
        String string = String.valueOf(resultDisplayType.getId());
        Enumeration<AbstractButton> enumeration = this.viewGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ButtonModel buttonModel = enumeration.nextElement().getModel();
            if (!buttonModel.getActionCommand().equals(string)) continue;
            this.viewGroup.setSelected(buttonModel, true);
        }
    }

    public ResultDisplayType getSelectedType() {
        return ResultDisplayType.get(Integer.parseInt(this.viewGroup.getSelection().getActionCommand()));
    }

    public static interface Listener {
        public void typeChanged(ResultDisplayType var1);
    }
}

