/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.widgets;

import com.topcoder.client.contestApplet.common.Common;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LookupJLabelComboBoxEditor
implements ComboBoxEditor,
FocusListener {
    protected SpecialTextField editor;
    protected ComboBoxModel model;
    protected JLabel temp = new JLabel();
    protected Color foreground = Common.FG_COLOR;
    protected Color background = Common.BG_COLOR;
    protected Border border = BorderFactory.createBevelBorder(0, this.foreground, Common.WPB_COLOR);

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public LookupJLabelComboBoxEditor(ComboBoxModel comboBoxModel) {
        this();
        this.model = comboBoxModel;
    }

    public LookupJLabelComboBoxEditor() {
        this.editor = new SpecialTextField();
        this.editor.addFocusListener(this);
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.model = comboBoxModel;
    }

    public Component getEditorComponent() {
        return this.editor;
    }

    public void setItem(Object object) {
        if (object == null) {
            this.editor.setText("");
            this.editor.setForeground(this.foreground);
        } else {
            JLabel jLabel = (JLabel)object;
            this.editor.setText(jLabel.getText());
            this.editor.setForeground(jLabel.getForeground());
        }
        this.editor.resetUncommitted();
    }

    public Object getItem() {
        this.editor.commitText();
        this.temp.setText(this.editor.getText());
        this.temp.setForeground(this.editor.getForeground());
        return this.temp;
    }

    public void selectAll() {
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.editor.commitText();
    }

    public void addActionListener(ActionListener actionListener) {
        this.editor.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.editor.removeActionListener(actionListener);
    }

    private class SpecialTextField
    extends JTextField {
        private StringBuffer originalText = new StringBuffer(50);
        private String unCommittedText = "";

        public SpecialTextField() {
            this.setDocument(new SpecialDocument());
            this.setBackground(LookupJLabelComboBoxEditor.this.background);
            this.setForeground(LookupJLabelComboBoxEditor.this.foreground);
            this.setCaretColor(LookupJLabelComboBoxEditor.this.foreground);
            this.setBorder(LookupJLabelComboBoxEditor.this.border);
        }

        public final void commitText() {
            if (!this.unCommittedText.equals("")) {
                LookupJLabelComboBoxEditor.this.editor.setText(LookupJLabelComboBoxEditor.this.editor.getText() + this.unCommittedText);
                this.resetUncommitted();
            }
        }

        public final void resetUncommitted() {
            this.unCommittedText = "";
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.unCommittedText.equals("")) {
                return;
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth(this.getText());
            try {
                Rectangle rectangle = this.modelToView(0);
                if (rectangle == null) {
                    return;
                }
                graphics.setColor(Color.gray);
                graphics.drawString(this.unCommittedText, rectangle.x + n, rectangle.y + fontMetrics.getAscent());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private class SpecialDocument
        extends PlainDocument {
            private SpecialDocument() {
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                SpecialTextField.this.originalText.insert(n, string);
                this.updateUnCommitted();
            }

            public void remove(int n, int n2) throws BadLocationException {
                SpecialTextField.this.originalText.delete(n, n + n2);
                this.updateUnCommitted();
            }

            public void updateUnCommitted() throws BadLocationException {
                String string = SpecialTextField.this.originalText.toString();
                int n = string.length();
                if (string.equals("")) {
                    SpecialTextField.this.resetUncommitted();
                    super.remove(0, this.getLength());
                    ((SpecialTextField)SpecialTextField.this).LookupJLabelComboBoxEditor.this.editor.setForeground(((SpecialTextField)SpecialTextField.this).LookupJLabelComboBoxEditor.this.foreground);
                    return;
                }
                for (int i = 0; i < ((SpecialTextField)SpecialTextField.this).LookupJLabelComboBoxEditor.this.model.getSize(); ++i) {
                    String string2;
                    JLabel jLabel = (JLabel)((SpecialTextField)SpecialTextField.this).LookupJLabelComboBoxEditor.this.model.getElementAt(i);
                    if (jLabel == null || (string2 = jLabel.getText()).length() < n) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n);
                    if (!string.equalsIgnoreCase(string3)) continue;
                    super.remove(0, this.getLength());
                    super.insertString(0, string3, null);
                    SpecialTextField.this.unCommittedText = string4;
                    ((SpecialTextField)SpecialTextField.this).LookupJLabelComboBoxEditor.this.editor.setForeground(jLabel.getForeground());
                    return;
                }
                super.remove(0, this.getLength());
                super.insertString(0, string, null);
                SpecialTextField.this.resetUncommitted();
                ((SpecialTextField)SpecialTextField.this).LookupJLabelComboBoxEditor.this.editor.setForeground(((SpecialTextField)SpecialTextField.this).LookupJLabelComboBoxEditor.this.foreground);
            }
        }
    }
}

