/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.widgets;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.frames.SourceViewer;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.ProblemModel;
import javax.swing.JFrame;

public class LongCodeViewer
implements SourceViewer.SourceViewerListener {
    private ContestApplet ca;
    private Contestant model;
    private JFrame frame = null;
    private CoderComponent currentComponent;
    private ProblemModel currentProblemInfo;
    private SourceViewer src;
    private int roundId;
    private String handle;
    private int componentId;
    private boolean example;
    private int submissionNumber;
    private boolean pretty;
    private final CoderComponent.Listener myCoderComponentListener = new CoderComponent.Listener(){

        public void coderComponentEvent(CoderComponent coderComponent) {
            if (coderComponent.hasSourceCode()) {
                if (LongCodeViewer.this.currentProblemInfo == null) {
                    throw new IllegalStateException("Missing problem info");
                }
                LongCodeViewer.this.src.clear();
                LongCodeViewer.this.src.setCode(coderComponent.getSourceCode(), coderComponent.getSourceCodeLanguage());
                LongCodeViewer.this.src.setTitle(coderComponent.getCoder().getHandle() + "'s " + coderComponent.getComponent().getClassName() + " " + (LongCodeViewer.this.example ? "Example" : "Full") + " submission #" + LongCodeViewer.this.submissionNumber + " (" + coderComponent.getSourceCodeLanguage().getName() + ")");
                LongCodeViewer.this.currentComponent.removeListener(this);
            } else {
                LongCodeViewer.this.sourceViewerClosing();
            }
        }
    };
    private final ProblemModel.Listener myProblemModelListener = new ProblemModel.Listener(){

        public void updateProblemModel(ProblemModel problemModel) {
            if (problemModel.hasProblemStatement()) {
                LongCodeViewer.this.ca.getInterFrame().hideMessage();
                if (LongCodeViewer.this.src == null) {
                    throw new IllegalStateException("Source viewer not initialized!");
                }
            } else {
                throw new IllegalStateException("Missing statement for problem " + problemModel);
            }
            LongCodeViewer.this.src.setTitle(problemModel.getName());
            LongCodeViewer.this.src.setVisible(true);
            LongCodeViewer.this.src.setProblem(problemModel);
            LongCodeViewer.this.src.setCoderComponent(LongCodeViewer.this.currentComponent);
            LongCodeViewer.this.src.setWriter(LongCodeViewer.this.currentComponent.getCoder().getHandle());
            LongCodeViewer.this.src.refreshStatement();
        }

        public void updateProblemModelReadOnly(ProblemModel problemModel) {
        }
    };

    public LongCodeViewer(ContestApplet contestApplet, JFrame jFrame, int n, String string, int n2, boolean bl, int n3, boolean bl2) {
        this.ca = contestApplet;
        this.model = contestApplet.getModel();
        this.frame = jFrame;
        this.roundId = n;
        this.handle = string;
        this.componentId = n2;
        this.example = bl;
        this.submissionNumber = n3;
        this.pretty = bl2;
        this.currentComponent = this.model.getRound(n).getRoomByCoder(string).getCoder(string).getComponent(new Long(n2));
    }

    public void show() {
        if (this.currentComponent.getStatus() > 110) {
            this.createNewSourceViewer();
            this.currentProblemInfo = this.currentComponent.getComponent().getProblem();
            this.ca.setCurrentFrame(this.frame);
            this.currentComponent.addListener(this.myCoderComponentListener);
            this.currentProblemInfo.addListener(this.myProblemModelListener);
            this.ca.setCurrentFrame(this.frame);
            this.ca.getInterFrame().showMessage("Fetching problem...", this.frame, 121);
            this.ca.getModel().getRequester().requestSourceCode(this.getRoundId(), this.getHandle(), this.getComponentId(), this.isExample(), this.getSubmissionNumber(), this.isPretty());
        }
    }

    private void createNewSourceViewer() {
        this.close();
        this.src = new SourceViewer(this.ca, false, true);
        this.src.setPanel(this);
    }

    public void close() {
        if (this.src != null) {
            this.sourceViewerClosing();
            this.src.setVisible(false);
            this.src.dispose();
            this.src = null;
        }
    }

    public void sourceViewerClosing() {
        if (this.currentProblemInfo != null) {
            this.currentProblemInfo.removeListener(this.myProblemModelListener);
            this.currentProblemInfo = null;
        }
        if (this.currentComponent != null) {
            this.currentComponent.removeListener(this.myCoderComponentListener);
            this.currentComponent = null;
        }
    }

    public boolean isExample() {
        return this.example;
    }

    public String getHandle() {
        return this.handle;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public int getRoundId() {
        return this.roundId;
    }

    public int getSubmissionNumber() {
        return this.submissionNumber;
    }

    public int getComponentId() {
        return this.componentId;
    }
}

