/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.widgets;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.frames.BroadcastSummaryFrame;
import com.topcoder.client.contestant.BroadcastListener;
import com.topcoder.client.contestant.BroadcastManager;
import com.topcoder.netCommon.contestantMessages.AdminBroadcast;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public final class BroadcastButton
extends JButton
implements BroadcastListener {
    private ImageIcon flashingIcon;
    private ImageIcon nonFlashingIcon;
    private ImageIcon disabledFlashingIcon;
    private ImageIcon disabledNonFlashingIcon;
    private transient ContestApplet ca;
    private boolean flashing;
    private boolean flashingEnabled = false;
    private static final LocalPreferences pref = LocalPreferences.getInstance();
    private boolean enabled = true;
    private BroadcastManager manager;
    private WeakListener windowListener;
    private WeakObserver prefObserver;

    private synchronized void setFlashing(boolean bl) {
        if (this.flashing == bl) {
            return;
        }
        boolean bl2 = this.flashing = bl && this.flashingEnabled;
        if (this.flashing) {
            this.setIcon(this.flashingIcon);
        } else {
            this.setIcon(this.nonFlashingIcon);
        }
        this.repaint();
    }

    public synchronized void newBroadcast(AdminBroadcast adminBroadcast) {
        if (!this.manager.hasRead(adminBroadcast)) {
            this.setFlashing(true);
        }
    }

    public void readBroadcast(AdminBroadcast adminBroadcast) {
    }

    public void refreshBroadcasts() {
    }

    public void setButtonEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            if (this.flashing) {
                this.setIcon(this.flashingIcon);
            } else {
                this.setIcon(this.nonFlashingIcon);
            }
        } else if (this.flashing) {
            this.setIcon(this.disabledFlashingIcon);
        } else {
            this.setIcon(this.disabledNonFlashingIcon);
        }
    }

    public BroadcastButton(ContestApplet contestApplet) {
        this.ca = contestApplet;
        this.setFlashingEnabled();
        this.prefObserver = new WeakObserver(this);
        pref.addSaveObserver(this.prefObserver);
        this.manager = this.ca.getModel().getBroadcastManager();
        this.flashingIcon = Common.getImage("g_flashing_broadcast_button.gif", this.ca);
        this.nonFlashingIcon = Common.getImage("g_nonflashing_broadcast_button.gif", this.ca);
        this.disabledFlashingIcon = Common.getImage("no_g_flashing_broadcast_button.gif", this.ca);
        this.disabledNonFlashingIcon = Common.getImage("no_g_nonflashing_broadcast_button.gif", this.ca);
        ImageIcon imageIcon = this.nonFlashingIcon;
        this.setIcon(imageIcon);
        this.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.setMaximumSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.windowListener = new WeakListener(this);
        BroadcastSummaryFrame.getInstance(this.ca).addWindowListener(this.windowListener);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BroadcastButton.this.enabled) {
                    BroadcastButton.this.ca.getRequester().requestGetAdminBroadcast();
                    BroadcastSummaryFrame.getInstance(BroadcastButton.this.ca).showFrame();
                }
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setToolTipText("Retrieve all broadcast messages.");
        this.setMnemonic('g');
        this.setOpaque(false);
        this.manager.addBroadcastListener(this, false);
    }

    protected void finalize() throws Throwable {
        BroadcastSummaryFrame.getInstance(this.ca).removeWindowListener(this.windowListener);
        LocalPreferences.getInstance().removeSaveObserver(this.prefObserver);
    }

    private synchronized void setFlashingEnabled() {
        this.flashingEnabled = Boolean.valueOf(pref.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.disableBroadcastPopup", "" + Boolean.FALSE));
    }

    private static final class WeakListener
    extends WindowAdapter {
        private WeakReference buttonRef;

        private WeakListener(BroadcastButton broadcastButton) {
            this.buttonRef = new WeakReference<BroadcastButton>(broadcastButton);
        }

        public void windowActivated(WindowEvent windowEvent) {
            BroadcastButton broadcastButton = (BroadcastButton)this.buttonRef.get();
            if (broadcastButton != null) {
                broadcastButton.setFlashing(false);
            }
        }
    }

    private static final class WeakObserver
    implements Observer {
        private WeakReference ref;

        public WeakObserver(BroadcastButton broadcastButton) {
            this.ref = new WeakReference<BroadcastButton>(broadcastButton);
        }

        public void update(Observable observable, Object object) {
            BroadcastButton broadcastButton = (BroadcastButton)this.ref.get();
            if (broadcastButton != null) {
                broadcastButton.setFlashingEnabled();
            }
        }
    }
}

