/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels.table;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry;
import com.topcoder.client.contestant.Contestant;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class UserNameRenderer
extends JLabel
implements TableCellRenderer {
    private Contestant model = null;
    private Color currentUserBackground;

    public void setModel(Contestant contestant) {
        this.model = contestant;
    }

    public void setCurrentUserBackground(Color color) {
        this.currentUserBackground = color;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        if (object instanceof UserNameEntry) {
            UserNameEntry userNameEntry = (UserNameEntry)object;
            this.setForeground(Common.getRankColor(userNameEntry.getRank()));
            this.setText(userNameEntry.getName());
            if (Common.isAdmin(userNameEntry.getRank())) {
                this.setFont(this.getFont().deriveFont(3));
            } else if (userNameEntry.isLeader()) {
                this.setFont(this.getFont().deriveFont(1));
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            if (!bl && userNameEntry.getName().equals(this.model.getCurrentUser())) {
                this.setBackground(this.currentUserBackground);
            }
        } else {
            this.setText("#####");
            this.setFont(this.getFont().deriveFont(0));
            this.setForeground(Color.red);
        }
        return this;
    }
}

