/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.AdditionalFontsConfigurationPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ChallengeConfigurationPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ChatConfigurationPanel;
import com.topcoder.client.contestApplet.uilogic.panels.HighlightConfigurationPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ProblemConfigurationPanel;
import com.topcoder.client.contestApplet.uilogic.panels.StdEdConfigurationPanel;
import com.topcoder.client.contestApplet.uilogic.panels.SummaryConfigurationPanel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import java.awt.Frame;

public class TabbedAppletConfigurationPanel {
    private ChatConfigurationPanel chatPanel;
    private StdEdConfigurationPanel stdEdPanel;
    private ProblemConfigurationPanel probPanel;
    private ChallengeConfigurationPanel chalPanel;
    private SummaryConfigurationPanel summPanel;
    private AdditionalFontsConfigurationPanel menuPanel;
    private HighlightConfigurationPanel highlightPanel;

    public TabbedAppletConfigurationPanel(FrameLogic frameLogic, UIPage uIPage) {
        UIComponent uIComponent = uIPage.getComponent("tabbed_applet_configuration_panel");
        uIComponent.setProperty("SelectedIndex", new Integer(0));
        this.chatPanel = new ChatConfigurationPanel(frameLogic, uIPage);
        this.stdEdPanel = new StdEdConfigurationPanel(frameLogic, uIPage);
        this.probPanel = new ProblemConfigurationPanel(frameLogic, uIPage);
        this.chalPanel = new ChallengeConfigurationPanel(frameLogic, uIPage);
        this.summPanel = new SummaryConfigurationPanel(frameLogic, uIPage);
        this.menuPanel = new AdditionalFontsConfigurationPanel(uIPage);
        this.highlightPanel = new HighlightConfigurationPanel(frameLogic, uIPage);
    }

    public void saveAll() {
        this.chatPanel.saveChatPreferences();
        this.stdEdPanel.saveStdEdPreferences();
        this.probPanel.saveProblemPreferences();
        this.chalPanel.saveChallengePreferences();
        this.summPanel.savePreferences();
        this.menuPanel.saveMenuPreferences();
        this.highlightPanel.saveHighlightPreferences();
        Frame[] frameArray = Frame.getFrames();
        for (int i = frameArray.length - 1; i >= 0; --i) {
            frameArray[i].repaint();
        }
    }

    public boolean isChangesPending() {
        return this.summPanel.areChangesPending() || this.chalPanel.areChangesPending() || this.chatPanel.areChangesPending() || this.stdEdPanel.areChangesPending() || this.probPanel.areChangesPending() || this.menuPanel.areChangesPending() || this.highlightPanel.areChangesPending();
    }
}

