/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.AppletPreferencesDialog;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class StdEdConfigurationPanel {
    private FrameLogic parent;
    private UIPage page;
    private UIComponent stdPreview;
    private String stdPreviewStr = "10 BEEP\n20 GOSUB 40\n30 GOTO 10\n40 PRINT \"WHEE\"\n50 RETURN\n";
    private MutableAttributeSet attr = new SimpleAttributeSet();
    private ActionHandler handler = new ActionHandler();
    private UIComponent stdFonts;
    private UIComponent stdFontSizes;
    private UIComponent javaRadioButton;
    private UIComponent cplusplusRadioButton;
    private UIComponent csharpRadioButton;
    private UIComponent vbRadioButton;
    private UIComponent pythonRadioButton;
    private UIComponent tabSize;
    private HashMap map = new HashMap();
    private HashMap keys = new HashMap();
    private boolean changesPending = false;
    private LocalPreferences localPref = LocalPreferences.getInstance();
    private AppletPreferencesDialog parentFrame;

    public StdEdConfigurationPanel(FrameLogic frameLogic, UIPage uIPage) {
        this.parent = frameLogic;
        this.parentFrame = (AppletPreferencesDialog)frameLogic;
        this.page = uIPage;
        this.stdPreview = uIPage.getComponent("editor_preview_pane");
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore"), "editor_foreground_button"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback"), "editor_background_button"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt"), "editor_selected_button"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb"), "editor_selection_button"));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind"), "editor_find_field"));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto"), "editor_goto_field"));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo"), "editor_undo_field"));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo"), "editor_redo_field"));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.keysave", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.keysave"), "editor_save_field"));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.keycompile", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.keycompile"), "editor_compile_field"));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.keytest", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.keytest"), "editor_test_field"));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.keysubmit", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.keysubmit"), "editor_submit_field"));
        Vector vector = Common.enumerateFonts();
        Object[] objectArray = new Object[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24"};
        Object[] objectArray2 = new Object[]{"Normal", "Bold", "Italic", "Bold Italic"};
        this.stdFonts = uIPage.getComponent("editor_fonts_list");
        this.stdFonts.setProperty("items", vector);
        this.stdFontSizes = uIPage.getComponent("editor_fontsize_list");
        this.stdFontSizes.setProperty("items", objectArray);
        this.stdFonts.setProperty("SelectedItem", this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont"));
        this.stdFontSizes.setProperty("SelectedItem", String.valueOf(this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize")));
        this.stdFonts.addEventListener("action", this.handler);
        this.stdFontSizes.addEventListener("action", this.handler);
        this.tabSize = uIPage.getComponent("editor_tabsize_field");
        this.tabSize.setProperty("Text", String.valueOf(LocalPreferences.getInstance().getTabSize()));
        this.javaRadioButton = uIPage.getComponent("editor_java_radio_button");
        this.cplusplusRadioButton = uIPage.getComponent("editor_c++_radio_button");
        this.csharpRadioButton = uIPage.getComponent("editor_c#_radio_button");
        this.vbRadioButton = uIPage.getComponent("editor_vb_radio_button");
        this.pythonRadioButton = uIPage.getComponent("editor_python_radio_button");
        ContestApplet contestApplet = this.parentFrame.getApplet();
        int n = 5;
        Integer n2 = new Integer(0);
        HashMap hashMap = contestApplet.getModel().getUserInfo().getPreferences();
        n = hashMap.containsKey(n2) ? (Integer)hashMap.get(n2) : 1;
        switch (n) {
            case 1: {
                this.javaRadioButton.setProperty("Selected", Boolean.TRUE);
                break;
            }
            case 3: {
                this.cplusplusRadioButton.setProperty("Selected", Boolean.TRUE);
                break;
            }
            case 4: {
                this.csharpRadioButton.setProperty("Selected", Boolean.TRUE);
                break;
            }
            case 5: {
                this.vbRadioButton.setProperty("Selected", Boolean.TRUE);
                break;
            }
            case 6: {
                this.pythonRadioButton.setProperty("Selected", Boolean.TRUE);
            }
        }
        if (!CommonData.allowsJava(this.parentFrame.getApplet().getCompanyName())) {
            this.javaRadioButton.setProperty("Visible", Boolean.FALSE);
        }
        if (!CommonData.allowsCPP(this.parentFrame.getApplet().getCompanyName())) {
            this.cplusplusRadioButton.setProperty("Visible", Boolean.FALSE);
        }
        if (!CommonData.allowsCS(this.parentFrame.getApplet().getCompanyName())) {
            this.csharpRadioButton.setProperty("Visible", Boolean.FALSE);
        }
        if (!CommonData.allowsVB(this.parentFrame.getApplet().getCompanyName())) {
            this.vbRadioButton.setProperty("Visible", Boolean.FALSE);
        }
        if (!CommonData.allowsPython(this.parentFrame.getApplet().getCompanyName())) {
            this.pythonRadioButton.setProperty("Visible", Boolean.FALSE);
        }
        this.resetPreview();
    }

    private UIComponent createHotKeyTextArea(String string, String string2) {
        final UIComponent uIComponent = this.page.getComponent(string2);
        uIComponent.setProperty("Text", string);
        uIComponent.addEventListener("key", new UIKeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 18 && keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 17) {
                    int n = keyEvent.getModifiers();
                    if ((n & ~16) > 0) {
                        StdEdConfigurationPanel.this.changesPending = true;
                        uIComponent.setProperty("Text", StdEdConfigurationPanel.this.modifiersToString(n) + KeyEvent.getKeyText(keyEvent.getKeyCode()));
                        MoveFocus.moveFocus(StdEdConfigurationPanel.this.parent.getFrame());
                    }
                }
                keyEvent.consume();
            }

            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        });
        return uIComponent;
    }

    private String modifiersToString(int n) {
        String string = "";
        if ((n & 2) > 0) {
            string = string + "Ctrl+";
        }
        if ((n & 8) > 0) {
            string = string + "Alt+";
        }
        if ((n & 1) > 0) {
            string = string + "Shift+";
        }
        return string;
    }

    private UIComponent createJButton(Color color, String string) {
        UIComponent uIComponent = this.page.getComponent(string);
        uIComponent.setProperty("Background", color);
        uIComponent.addEventListener("action", this.handler);
        return uIComponent;
    }

    private void resetPreview() {
        this.stdPreview.setProperty("Text", "");
        this.stdPreview.setProperty("SelectedTextColor", ((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt")).getProperty("Background"));
        this.stdPreview.setProperty("SelectionColor", ((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb")).getProperty("Background"));
        try {
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore")).getProperty("Background"));
            this.stdPreview.setProperty("Background", ((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback")).getProperty("Background"));
            StyleConstants.setFontFamily(this.attr, (String)this.stdFonts.getProperty("SelectedItem"));
            StyleConstants.setFontSize(this.attr, Integer.parseInt((String)this.stdFontSizes.getProperty("SelectedItem")));
            ((Document)this.stdPreview.getProperty("Document")).insertString(((Document)this.stdPreview.getProperty("Document")).getLength(), this.stdPreviewStr, this.attr);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public int getLanguage() {
        int n = 1;
        if (((Boolean)this.javaRadioButton.getProperty("Selected")).booleanValue()) {
            n = 1;
        } else if (((Boolean)this.cplusplusRadioButton.getProperty("Selected")).booleanValue()) {
            n = 3;
        } else if (((Boolean)this.csharpRadioButton.getProperty("Selected")).booleanValue()) {
            n = 4;
        } else if (((Boolean)this.vbRadioButton.getProperty("Selected")).booleanValue()) {
            n = 5;
        } else if (((Boolean)this.pythonRadioButton.getProperty("Selected")).booleanValue()) {
            n = 6;
        }
        return n;
    }

    public void saveStdEdPreferences() {
        Object object;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object3 = this.map.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = (UIComponent)this.map.get(object2);
            hashMap.put((String)object2, object.getProperty("Background"));
        }
        object3 = this.keys.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = (UIComponent)this.keys.get(object2);
            this.localPref.setProperty((String)object2, (String)object.getProperty("Text"));
        }
        this.localPref.saveColors(hashMap);
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont", (String)this.stdFonts.getProperty("SelectedItem"));
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize", (String)this.stdFontSizes.getProperty("SelectedItem"));
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdtabsize", (String)this.tabSize.getProperty("Text"));
        try {
            this.localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object3 = this.parentFrame.getApplet();
        ((ContestApplet)object3).getRequester().requestSetLanguage(this.getLanguage());
        object2 = ((ContestApplet)object3).getModel().getUserInfo().getPreferences();
        object = new Integer(0);
        ((HashMap)object2).put(object, new Integer(this.getLanguage()));
        ((ContestApplet)object3).getModel().getUserInfo().setPreferences((HashMap)object2);
        this.changesPending = false;
    }

    private class ActionHandler
    implements UIActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                Color color = ((JButton)actionEvent.getSource()).getBackground();
                Color color2 = JColorChooser.showDialog(null, "Choose color", color);
                if (color2 == null) {
                    return;
                }
                if (!color.equals(color2)) {
                    StdEdConfigurationPanel.this.changesPending = true;
                }
                ((JButton)actionEvent.getSource()).setBackground(color2);
                StdEdConfigurationPanel.this.resetPreview();
            } else if (object instanceof JComboBox) {
                StdEdConfigurationPanel.this.changesPending = true;
                StdEdConfigurationPanel.this.resetPreview();
            }
        }
    }
}

