/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.rooms.CoderRoom;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import java.awt.event.ActionEvent;

public class ProblemPanel {
    private UIComponent phaseStatus;
    private UIComponent phaseDesc;
    private UIComponent summary;
    private boolean enabled = true;
    private CoderRoom coderRoom;

    public ProblemPanel(ContestApplet contestApplet, UIPage uIPage, CoderRoom coderRoom, UIComponent uIComponent) {
        this.coderRoom = coderRoom;
        this.phaseStatus = uIPage.getComponent("phase_status");
        this.phaseDesc = uIPage.getComponent("phase_description");
        this.summary = uIPage.getComponent("problem_list_summary");
        this.summary.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProblemPanel.this.enabled) {
                    ProblemPanel.this.statusWindowEvent(actionEvent);
                }
            }
        });
        this.setPhase(0);
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.refreshSummaryButton();
    }

    public void setPhase(int n) {
        switch (n) {
            case 0: {
                this.phaseStatus.setProperty("Text", "COMPETITION STATUS : COMPETITION INACTIVE");
                this.phaseDesc.setProperty("Text", "The contest is currently not running.");
                break;
            }
            case 2: {
                this.phaseStatus.setProperty("Text", "COMPETITION STATUS : REGISTRATION PHASE");
                this.phaseDesc.setProperty("Text", "Select event registration from the main menu.");
                break;
            }
            case 1: 
            case 3: {
                this.phaseStatus.setProperty("Text", "COMPETITION STATUS : STARTS IN");
                this.phaseDesc.setProperty("Text", "The competition will start at the end of the countdown.");
                break;
            }
            case 4: {
                this.phaseStatus.setProperty("Text", "COMPETITION STATUS : CODING PHASE");
                this.phaseDesc.setProperty("Text", "Select a problem from the problem list.");
                break;
            }
            case 5: {
                this.phaseStatus.setProperty("Text", "COMPETITION STATUS : INTERMISSION");
                this.phaseDesc.setProperty("Text", "Please wait for the challenge phase to start.");
                break;
            }
            case 6: {
                this.phaseStatus.setProperty("Text", "COMPETITION STATUS : CHALLENGE PHASE");
                this.phaseDesc.setProperty("Text", "Please select the status window from the tools menu.");
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.phaseStatus.setProperty("Text", "COMPETITION STATUS : SYSTEM TESTING PHASE");
                this.phaseDesc.setProperty("Text", "Please wait for the system test phase to end.");
                break;
            }
            case 12: {
                this.phaseStatus.setProperty("Text", "MODERATED CHAT STATUS : CHATTING");
                this.phaseDesc.setProperty("Text", "Ask questions with /moderator.");
                break;
            }
            default: {
                System.err.println("Unknown phase (" + n + ").");
            }
        }
        this.refreshSummaryButton();
    }

    private void refreshSummaryButton() {
        boolean bl = this.enabled && this.coderRoom.getRoomModel() != null && this.coderRoom.getRoomModel().getRoundModel().canDisplaySummary();
        this.summary.setProperty("enabled", bl);
    }

    private void statusWindowEvent(ActionEvent actionEvent) {
        this.coderRoom.challengeButtonEvent(actionEvent);
    }
}

