/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.uilogic.panels.UserTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserTableModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIMouseAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class HSRegistrantsTablePanel
extends UserTablePanel {
    private JFrame jf = null;
    private UIComponent totalLabel;
    private UIComponent newbieLabel;

    protected String getTablePanelName() {
        return "hs_registrants_table_panel";
    }

    protected String getTableName() {
        return "hs_registrants_table";
    }

    protected String getMenuName() {
        return "hs_registrants_table_menu";
    }

    public HSRegistrantsTablePanel(ContestApplet contestApplet, UIPage uIPage, JFrame jFrame) {
        super(contestApplet, uIPage, new UserTableModel(contestApplet.getModel(), CommonData.registrantsHeader), "hs_registrants_user_renderer", "hs_registrants_header_renderer");
        uIPage.getComponent("hs_registrants_table_menu_info").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HSRegistrantsTablePanel.this.infoPopupEvent();
            }
        });
        this.jf = jFrame;
        this.totalLabel = uIPage.getComponent("hs_total_label");
        this.newbieLabel = uIPage.getComponent("hs_newbie_label");
        this.userTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                HSRegistrantsTablePanel.this.tableCountEvent();
            }
        });
        this.table.addEventListener("Mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HSRegistrantsTablePanel.this.doubleClickEvent(mouseEvent);
            }
        });
        this.userTableModel.sort(0, false);
    }

    public int getRowCount() {
        return (Integer)this.table.getProperty("RowCount");
    }

    protected void tableCountEvent() {
        ((TitledBorder)this.tablePanel.getProperty("Border")).setTitle("");
        if (this.totalLabel != null) {
            this.totalLabel.setProperty("Text", "Total registered [" + this.getRowCount() + "]");
            this.newbieLabel.setProperty("Text", "New [" + this.getNewCount() + "]");
        }
        this.tablePanel.performAction("revalidate");
        this.tablePanel.performAction("repaint");
    }

    public int getNewCount() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(i), new Integer(1)})).getRank() != 0) continue;
            ++n;
        }
        return n;
    }

    protected void doubleClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        if (this.isPanelEnabled()) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showContestPopup(mouseEvent);
            } else if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.infoPopupEvent();
            }
        }
    }

    protected void infoPopupEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        String string = ((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(n), new Integer(1)})).getName();
        this.ca.setCurrentFrame(this.jf);
        this.ca.requestCoderInfo(string, ((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(n), new Integer(1)})).getUserType());
    }
}

