/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.uilogic.panels.UserTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserTableModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIMouseAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class CoderContestantTablePanel
extends UserTablePanel {
    protected String getTablePanelName() {
        return "contestant_table_panel";
    }

    protected String getTableName() {
        return "contestant_table";
    }

    protected String getMenuName() {
        return "contestant_table_menu";
    }

    public CoderContestantTablePanel(ContestApplet contestApplet, UIPage uIPage) {
        this(contestApplet, uIPage, CommonData.contestantHeader);
    }

    public CoderContestantTablePanel(ContestApplet contestApplet, UIPage uIPage, String[] stringArray) {
        super(contestApplet, uIPage, new UserTableModel(contestApplet.getModel(), stringArray){

            protected boolean isLeader(String string) {
                RoomModel roomModel = this.contestantModel.getCurrentRoom();
                if (roomModel != null && roomModel.hasLeader()) {
                    return roomModel.getLeader().getUserName().equals(string);
                }
                return false;
            }
        }, "user_table_user_renderer", "user_table_header_renderer");
        this.table.addEventListener("mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (CoderContestantTablePanel.this.enabled) {
                    CoderContestantTablePanel.this.rightClickEvent(mouseEvent);
                    CoderContestantTablePanel.this.doubleClickEvent(mouseEvent);
                }
            }
        });
        this.userTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                CoderContestantTablePanel.this.tableCountEvent();
            }
        });
        uIPage.getComponent("contestant_table_menu_info").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoderContestantTablePanel.this.infoPopupEvent();
            }
        });
        uIPage.getComponent("contestant_table_menu_history").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoderContestantTablePanel.this.historyPopupEvent();
            }
        });
        this.userTableModel.sort(0, true);
    }

    private void historyPopupEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        UserNameEntry userNameEntry = (UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(n), new Integer(1)});
        this.ca.setCurrentFrame(this.ca.getMainFrame());
        this.ca.requestCoderHistory(userNameEntry.getName(), this.ca.getModel().getCurrentRoom().getRoomID(), userNameEntry.getUserType());
    }
}

