/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ChatConfigurationPanel {
    private FrameLogic parent;
    private UIPage page;
    private UIComponent chatPreview;
    private MutableAttributeSet attr = new SimpleAttributeSet();
    private ActionHandler handler = new ActionHandler();
    private HashMap map = new HashMap();
    private UIComponent fonts;
    private UIComponent fontSizes;
    private String lastFont;
    private String lastFontSize;
    private boolean changesPending = false;
    private static final LocalPreferences localPref = LocalPreferences.getInstance();

    public ChatConfigurationPanel(FrameLogic frameLogic, UIPage uIPage) {
        this.parent = frameLogic;
        this.page = uIPage;
        this.chatPreview = uIPage.getComponent("chat_preview_pane");
        this.fonts = uIPage.getComponent("chat_fonts_list");
        this.fonts.setProperty("items", Common.enumerateFonts());
        this.fontSizes = uIPage.getComponent("chat_fontsize_list");
        this.fontSizes.setProperty("items", new Object[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24"});
        this.fonts.setProperty("selectedItem", localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont"));
        this.fontSizes.setProperty("selectedItem", String.valueOf(localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize")));
        this.fonts.addEventListener("action", this.handler);
        this.fontSizes.addEventListener("action", this.handler);
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.systemfore", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.systemfore"), "chat_system_fore_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.systemback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.systemback"), "chat_system_back_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore"), "chat_emphsystem_fore_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback"), "chat_emphsystem_back_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore"), "chat_general_fore_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.generalback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generalback"), "chat_general_back_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore"), "chat_generalto_fore_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback"), "chat_generalto_back_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.mefore", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.mefore"), "chat_me_fore_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.meback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.meback"), "chat_me_back_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore"), "chat_whisper_fore_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.whisperback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whisperback"), "chat_whisper_back_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore"), "chat_whisperto_fore_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback"), "chat_whisperto_back_button"));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.handleback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.handleback"), "chat_handleback_button"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback"), "chat_panelback_button"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight"), "chat_findhighlight_button"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback", this.createJButton(localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback"), "chat_findback_button"));
        this.map.put("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore", this.createJButton(LocalPreferences.getInstance().getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore"), "chat_modquestion_fore_button"));
        this.map.put("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack", this.createJButton(LocalPreferences.getInstance().getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack"), "chat_modquestion_back_button"));
        this.map.put("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore", this.createJButton(LocalPreferences.getInstance().getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore"), "chat_modspeaker_fore_button"));
        this.map.put("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack", this.createJButton(LocalPreferences.getInstance().getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack"), "chat_modspeaker_back_button"));
        this.resetPreview();
    }

    private UIComponent createJButton(Color color, String string) {
        UIComponent uIComponent = this.page.getComponent(string);
        uIComponent.setProperty("Background", color);
        uIComponent.addEventListener("action", this.handler);
        return uIComponent;
    }

    private void resetPreview() {
        this.chatPreview.setProperty("Text", "");
        this.chatPreview.setProperty("Background", ((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback")).getProperty("Background"));
        this.lastFont = (String)this.fonts.getProperty("SelectedItem");
        this.lastFontSize = (String)this.fontSizes.getProperty("SelectedItem");
        Document document = (Document)this.chatPreview.getProperty("Document");
        try {
            StyleConstants.setFontFamily(this.attr, this.lastFont);
            StyleConstants.setFontSize(this.attr, Integer.parseInt(this.lastFontSize));
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.systemfore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.systemback")).getProperty("Background"));
            document.insertString(document.getLength(), "System> Pick a readable font.\n", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback")).getProperty("Background"));
            StyleConstants.setItalic(this.attr, true);
            StyleConstants.setBold(this.attr, true);
            document.insertString(document.getLength(), "System> Or you'll be sorry!\n", this.attr);
            StyleConstants.setForeground(this.attr, Color.yellow);
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.handleback")).getProperty("Background"));
            StyleConstants.setItalic(this.attr, false);
            StyleConstants.setBold(this.attr, false);
            document.insertString(document.getLength(), "Pops> ", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getProperty("Background"));
            document.insertString(document.getLength(), "a general message\n", this.attr);
            StyleConstants.setForeground(this.attr, Color.yellow);
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.handleback")).getProperty("Background"));
            document.insertString(document.getLength(), "Pops> ", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback")).getProperty("Background"));
            document.insertString(document.getLength(), "you: a general message to you\n", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.mefore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.meback")).getProperty("Background"));
            document.insertString(document.getLength(), "**you are quoting yourself\n", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whisperback")).getProperty("Background"));
            document.insertString(document.getLength(), "You whisper to AdamSelene: Hello.\n", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback")).getProperty("Background"));
            document.insertString(document.getLength(), "AdamSelene whispers to you: Hello!\n", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack")).getProperty("Background"));
            document.insertString(document.getLength(), "Moderated chat question?\n", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack")).getProperty("Background"));
            document.insertString(document.getLength(), "A moderated chat answer!\n", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getProperty("Background"));
            document.insertString(document.getLength(), "Text you ", this.attr);
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback")).getProperty("Background"));
            document.insertString(document.getLength(), "search", this.attr);
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getProperty("Background"));
            document.insertString(document.getLength(), "ed for!\n", this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore")).getProperty("Background"));
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getProperty("Background"));
            document.insertString(document.getLength(), "Other ", this.attr);
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight")).getProperty("Background"));
            document.insertString(document.getLength(), "search", this.attr);
            StyleConstants.setBackground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getProperty("Background"));
            document.insertString(document.getLength(), " matches when using\nthe highlight option!\n", this.attr);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public void saveChatPreferences() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            UIComponent uIComponent = (UIComponent)this.map.get(string);
            hashMap.put(string, uIComponent.getProperty("Background"));
        }
        localPref.saveColors(hashMap);
        localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont", (String)this.fonts.getProperty("SelectedItem"));
        localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize", (String)this.fontSizes.getProperty("SelectedItem"));
        try {
            localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.changesPending = false;
    }

    private class ActionHandler
    implements UIActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                Color color = ((JButton)actionEvent.getSource()).getBackground();
                Color color2 = JColorChooser.showDialog(null, "Choose color", color);
                if (color2 == null) {
                    return;
                }
                if (!color.equals(color2)) {
                    ChatConfigurationPanel.this.changesPending = true;
                }
                ((JButton)actionEvent.getSource()).setBackground(color2);
                ChatConfigurationPanel.this.resetPreview();
            } else if (!(!(object instanceof JComboBox) || ((String)ChatConfigurationPanel.this.fonts.getProperty("SelectedItem")).equals(ChatConfigurationPanel.this.lastFont) && ((String)ChatConfigurationPanel.this.fontSizes.getProperty("SelectedItem")).equals(ChatConfigurationPanel.this.lastFontSize))) {
                ChatConfigurationPanel.this.changesPending = true;
                ChatConfigurationPanel.this.resetPreview();
            }
        }
    }
}

