/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.LongAnswerPanel;
import com.topcoder.client.contestApplet.uilogic.panels.MultipleChoicePanel;
import com.topcoder.client.contestApplet.uilogic.panels.QuestionPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ShortAnswerPanel;
import com.topcoder.client.contestApplet.uilogic.panels.SingleChoicePanel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIWindowAdapter;
import com.topcoder.netCommon.contest.Answer;
import com.topcoder.netCommon.contest.Question;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;

public class SurveyDialog
implements FrameLogic {
    private UIPage page;
    private UIComponent dialog;
    private UIComponent okButton = null;
    private UIComponent cancelButton = null;
    private QuestionPanel[] questions = null;
    private ArrayList results = null;

    public UIComponent getFrame() {
        return this.dialog;
    }

    public SurveyDialog(ContestApplet contestApplet, JFrame jFrame, String string, String string2, String string3, ArrayList arrayList) {
        this.page = contestApplet.getCurrentUIManager().getUIPage("survey_dialog", true);
        this.dialog = this.page.getComponent("root_dialog", false);
        this.dialog.setProperty("Owner", jFrame);
        this.dialog.setProperty("title", string);
        this.dialog.create();
        this.dialog.addEventListener("Window", new UIWindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SurveyDialog.this.closeWindowEvent();
            }
        });
        this.page.getComponent("instruction_text").setProperty("text", string3);
        this.page.getComponent("term_text").setProperty("text", string2);
        this.questions = new QuestionPanel[arrayList.size()];
        UIComponent uIComponent = this.page.getComponent("eligibility_panel");
        UIComponent uIComponent2 = this.page.getComponent("survey_panel");
        int n = 0;
        int n2 = 0;
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        gridBagConstraints.fill = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Question question = (Question)arrayList.get(i);
            String string4 = question.getQuestionCategory() == 1 ? "[" + (n + 1) + "]" : "[" + (n2 + 1) + "]";
            if (question.getQuestionType() == 1) {
                this.questions[i] = new SingleChoicePanel(contestApplet, string4, question);
            } else if (question.getQuestionType() == 2) {
                this.questions[i] = new MultipleChoicePanel(contestApplet, string4, question);
            } else if (question.getQuestionType() == 4) {
                this.questions[i] = new ShortAnswerPanel(contestApplet, string4, question);
            } else if (question.getQuestionType() == 3) {
                this.questions[i] = new LongAnswerPanel(contestApplet, string4, question);
            } else {
                System.out.println("Question type not found.");
                continue;
            }
            if (question.getQuestionCategory() == 1) {
                gridBagConstraints.gridy = n++;
                uIComponent.addChild(this.questions[i].getPanel(), gridBagConstraints);
                continue;
            }
            gridBagConstraints.gridy = n2++;
            uIComponent2.addChild(this.questions[i].getPanel(), gridBagConstraints);
        }
        if (n == 0) {
            uIComponent.setProperty("visible", Boolean.FALSE);
        }
        if (n2 == 0) {
            uIComponent2.setProperty("visible", Boolean.FALSE);
        }
        this.okButton = this.page.getComponent("ok_button");
        this.cancelButton = this.page.getComponent("cancel_button");
        this.okButton.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SurveyDialog.this.okButtonEvent();
            }
        });
        this.cancelButton.addEventListener("Action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SurveyDialog.this.cancelButtonEvent();
            }
        });
        this.dialog.performAction("pack");
        Common.setLocationRelativeTo((Component)jFrame, (Component)this.dialog.getEventSource());
    }

    public ArrayList showDialog() {
        this.dialog.performAction("show");
        return this.results;
    }

    public void setButtonText(String string) {
        this.okButton.setProperty("Text", string);
    }

    public void setButton2Text(String string) {
        this.cancelButton.setProperty("Text", string);
        this.cancelButton.setProperty("Visible", Boolean.TRUE);
    }

    private void okButtonEvent() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.questions.length + 1);
        arrayList.add(new Boolean(true));
        for (int i = 0; i < this.questions.length; ++i) {
            Answer answer = this.questions[i].getAnswer();
            if (answer == null) {
                System.out.println("here");
                return;
            }
            arrayList.add(answer);
        }
        this.results = arrayList;
        this.dialog.performAction("dispose");
    }

    private void closeWindowEvent() {
        this.cancelButtonEvent();
    }

    private void cancelButtonEvent() {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(1);
        arrayList.add(new Boolean(false));
        this.results = arrayList;
        this.dialog.performAction("dispose");
    }
}

