/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.PhaseListener;
import com.topcoder.client.render.ProblemRenderer;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIWindowAdapter;
import com.topcoder.shared.language.BaseLanguage;
import com.topcoder.shared.language.JavaLanguage;
import com.topcoder.shared.language.Language;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JScrollBar;
import javax.swing.text.html.HTMLDocument;

public class StatementViewer
implements FrameLogic {
    private ContestApplet contestApplet;
    private UIComponent frame;
    private UIPage page;
    private UIComponent problemPane;
    private final LocalPreferences pref = LocalPreferences.getInstance();
    private boolean enabled = true;
    private UIComponent problemScroll;
    private UIComponent registerButton = null;
    private ProblemModel problem;
    private ProblemModel.Listener problemListener;
    private PhaseListener phaseListener;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.registerButton.setProperty("Enabled", this.enabled && this.isRegistrationOpen());
    }

    private boolean isRegistrationOpen() {
        return false;
    }

    public UIComponent getFrame() {
        return this.frame;
    }

    public StatementViewer(ContestApplet contestApplet) {
        this.contestApplet = contestApplet;
        this.page = contestApplet.getCurrentUIManager().getUIPage("statement_viewer", true);
        this.frame = this.page.getComponent("root_frame");
        this.problemListener = new ProblemModel.Listener(){

            public void updateProblemModelReadOnly(ProblemModel problemModel) {
            }

            public void updateProblemModel(ProblemModel problemModel) {
                StatementViewer.this.refreshView();
            }
        };
        this.phaseListener = new PhaseListener(){

            public void updateSystestProgress(int n, int n2, RoundModel roundModel) {
            }

            public void roomListEvent(RoundModel roundModel) {
            }

            public void phaseEvent(int n, RoundModel roundModel) {
                StatementViewer.this.updateRegisterButton();
            }

            public void enableRound(RoundModel roundModel) {
            }
        };
        this.create();
        this.frame.addEventListener("Window", new UIWindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StatementViewer.this.closeWindow();
            }
        });
    }

    private void create() {
        Serializable serializable;
        this.problemPane = this.page.getComponent("problem_statement_pane");
        this.problemScroll = this.page.getComponent("problem_statement_scroll_pane");
        this.registerButton = this.page.getComponent("register_button");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("body {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfont") + ";}");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("body {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobontsize") + "pt;}");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("pre {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfont") + ";}");
        ((HTMLDocument)this.problemPane.getProperty("Document")).getStyleSheet().addRule("pre {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfontsize") + "pt;}");
        this.problemPane.setProperty("Foreground", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfore"));
        this.problemPane.setProperty("Background", this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobback"));
        Point point = this.pref.getLocation("com.topcoder.jmaContestApplet.frames.statementViewer.location");
        if (point == null) {
            serializable = this.contestApplet.getCurrentFrame();
            point = serializable == null ? new Point(0, 0) : serializable.getLocation();
        }
        point = Common.adjustWindowLocation(point);
        this.frame.setProperty("Location", point);
        serializable = this.pref.getSize("com.topcoder.jmaContestApplet.frames.statementViewer.size");
        if (serializable == null) {
            serializable = (Dimension)this.frame.getProperty("Size");
        }
        serializable = Common.adjustWindowSize(point, (Dimension)serializable);
        this.frame.setProperty("Size", serializable);
        this.registerButton.addEventListener("Action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatementViewer.this.registerButtonEvent();
            }
        });
    }

    public void clear() {
        this.problemPane.setProperty("Text", "");
        ((JScrollBar)this.problemScroll.getProperty("VerticalScrollBar")).setValue(0);
    }

    public void setProblemStatement(ProblemModel problemModel) {
        if (this.problem != problemModel) {
            this.clear();
            this.removeListeners();
            this.problem = problemModel;
            this.updateTitle();
            this.addListeners();
        }
        this.updateView();
        this.updateRegisterButton();
    }

    private void updateTitle() {
        this.frame.setProperty("Title", this.problem.getName() + " statement " + (this.problem.hasProblemStatement() ? "" : "(loading...)"));
    }

    private void addListeners() {
        this.problem.addListener(this.problemListener);
        this.problem.getRound().addPhaseListener(this.phaseListener);
    }

    private void removeListeners() {
        if (this.problem != null) {
            this.problem.getRound().removePhaseListener(this.phaseListener);
            this.problem.removeListener(this.problemListener);
            this.problem = null;
        }
    }

    private void updateRegisterButton() {
        int n = this.problem.getRound().getPhase();
        this.registerButton.setProperty("Enabled", n >= 2 && n <= 4);
    }

    private void updateView() {
        if (!this.problem.hasProblemStatement()) {
            this.contestApplet.getRequester().requestOpenProblemForReading(this.problem.getRound().getRoundID(), this.problem.getProblemID());
            return;
        }
        this.refreshView();
    }

    private void refreshView() {
        if (!this.problem.hasProblemStatement()) {
            throw new IllegalStateException("No server object for problem");
        }
        this.updateTitle();
        ProblemRenderer problemRenderer = new ProblemRenderer(this.problem.getProblem());
        problemRenderer.setForegroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        problemRenderer.setBackgroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        String string = "";
        try {
            string = problemRenderer.toHTML(this.getLanguage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.problemPane.setProperty("Text", string);
        this.problemPane.setProperty("CaretPosition", new Integer(0));
    }

    private Language getLanguage() {
        Integer n = new Integer(0);
        HashMap hashMap = this.contestApplet.getModel().getUserInfo().getPreferences();
        if (hashMap.containsKey(n)) {
            if ((Integer)hashMap.get(n) == 0) {
                return JavaLanguage.JAVA_LANGUAGE;
            }
            return BaseLanguage.getLanguage((Integer)hashMap.get(n));
        }
        return JavaLanguage.JAVA_LANGUAGE;
    }

    private void registerButtonEvent() {
        this.contestApplet.getRequester().requestRegisterEventInfo(this.problem.getRound().getRoundID());
    }

    private void closeWindow() {
        this.removeListeners();
        this.clear();
        if (!this.enabled) {
            return;
        }
        this.pref.setLocation("com.topcoder.jmaContestApplet.frames.statementViewer.location", (Point)this.frame.getProperty("Location"));
        this.pref.setSize("com.topcoder.jmaContestApplet.frames.statementViewer.size", (Dimension)this.frame.getProperty("Size"));
        try {
            this.pref.savePreferences();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setVisible(boolean bl) {
        this.frame.setProperty("Visible", bl);
    }
}

