/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.uilogic.frames.CodingFrame;
import com.topcoder.client.contestApplet.uilogic.panels.MultiMethodProblemInfoPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ProblemInfoComponent;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.ui.event.UIActionListener;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JFrame;

public class LongCodingFrame
extends CodingFrame {
    public LongCodingFrame(ContestApplet contestApplet) {
        super(contestApplet, contestApplet.getCurrentUIManager().getUIPage("long_coding_frame", true));
    }

    protected Map createButtonDef() {
        Map map = super.createButtonDef();
        map.remove("test_button");
        map.remove("compile_button");
        map.put("example_button", new CodingFrame.ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.exampleLongButtonEvent();
            }
        }, null));
        map.put("example_results_button", new CodingFrame.ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.viewLastExampleButtonEvent();
            }
        }, null));
        map.put("submission_history_button", new CodingFrame.ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.viewSubmissionHistoryButtonEvent();
            }
        }, null));
        map.put("example_history_button", new CodingFrame.ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.viewExampleHistoryButtonEvent();
            }
        }, null));
        map.put("queue_button", new CodingFrame.ButtonDef(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.viewQueueButtonEvent();
            }
        }, null));
        ((CodingFrame.ButtonDef)map.get((Object)"submit_button")).listener = new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.submitLongButtonEvent();
            }
        };
        return map;
    }

    private void viewLastExampleButtonEvent() {
        if (this.isPanelEnabled()) {
            ContestApplet contestApplet = this.getParentFrame();
            Contestant contestant = contestApplet.getModel();
            contestApplet.setCurrentFrame((JFrame)this.getFrame().getEventSource());
            contestApplet.getInterFrame().showMessage("Fetching results...", (JFrame)this.getFrame().getEventSource(), 120);
            contestApplet.getRequester().requestLongTestResults(this.getComponentId(), this.getRoomModel().getRoomID(), contestant.getCurrentUser(), 0);
        }
    }

    private void submitLongButtonEvent() {
        if (this.isPanelEnabled()) {
            this.setButtons(false, false, false, false, false, false, false, false);
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame((JFrame)this.getFrame().getEventSource());
            contestApplet.getInterFrame().showMessage("Submitting...", (JFrame)this.getFrame().getEventSource(), 14);
            contestApplet.getRequester().requestSubmitLong(this.getComponentId(), this.getSourceCode(), this.getCurrentLanguageId(), false);
        }
    }

    private void exampleLongButtonEvent() {
        if (this.isPanelEnabled()) {
            this.setButtons(false, false, false, false, false, false, false, false);
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame((JFrame)this.getFrame().getEventSource());
            contestApplet.getInterFrame().showMessage("Example submission...", (JFrame)this.getFrame().getEventSource(), 15);
            contestApplet.getRequester().requestSubmitLong(this.getComponentId(), this.getSourceCode(), this.getCurrentLanguageId(), true);
        }
    }

    protected void viewSubmissionHistoryButtonEvent() {
        if (this.isPanelEnabled()) {
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame((JFrame)this.getFrame().getEventSource());
            Contestant contestant = contestApplet.getModel();
            this.getParentFrame().requestSubmissionHistory(contestant.getCurrentUser(), this.getRoomModel().getRoomID(), 1, false);
        }
    }

    protected void viewExampleHistoryButtonEvent() {
        if (this.isPanelEnabled()) {
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame((JFrame)this.getFrame().getEventSource());
            Contestant contestant = contestApplet.getModel();
            this.getParentFrame().requestSubmissionHistory(contestant.getCurrentUser(), this.getRoomModel().getRoomID(), 1, true);
        }
    }

    protected void viewQueueButtonEvent() {
        if (this.isPanelEnabled()) {
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame((JFrame)this.getFrame().getEventSource());
            contestApplet.getInterFrame().showMessage("Fetching queue status...", (JFrame)this.getFrame().getEventSource(), 122);
            this.getParentFrame().getRequester().requestViewQueueStatus();
        }
    }

    protected ProblemInfoComponent newProblemInfoPanel() {
        return new MultiMethodProblemInfoPanel(this.getParentFrame(), 1, this.page);
    }

    protected String getDefaultEditor() {
        return "Standard";
    }

    protected boolean isEditorAllowed() {
        return false;
    }
}

