/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.DivSummaryTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.LongSummaryTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.ResultDisplayTypeSelectionPanel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.TimeOutException;
import com.topcoder.client.contestant.view.ChallengeView;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIWindowAdapter;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DivSummaryFrame
implements FrameLogic {
    private UIComponent frame;
    private UIPage page;
    private ContestApplet parentFrame = null;
    private AbstractSummaryTablePanel challengePanel = null;
    private RoundModel roundModel = null;
    private boolean once = true;
    private UIComponent jrb2 = null;
    private Integer divisionID;
    private boolean open = false;
    private UIComponent divisionList;
    private boolean enabled = true;
    private ResultDisplayTypeSelectionPanel resultDisplayTypeSelectionPanel;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.divisionList.setProperty("Enabled", bl);
        if (this.challengePanel != null) {
            this.challengePanel.setPanelEnabled(bl);
        }
    }

    public UIComponent getFrame() {
        return this.frame;
    }

    public DivSummaryFrame(RoundModel roundModel, ContestApplet contestApplet) {
        this.page = contestApplet.getCurrentUIManager().getUIPage("div_summary_frame", true);
        this.frame = this.page.getComponent("root_frame");
        this.parentFrame = contestApplet;
        this.roundModel = roundModel;
        this.divisionID = roundModel.getRoundProperties().hasDivisions() && contestApplet.getModel().getUserInfo().getRating() != -1 && contestApplet.getModel().getUserInfo().getRating() < 1200 && this.roundModel.hasProblems(new Integer(2)) ? new Integer(2) : new Integer(1);
        this.create();
    }

    public void showFrame(boolean bl) {
        if (this.once) {
            Common.setLocationRelativeTo((Component)this.parentFrame.getMainFrame(), (Component)this.frame.getEventSource());
            this.once = false;
        }
        if (!this.open) {
            // empty if block
        }
        this.open = true;
        this.frame.performAction("show");
    }

    public void create() {
        this.divisionList = this.page.getComponent("division_list");
        this.jrb2 = this.page.getComponent("pretty_on");
        for (int i = 1; i <= 10; ++i) {
            if (!this.roundModel.hasProblems(new Integer(i)) || this.roundModel.getProblems(new Integer(i)).length <= 0) continue;
            this.divisionList.performAction("addItem", new Object[]{new Integer(i)});
        }
        this.divisionList.setProperty("SelectedItem", this.divisionID);
        this.divisionList.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DivSummaryFrame.this.divisionListEvent();
            }
        });
        final ListCellRenderer listCellRenderer = (ListCellRenderer)this.divisionList.getProperty("Renderer");
        this.divisionList.setProperty("Renderer", new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof Integer) {
                    Integer n2 = (Integer)object;
                    object = "Division " + n2;
                }
                return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        });
        this.divisionListEvent();
        if (!this.roundModel.getRoundProperties().hasDivisions()) {
            this.page.getComponent("select_division_label").setProperty("Visible", Boolean.FALSE);
            this.page.getComponent("division_list").setProperty("Visible", Boolean.FALSE);
        }
        if (!this.roundModel.getRoundType().isLongRound()) {
            this.page.getComponent("pretty_toggle_panel").setProperty("Visible", Boolean.TRUE);
            this.resultDisplayTypeSelectionPanel = new ResultDisplayTypeSelectionPanel(this.page, this.roundModel, new ResultDisplayTypeSelectionPanel.Listener(){

                public void typeChanged(ResultDisplayType resultDisplayType) {
                    DivSummaryFrame.this.challengePanel.updateView(resultDisplayType);
                }
            });
        } else {
            this.page.getComponent("pretty_toggle_panel").setProperty("Visible", Boolean.FALSE);
        }
        this.frame.addEventListener("window", new UIWindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DivSummaryFrame.this.unsetModel();
            }
        });
    }

    private void createChallengePanel() {
        if (this.challengePanel == null) {
            if (this.roundModel.getRoundType().isLongRound()) {
                this.page.getComponent("div_summary_table_panel").setProperty("Visible", Boolean.FALSE);
                this.challengePanel = new LongSummaryTablePanel(this.parentFrame, this.roundModel.getCoderRooms()[0], this, false, this.page);
            } else {
                this.page.getComponent("long_summary_table_panel").setProperty("Visible", Boolean.FALSE);
                this.challengePanel = new DivSummaryTablePanel(this.parentFrame, this.roundModel, this, this.divisionID, this.page);
            }
        } else if (this.challengePanel instanceof DivSummaryTablePanel) {
            ((DivSummaryTablePanel)this.challengePanel).setDivision(this.divisionID);
            this.challengePanel.updateView(this.resultDisplayTypeSelectionPanel.getSelectedType());
        }
    }

    public boolean getPrettyToggle() {
        return (Boolean)this.jrb2.getProperty("Selected");
    }

    private void setModel() {
        try {
            this.parentFrame.getRequester().requestDivSummary(this.roundModel.getRoundID(), this.divisionID.longValue());
        }
        catch (TimeOutException timeOutException) {
            timeOutException.printStackTrace();
        }
        int n = 0;
        RoomModel[] roomModelArray = this.roundModel.getCoderRooms();
        for (int i = 0; i < roomModelArray.length; ++i) {
            if (roomModelArray[i].getDivisionID().intValue() != this.divisionID.intValue()) continue;
            ++n;
            roomModelArray[i].addChallengeView(this.challengePanel);
        }
        if (this.challengePanel instanceof DivSummaryTablePanel) {
            ((DivSummaryTablePanel)this.challengePanel).totalRooms = n;
            ((DivSummaryTablePanel)this.challengePanel).setUpdate(true);
        } else if (this.challengePanel instanceof LongSummaryTablePanel) {
            ((LongSummaryTablePanel)this.challengePanel).setUpdate(true);
        }
    }

    private void unsetModel() {
        RoomModel[] roomModelArray = this.roundModel.getCoderRooms();
        for (int i = 0; i < roomModelArray.length; ++i) {
            if (roomModelArray[i].getDivisionID().intValue() != this.divisionID.intValue()) continue;
            roomModelArray[i].removeChallengeView(this.challengePanel);
        }
        if (this.enabled) {
            this.parentFrame.getRequester().requestCloseDivSummary(this.roundModel.getRoundID(), this.divisionID.longValue());
        }
    }

    public void hide() {
        this.frame.performAction("hide");
        if (this.open) {
            this.unsetModel();
        }
        this.challengePanel.closeSourceViewer();
    }

    public ChallengeView getChallengePanel() {
        return this.challengePanel;
    }

    private void divisionListEvent() {
        int n = (Integer)this.divisionList.getProperty("SelectedIndex");
        if (n < 0) {
            return;
        }
        Object object = this.divisionList.performAction("getItemAt", new Object[]{new Integer(n)});
        Integer n2 = (Integer)object;
        this.unsetModel();
        this.divisionID = n2;
        this.createChallengePanel();
        this.setModel();
        this.frame.performAction("validate");
        this.frame.performAction("repaint");
    }

    public boolean isVisible() {
        return (Boolean)this.frame.getProperty("visible");
    }

    public void requestFocus() {
        this.frame.performAction("requestFocus");
    }
}

