/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIWindowListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ClearProblemsDialog
implements FrameLogic,
UIActionListener,
UIWindowListener {
    private JCheckBox[] chkBoxes;
    private ProblemComponentModel[] components;
    private UIComponent clearButton;
    private UIComponent closeButton;
    private ContestApplet ca;
    private UIComponent dialog;
    private UIPage page;

    public ClearProblemsDialog(JFrame jFrame, ContestApplet contestApplet) {
        this.ca = contestApplet;
        this.page = contestApplet.getCurrentUIManager().getUIPage("clear_problems_dialog", true);
        this.dialog = this.page.getComponent("root_dialog", false);
        this.dialog.setProperty("Owner", jFrame);
        this.dialog.create();
        this.clearButton = this.page.getComponent("clear_button");
        this.closeButton = this.page.getComponent("close_button");
        Common.setLocationRelativeTo((Component)jFrame, (Component)this.dialog.getEventSource());
        RoomModel roomModel = contestApplet.getModel().getCurrentRoom();
        RoundModel roundModel = roomModel.getRoundModel();
        this.components = roundModel.getAssignedComponents(roomModel.getDivisionID());
        this.chkBoxes = new JCheckBox[this.components.length];
        JPanel jPanel = (JPanel)this.page.getComponent("checkbox_panel").getEventSource();
        UIComponent uIComponent = this.page.getComponent("checkbox_template");
        for (int i = 0; i < this.components.length; ++i) {
            this.chkBoxes[i] = (JCheckBox)uIComponent.performAction("clone");
            this.chkBoxes[i].setText("" + this.components[i].getPoints().intValue());
            jPanel.add((Component)this.chkBoxes[i], new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 25, 0, 0), 0, 0));
        }
        this.clearButton.addEventListener("action", this);
        this.closeButton.addEventListener("action", this);
        this.dialog.performAction("pack");
    }

    public UIComponent getFrame() {
        return this.dialog;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton.getEventSource()) {
            this.windowClosing(new WindowEvent((Window)this.dialog.getEventSource(), 201));
        } else if (object == this.clearButton.getEventSource()) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; i < this.components.length; ++i) {
                if (!this.chkBoxes[i].isSelected()) continue;
                arrayList.add(new Long(i));
            }
            Long[] longArray = new Long[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                longArray[i] = this.components[((Long)arrayList.get(i)).intValue()].getID();
            }
            this.ca.getRequester().requestClearPracticeProblem(this.ca.getModel().getCurrentRoom().getRoomID(), longArray);
            this.dialog.performAction("dispose");
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dialog.performAction("dispose");
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void show() {
        this.dialog.performAction("show");
    }
}

