/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.ChallengeTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.CodingTimerPanel;
import com.topcoder.client.contestApplet.uilogic.panels.LongSummaryTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.ResultDisplayTypeSelectionPanel;
import com.topcoder.client.contestApplet.uilogic.panels.TimerPanel;
import com.topcoder.client.contestApplet.uilogic.panels.UserAssignmentPanel;
import com.topcoder.client.contestApplet.uilogic.views.PrettyToggleProvider;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;

public class ChallengeFrame
implements FrameLogic,
PrettyToggleProvider {
    private UIComponent frame;
    private ContestApplet parentFrame = null;
    private AbstractSummaryTablePanel challengePanel = null;
    private CodingTimerPanel timerPanel = null;
    private boolean once = true;
    private UIComponent jrb2 = null;
    private UserAssignmentPanel userAssignmentPanel = null;
    private RoomModel room;
    private UIPage page;
    private boolean enabled = true;
    private boolean open = false;
    private ResultDisplayTypeSelectionPanel resultDisplayTypeSelectionPanel;

    public ChallengeFrame(ContestApplet contestApplet, RoomModel roomModel) {
        this.parentFrame = contestApplet;
        this.room = roomModel;
        this.page = contestApplet.getCurrentUIManager().getUIPage("challenge_frame", true);
        this.frame = this.page.getComponent("root_frame");
        this.create();
    }

    private void create() {
        if (this.room.getRoundModel().getRoundProperties().hasChallengePhase()) {
            this.page.getComponent("instruction_nochallengephase_scroll_pane").setProperty("Visible", Boolean.FALSE);
            Component component = (Component)this.page.getComponent("instruction_pane").getEventSource();
            MouseListener[] mouseListenerArray = component.getMouseListeners();
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                component.removeMouseListener(mouseListenerArray[i]);
            }
        } else {
            this.page.getComponent("instruction_scroll_pane").setProperty("Visible", Boolean.FALSE);
            Component component = (Component)this.page.getComponent("instruction_nochallengephase_pane").getEventSource();
            MouseListener[] mouseListenerArray = component.getMouseListeners();
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                component.removeMouseListener(mouseListenerArray[i]);
            }
        }
        if (this.room.getRoundModel() != null && this.room.getRoundModel().getRoundType().isLongRound()) {
            this.challengePanel = new LongSummaryTablePanel(this.parentFrame, this.room, this, true, this.page);
            this.page.getComponent("challenge_table_panel").setProperty("Visible", Boolean.FALSE);
        } else {
            this.challengePanel = new ChallengeTablePanel(this.parentFrame, this.room, this, this.page);
            this.page.getComponent("long_summary_table_panel").setProperty("Visible", Boolean.FALSE);
        }
        this.timerPanel = new CodingTimerPanel(this.parentFrame, this.page);
        if (this.parentFrame.getModel().getUserInfo().isCaptain() && (this.parentFrame.getModel().getCurrentRoom().getType() == 9 || this.parentFrame.getModel().getCurrentRoom().getType() == 10 || this.parentFrame.getModel().getCurrentRoom().getType() == 13)) {
            this.userAssignmentPanel = new UserAssignmentPanel(this.parentFrame, this.room, this.page);
            this.page.getComponent("user_assignment_panel").setProperty("visible", Boolean.TRUE);
        } else {
            this.page.getComponent("user_assignment_panel").setProperty("visible", Boolean.FALSE);
        }
        if (this.parentFrame.getCompanyName().equals("SunOnsite") && !this.room.isPracticeRoom()) {
            this.page.getComponent("view_results_panel").setProperty("visible", Boolean.TRUE);
            this.page.getComponent("view_results_button").addEventListener("action", new UIActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ChallengeFrame.this.parentFrame.getRequester().requestSystestResults(ChallengeFrame.this.room.getRoundModel().getRoundID().intValue());
                }
            });
        } else {
            this.page.getComponent("view_results_panel").setProperty("visible", Boolean.FALSE);
        }
        if (this.room.getRoundModel().getRoundType().isLongRound()) {
            this.page.getComponent("pretty_toggle_panel").setProperty("Visible", Boolean.FALSE);
        } else {
            this.jrb2 = this.page.getComponent("pretty_on");
            this.resultDisplayTypeSelectionPanel = new ResultDisplayTypeSelectionPanel(this.page, this.room.getRoundModel(), new ResultDisplayTypeSelectionPanel.Listener(){

                public void typeChanged(ResultDisplayType resultDisplayType) {
                    ChallengeFrame.this.challengePanel.updateView(resultDisplayType);
                }
            });
        }
        this.frame.performAction("pack");
    }

    public UIComponent getFrame() {
        return this.frame;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.challengePanel.setPanelEnabled(bl);
    }

    public void showFrame(boolean bl) {
        if (this.once) {
            Common.setLocationRelativeTo((Component)this.parentFrame.getMainFrame(), (JFrame)this.frame.getEventSource());
            this.once = false;
        }
        this.frame.performAction("show");
        if (!this.open) {
            this.parentFrame.getRequester().requestOpenSummary(this.room.getRoomID());
        }
        this.open = true;
        MoveFocus.moveFocus(this.challengePanel.getTable());
    }

    public boolean getPrettyToggle() {
        return (Boolean)this.jrb2.getProperty("Selected");
    }

    public void hide() {
        this.frame.performAction("hide");
        this.challengePanel.closeSourceViewer();
        if (this.open && this.enabled) {
            this.parentFrame.getRequester().requestCloseSummary(this.room.getRoomID());
        }
        this.open = false;
    }

    public ResultDisplayType getViewType() {
        return this.resultDisplayTypeSelectionPanel.getSelectedType();
    }

    public TimerPanel getTimerPanel() {
        return this.timerPanel;
    }

    public AbstractSummaryTablePanel getChallengePanel() {
        return this.challengePanel;
    }

    public boolean hasAssignmentPanel() {
        return this.userAssignmentPanel != null;
    }

    public UserAssignmentPanel getAssignmentPanel() {
        return this.userAssignmentPanel;
    }

    public void dispose() {
        this.frame.destroy();
    }
}

