/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.panels.table.RankRenderer;
import com.topcoder.client.contestApplet.panels.table.TablePanel;
import com.topcoder.client.contestApplet.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.panels.table.UserNameRenderer;
import com.topcoder.client.contestApplet.panels.table.UserTableModel;
import com.topcoder.client.contestApplet.widgets.ContestTableHeaderRenderer;
import com.topcoder.client.contestant.view.UserListListener;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class UserTablePanel
extends TablePanel
implements UserListListener {
    final MenuItemInfo[] USER_POPUP = new MenuItemInfo[]{new MenuItemInfo("Info", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            UserTablePanel.this.infoPopupEvent();
        }
    })};
    private String title = "";
    private UserTableModel userTableModel;
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setupFonts() {
        ((TitledBorder)this.getBorder()).setTitleFont(new Font(LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefont"), 1, LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefontsize")));
        ContestTableHeaderRenderer contestTableHeaderRenderer = (ContestTableHeaderRenderer)this.getTable().getColumnModel().getColumn(0).getHeaderRenderer();
        contestTableHeaderRenderer.setFont(new Font(LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefont"), 0, LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefontsize")));
        contestTableHeaderRenderer = (ContestTableHeaderRenderer)this.getTable().getColumnModel().getColumn(1).getHeaderRenderer();
        contestTableHeaderRenderer.setFont(new Font(LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefont"), 0, LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefontsize")));
    }

    private void setupColumns() {
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new RankRenderer());
        tableColumn.setMaxWidth(23);
        this.contestTable.getColumnModel().getColumn(1).setCellRenderer(new UserNameRenderer(this.ca.getModel(), LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefont"), LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefontsize")));
        this.contestTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UserTablePanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.getTableModel().sort(1, false);
    }

    UserTablePanel(ContestApplet contestApplet, String string, UserTableModel userTableModel, boolean bl) {
        super(contestApplet, string, userTableModel, bl);
        if (userTableModel.getColumnCount() < 2) {
            throw new IllegalArgumentException("Not enough headers in UserTablePanel()!");
        }
        this.userTableModel = userTableModel;
        this.setupColumns();
    }

    public UserTablePanel(ContestApplet contestApplet) {
        this(contestApplet, "Who's here");
    }

    UserTablePanel(ContestApplet contestApplet, String string) {
        super(contestApplet, string + " [0]", new UserTableModel(contestApplet.getModel(), CommonData.userHeader), true);
        this.title = string;
        this.setContestPopup("User Info", this.USER_POPUP);
        this.contestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (UserTablePanel.this.enabled) {
                    UserTablePanel.this.rightClickEvent(mouseEvent);
                    UserTablePanel.this.doubleClickEvent(mouseEvent);
                }
            }
        });
        this.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                UserTablePanel.this.tableCountEvent();
            }
        });
        this.setToolTipText("List of users currently in this room.");
        this.setupColumns();
        this.setupFonts();
    }

    public void updateUserList(final UserListItem[] userListItemArray) {
        Runnable runnable = new Runnable(){

            public void run() {
                UserTablePanel.this.getTableModel().update(Arrays.asList(userListItemArray));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void tableCountEvent() {
        ((TitledBorder)this.getBorder()).setTitle(this.title + " [" + this.contestTable.getRowCount() + "]");
        this.revalidate();
        this.repaint();
    }

    void doubleClickEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.infoPopupEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.getTable().getTableHeader().repaint();
        }
    }

    void infoPopupEvent() {
        int n = this.contestTable.getSelectedRow();
        String string = ((UserNameEntry)this.contestTable.getValueAt(n, 1)).getName();
        this.ca.setCurrentFrame(this.ca.getMainFrame());
        this.ca.requestCoderInfo(string, ((UserNameEntry)this.contestTable.getValueAt(n, 1)).getUserType());
    }

    public String getSelectedUserHandle() {
        int n = this.getTable().getSelectedRow();
        if (0 > n || n >= this.contestTable.getRowCount()) {
            return "";
        }
        return this.userTableModel.getUser(n).getUserName();
    }
}

