/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.panels.table.LeaderboardTableModel;
import com.topcoder.client.contestApplet.panels.table.RankRenderer;
import com.topcoder.client.contestApplet.panels.table.TablePanel;
import com.topcoder.client.contestApplet.panels.table.UserNameRenderer;
import com.topcoder.client.contestApplet.widgets.ContestTableHeaderRenderer;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.LeaderListener;
import com.topcoder.netCommon.contestantMessages.response.data.LeaderboardItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;

public final class RoomInfoTablePanel
extends TablePanel
implements LeaderListener {
    private LeaderboardTableModel leaderboardTableModel;
    private RoundModel roundModel;
    private final MenuItemInfo[] USER_POPUP = new MenuItemInfo[]{new MenuItemInfo("Info", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            RoomInfoTablePanel.this.popupEvent();
        }
    })};
    private boolean enabled = true;

    public RoomInfoTablePanel(ContestApplet contestApplet) {
        super(contestApplet, "Room Leaders", new LeaderboardTableModel(contestApplet.getModel()), true);
        this.leaderboardTableModel = (LeaderboardTableModel)this.tableModel;
        this.setContestPopup("Contestants Info", this.USER_POPUP);
        this.contestTable.getTableHeader().setDefaultRenderer(new ContestTableHeaderRenderer(true, null, 12));
        TableColumnModel tableColumnModel = this.contestTable.getColumnModel();
        tableColumnModel.getColumn(0).setWidth(50);
        tableColumnModel.getColumn(0).setMinWidth(50);
        tableColumnModel.getColumn(0).setMaxWidth(50);
        tableColumnModel.getColumn(1).setWidth(23);
        tableColumnModel.getColumn(1).setMinWidth(23);
        tableColumnModel.getColumn(1).setMaxWidth(23);
        tableColumnModel.getColumn(1).setCellRenderer(new RankRenderer());
        tableColumnModel.getColumn(2).setCellRenderer(new UserNameRenderer(contestApplet.getModel(), null, 12));
        tableColumnModel.getColumn(3).setWidth(40);
        tableColumnModel.getColumn(3).setMinWidth(40);
        tableColumnModel.getColumn(3).setMaxWidth(40);
        tableColumnModel.getColumn(4).setWidth(50);
        tableColumnModel.getColumn(4).setMinWidth(50);
        tableColumnModel.getColumn(4).setMaxWidth(50);
        tableColumnModel.getColumn(5).setWidth(10);
        tableColumnModel.getColumn(5).setMinWidth(10);
        tableColumnModel.getColumn(5).setMaxWidth(10);
        this.contestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (RoomInfoTablePanel.this.enabled) {
                    RoomInfoTablePanel.this.doubleClickEvent(mouseEvent);
                }
            }
        });
        this.contestTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                RoomInfoTablePanel.this.headerClickEvent(mouseEvent);
            }
        });
    }

    private void doubleClickEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.popupEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            boolean bl = (mouseEvent.getModifiers() & 1) > 0;
            this.getTableModel().sort(n, bl);
            this.getTable().getTableHeader().repaint();
        }
    }

    private void popupEvent() {
        int n = this.contestTable.getSelectedRow();
        this.ca.setCurrentFrame(this.ca.getMainFrame());
        this.ca.getRoomManager().watch(this.leaderboardTableModel.getLeaderboardItem(n).getRoomID());
    }

    public void clear() {
        this.leaderboardTableModel.clear();
        if (this.roundModel != null) {
            this.roundModel.removeLeaderListener(this);
            this.roundModel = null;
        }
    }

    public void setRound(RoundModel roundModel) {
        this.clear();
        this.roundModel = roundModel;
        this.roundModel.addLeaderListener(this);
        if (roundModel.hasLeaderboard()) {
            LeaderboardItem[] leaderboardItemArray = roundModel.getLeaderboard();
            this.leaderboardTableModel.update(Arrays.asList(leaderboardItemArray));
        }
    }

    public void updateLeader(RoomModel roomModel) {
        if (this.roundModel != null && this.roundModel.hasLeaderboard()) {
            LeaderboardItem[] leaderboardItemArray = this.roundModel.getLeaderboard();
            this.leaderboardTableModel.update(Arrays.asList(leaderboardItemArray));
        }
    }
}

