/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.panels.table.BaseAlgoSummaryTablePanel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.ChallengeView;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JFrame;

public final class ChallengeTablePanel
extends BaseAlgoSummaryTablePanel
implements ChallengeView {
    private final RoomModel roomModel;

    public ChallengeTablePanel(ContestApplet contestApplet, RoomModel roomModel, JFrame jFrame, boolean bl) {
        super(contestApplet, jFrame, bl, true);
        this.roomModel = roomModel;
        this.init();
    }

    protected RoundModel getRoundModel() {
        if (!this.roomModel.hasRoundModel()) {
            throw new IllegalStateException("Can't build challenge table model, no round for room: " + this.roomModel);
        }
        return this.roomModel.getRoundModel();
    }

    protected Integer getDivisionID() {
        return this.roomModel.getDivisionID();
    }

    protected boolean isRoomLeader(String string) {
        return this.roomModel.getLeader().getUserName().equals(string);
    }

    protected Collection getCoders() {
        if (!this.roomModel.hasCoders()) {
            throw new IllegalStateException("No coders for room: " + this.roomModel);
        }
        return Arrays.asList(this.roomModel.getCoders());
    }

    protected RoomModel getRoomByCoder(String string) {
        return this.roomModel;
    }

    public void updateChallengeTable(RoomModel roomModel) {
        if (this.roomModel != roomModel) {
            throw new IllegalStateException("Got event for unrecognized room: " + roomModel);
        }
        this.getTableModel().updateChallengeTable();
    }

    protected String getTitle() {
        return "Details Table";
    }
}

