/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.widgets.SortedComboBoxModel;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.AssignmentView;
import com.topcoder.client.contestant.view.ChallengeView;
import com.topcoder.netCommon.contest.ComponentAssignmentData;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class UserAssignmentPanel
extends JPanel
implements ChallengeView,
AssignmentView {
    private ContestApplet ca = null;
    private RoomModel room;
    private ArrayList problemSet = null;
    private String[] problems = null;
    private String[][] components = null;
    private String[] headers = null;
    private ArrayList users;
    private SortedComboBoxModel[][] userModel = null;
    private JComboBox[][] combos = null;

    public UserAssignmentPanel(ContestApplet contestApplet, RoomModel roomModel) {
        this.room = roomModel;
        this.ca = contestApplet;
        this.createProblems();
    }

    private void create() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JButton jButton = new JButton("Commit");
        ProblemModel[] problemModelArray = this.room.getRoundModel().getProblems(this.room.getDivisionID());
        ComponentAssignmentData componentAssignmentData = this.ca.getModel().getComponentAssignmentData();
        this.setBorder(Common.getTitledBorder("User Assignment"));
        if (this.problemSet == null) {
            System.err.println("No problem set specified");
            return;
        }
        this.combos = new JComboBox[this.problems.length][this.headers.length - 1];
        this.userModel = new SortedComboBoxModel[this.problems.length][this.headers.length - 1];
        this.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof UserListItem) {
                    object = ((UserListItem)object).getUserName();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        };
        int n = 0;
        for (int i = 0; i < this.problems.length; ++i) {
            int n2 = 0;
            JLabel jLabel = new JLabel(this.problems[i] + ":");
            jLabel.setForeground(Common.STATUS_COLOR);
            gridBagConstraints.anchor = 10;
            Common.insertInPanel(jLabel, this, gridBagConstraints, 0, n, 1, 1, 1.0, 0.0);
            Common.insertInPanel(new JLabel(" "), this, gridBagConstraints, 0, n + 1, 1, 1, 0.0, 0.0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            for (n2 = 0; n2 < ((ProblemModel)this.problemSet.get(i)).getComponents().length; ++n2) {
                jLabel = new JLabel(this.components[i][n2]);
                Common.insertInPanel(jLabel, this, gridBagConstraints, n2 + 1, n, 1, 1, 0.0, 1.0);
                jLabel.setForeground(Common.STATUS_COLOR);
                this.combos[i][n2] = Common.createComboBox();
                this.combos[i][n2].setRenderer(defaultListCellRenderer);
                int n3 = 0;
                for (int j = 0; j < this.users.size(); ++j) {
                    this.combos[i][n2].addItem(this.users.get(j));
                    if (componentAssignmentData.getAssignedUserForComponent((int)problemModelArray[i].getComponents()[n2].getID().longValue()) != ((UserListItem)this.users.get(j)).getUserID()) continue;
                    n3 = j;
                }
                if (this.users.size() > 0) {
                    this.combos[i][n2].setSelectedIndex(n3);
                }
                this.combos[i][n2].setFont(new Font("SansSerif", 0, 12));
                this.combos[i][n2].setPreferredSize(new Dimension(90, 20));
                this.combos[i][n2].setEditable(false);
                this.combos[i][n2].setBackground(Common.BG_COLOR);
                Common.insertInPanel(this.combos[i][n2], this, gridBagConstraints, n2 + 1, n + 1, 1, 1, 1.0, 1.0);
            }
            while (n2 < this.headers.length - 1) {
                this.combos[i][n2] = null;
                this.userModel[i][n2] = null;
                Common.insertInPanel(new JLabel(""), this, gridBagConstraints, n2 + 1, n, 1, 1, 1.0, 0.0);
                Common.insertInPanel(new JLabel(""), this, gridBagConstraints, n2 + 1, n + 1, 1, 1, 1.0, 0.0);
                ++n2;
            }
            n += 2;
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        Common.insertInPanel(jButton, this, gridBagConstraints, this.headers.length, 0, 1, n, 10.0, 0.0);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserAssignmentPanel.this.commit();
            }
        });
    }

    public void commit() {
        RoundModel roundModel = this.room.getRoundModel();
        ComponentAssignmentData componentAssignmentData = this.ca.getModel().getComponentAssignmentData();
        componentAssignmentData = new ComponentAssignmentData(componentAssignmentData.getTeamID(), componentAssignmentData.getRoundID());
        ProblemModel[] problemModelArray = roundModel.getProblems(this.room.getDivisionID());
        for (int i = 0; i < this.components.length; ++i) {
            for (int j = 0; j < this.components[i].length; ++j) {
                if (!(this.combos[i][j].getSelectedItem() instanceof UserListItem)) continue;
                componentAssignmentData.assignComponent((int)problemModelArray[i].getComponents()[j].getID().longValue(), ((UserListItem)this.combos[i][j].getSelectedItem()).getUserID());
            }
        }
        this.ca.getRequester().requestAssignComponents(componentAssignmentData);
    }

    private void createProblems() {
        int n;
        if (!this.room.hasRoundModel()) {
            throw new IllegalStateException("Can't build assignment panel, no round for room: " + this.room);
        }
        RoundModel roundModel = this.room.getRoundModel();
        if (!roundModel.hasProblems(this.room.getDivisionID())) {
            throw new IllegalStateException("Can't build assignment panel, no problems for round: " + roundModel);
        }
        ProblemModel[] problemModelArray = roundModel.getProblems(this.room.getDivisionID());
        ArrayList<ProblemModel> arrayList = new ArrayList<ProblemModel>();
        int n2 = 0;
        for (n = 0; n < problemModelArray.length; ++n) {
            arrayList.add(problemModelArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (n2 >= ((ProblemModel)arrayList.get(n)).getComponents().length) continue;
            n2 = ((ProblemModel)arrayList.get(n)).getComponents().length;
        }
        this.headers = new String[n2 + 1];
        this.headers[0] = "Problem";
        for (n = 0; n < n2; ++n) {
            this.headers[n + 1] = "Component " + (n + 1);
        }
        this.problems = new String[arrayList.size()];
        this.components = new String[arrayList.size()][];
        for (n = 0; n < arrayList.size(); ++n) {
            this.problems[n] = ((ProblemModel)arrayList.get(n)).getName();
            this.components[n] = new String[((ProblemModel)arrayList.get(n)).getComponents().length];
            for (int i = 0; i < this.components[n].length; ++i) {
                this.components[n][i] = ((ProblemModel)arrayList.get(n)).getComponents()[i].getClassName();
            }
        }
        this.problemSet = arrayList;
        this.users = new ArrayList();
        for (n = 0; n < this.ca.getModel().getComponentAssignmentData().getTeamMembers().size(); ++n) {
            this.users.add(this.ca.getModel().getComponentAssignmentData().getTeamMembers().get(n));
        }
        this.create();
    }

    public void updateChallengeTable(RoomModel roomModel) {
    }
}

