/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ContestSponsorPanel
extends JPanel {
    private static long REFRESHTIME = 900000L;
    private static String SUNGIF = "javaone_applet.gif";
    private LoadThread loadThread;

    public ContestSponsorPanel(ContestApplet contestApplet, String string) {
        this(contestApplet, contestApplet.getSponsorName().equals("TopCoder") ? null : (contestApplet.getSponsorName().startsWith("Sun") ? SUNGIF : null), string);
    }

    public ContestSponsorPanel(ContestApplet contestApplet, String string, String string2) {
        this.setOpaque(false);
        JLabel jLabel = string == null ? new JLabel() : new JLabel(Common.getImage(string, contestApplet));
        jLabel.setMinimumSize(new Dimension(300, 60));
        jLabel.setPreferredSize(new Dimension(300, 60));
        jLabel.setMaximumSize(new Dimension(300, 60));
        this.add(jLabel);
        if (string == null || string != null && string.equals("top_logo.gif")) {
            this.loadThread = new LoadThread(this, string2);
            this.loadThread.start();
        }
    }

    public void updateURL(String string) {
        this.loadThread.updateURL(string);
    }

    protected void finalize() throws Throwable {
        LoadThread loadThread = this.loadThread;
        if (loadThread != null) {
            loadThread.interrupt();
        }
    }

    public static class LoadThread
    extends Thread {
        private WeakReference panelRef;
        private String urlString;
        private Object mutex = new Object();
        private boolean mustReload = false;

        LoadThread(JPanel jPanel, String string) {
            this.panelRef = new WeakReference<JPanel>(jPanel);
            this.urlString = string;
            this.setName("SponsorPanel LoadThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.loadImageAndDisplayIt()) {
                try {
                    Object object = this.mutex;
                    synchronized (object) {
                        if (!this.mustReload) {
                            this.mutex.wait(REFRESHTIME);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadImageAndDisplayIt() {
            URL uRL;
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.mustReload = false;
                    uRL = new URL(this.urlString);
                }
                catch (Throwable throwable) {
                    return true;
                }
            }
            object = new JLabel();
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            MediaTracker mediaTracker = new MediaTracker((Component)object);
            mediaTracker.addImage(image, 1);
            try {
                mediaTracker.waitForID(1);
                JPanel jPanel = (JPanel)this.panelRef.get();
                if (jPanel == null) {
                    return true;
                }
                if (mediaTracker.statusID(1, true) != 8) {
                    mediaTracker.waitForID(1);
                }
                ((JLabel)object).setIcon(new ImageIcon(image));
                jPanel.removeAll();
                jPanel.add((Component)object);
                jPanel.revalidate();
                jPanel.repaint();
                JPanel jPanel2 = (JPanel)jPanel.getParent();
                if (jPanel2 != null) {
                    jPanel2.revalidate();
                    jPanel2.repaint();
                }
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateURL(String string) {
            Object object = this.mutex;
            synchronized (object) {
                this.urlString = string;
                this.mustReload = true;
                this.mutex.notifyAll();
            }
        }
    }
}

