/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.ChatPanel;
import com.topcoder.client.contestant.view.ChatView;
import com.topcoder.client.contestant.view.UserListListener;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class ChatTabbedPane
extends JTabbedPane
implements ChatView,
UserListListener {
    private ContestApplet ca = null;
    private ArrayList alItems = null;
    private ArrayList scopes = new ArrayList();
    private KeyAdapter ka = null;

    public ChatTabbedPane(ContestApplet contestApplet) {
        super(1);
        this.ca = contestApplet;
        this.alItems = new ArrayList();
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ChatTabbedPane.this.tabChanged();
            }
        });
        this.ka = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isAltDown()) {
                    switch (keyEvent.getKeyCode()) {
                        case 39: {
                            ChatTabbedPane.this.setSelectedIndex((ChatTabbedPane.this.getSelectedIndex() + 1) % ChatTabbedPane.this.getComponentCount());
                            break;
                        }
                        case 37: {
                            ChatTabbedPane.this.setSelectedIndex((ChatTabbedPane.this.getSelectedIndex() + ChatTabbedPane.this.getComponentCount() - 1) % ChatTabbedPane.this.getComponentCount());
                        }
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        };
        this.addKeyListener(this.ka);
    }

    public void updateUI() {
        this.setUI(new ChatTabbedPaneUI());
    }

    private void tabChanged() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getChatAt(i).leave();
            this.setForegroundAt(i, Common.STATUS_COLOR.darker());
        }
        this.setForegroundAt(this.getSelectedIndex(), Common.STATUS_COLOR);
        this.getSelectedChat().requestFocus();
        this.getSelectedChat().enter();
    }

    public void addChat(String string, int n) {
        this.scopes.add(new Integer(n));
        ChatPanel chatPanel = new ChatPanel(this.ca, string, n);
        chatPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        chatPanel.updateUserList(this.alItems.toArray(new UserListItem[0]));
        chatPanel.addKeyListener(this.ka);
        this.addTab(string, chatPanel);
        this.setBackgroundAt(this.getComponentCount() - 1, Color.darkGray);
        this.setForegroundAt(this.getComponentCount() - 1, Common.STATUS_COLOR.darker());
        if (this.getComponentCount() == 1) {
            this.fireStateChanged();
        }
    }

    private ChatPanel getSelectedChat() {
        return (ChatPanel)this.getSelectedComponent();
    }

    private ChatPanel getChatAt(int n) {
        return (ChatPanel)this.getComponentAt(n);
    }

    public void enter() {
        this.getSelectedChat().grabFocus();
        this.getSelectedChat().enter();
    }

    public void leave() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getChatAt(i).leave();
        }
    }

    public void clear() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getChatAt(i).clear();
        }
    }

    public void updateChat(String string, int n, String string2, int n2) {
        for (int i = 0; i < this.scopes.size(); ++i) {
            if ((Integer)this.scopes.get(i) != n2) continue;
            this.getChatAt(i).updateChat(string, n, string2, n2);
        }
    }

    public void updateChat(int n, String string, int n2) {
        for (int i = 0; i < this.scopes.size(); ++i) {
            if ((Integer)this.scopes.get(i) != n2) continue;
            this.getChatAt(i).updateChat(n, string, n2);
        }
    }

    public void updateUserList(UserListItem[] userListItemArray) {
        this.alItems.clear();
        this.alItems.addAll(Arrays.asList(userListItemArray));
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getChatAt(i).updateUserList(userListItemArray);
        }
    }

    class ChatTabbedPaneUI
    extends MetalTabbedPaneUI {
        ChatTabbedPaneUI() {
        }

        protected void installDefaults() {
            super.installDefaults();
            this.selectColor = Common.BG_COLOR;
            this.selectHighlight = Color.black;
            this.highlight = Color.darkGray;
            this.contentBorderInsets = new Insets(0, 0, 0, 0);
            this.tabAreaInsets = new Insets(0, 0, 0, 0);
        }
    }
}

